<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Core\Helpers;

use Mnv\Core\SortTable;
use Mnv\Models\Blocks;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;

/**
 * Class BlocksAdmin
 * @package Mnv\Admin\Controllers
 */
class BlocksAdmin extends AdminMnv
{

    public function fetch()
    {
        global $SECTIONS;

        $block = new Blocks($this->request);
        $block->sortTableId = $this->module;

        /** title */
        $this->smarty->assign('title', 'Инфоблоки');
        /** activeItem */
        $this->smarty->assign('activeItem', 'blocks');
        /** statuses */
        $statuses = lang('general:statuses');
        array_pop($statuses);
        $this->smarty->assign('statuses', $statuses);

        $sections = Helpers::getSectionBlock(0);
        $this->smarty->assign('sections', $sections);

        /** удалить */
        if ($this->action == 'remove') {
            try {
                $block->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // Блок удален
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $block->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }
        /** изменение статуса */
        else if ($this->action == 'status') {
            try {
                $block->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $block->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $block->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }
        /** сортировка */
        else if ($this->action == 'reorder') {
            $i = 0;
            $block->data = [];
            foreach ($block->blockIds as $blockId) {
                $i++;
                $block->id = $blockId;
                $block->data['orderBy'] = $i;
                $block->update($block->data);
            }

            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;

        }
        /** Сортировать таблицу */
        else if ($this->action === 'sort_table') {
            SortTable::init()->setSort($block->sortTableId, $block->sortBy, $block->sortOrder);
            $result = array('status' => 200, 'table' => $block->sortTableId, 'sortBy' => $block->sortBy, 'sortOrder' => $block->sortOrder);

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** Очистить сортировку таблицы */
        else if ($this->action === 'clear_sort_table') {
            SortTable::init()->clearSort($block->sortTableId);
            $result = array('status' => 200, 'table' => $block->sortTableId);

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        else {

            /** фильтровать контента */
            $block->filter = array_filter([
                'query'         => $this->query,
                'status'        => $this->filter['status'] ?? '',
                'section'       => $this->filter['section'] ?? '',
            ]);

            /** получение всего контента */
            $blocks = collect($block->all($this->limit, $this->page))->map(function ($item) use ($SECTIONS) {
                $item['section']     = $SECTIONS[$item['sectionId']] ?? array();

                return $item;
            })->all();

            /** pagination */
            $block->total();
            $pages = getPageNums($block->total, $this->page, $this->limit, 0, 4, 4, 0);

            /** вывод в шаблон результатов */
            $this->smarty->assign('totalBlocks', $block->total);
            $this->smarty->assign('blocks', $blocks);
            $this->smarty->assign('pageNums', $pages);
            $this->smarty->assign('sections', $sections);
            $this->smarty->assign('page', $this->page);

        }

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }



        /** Права доступа к данному шаблону */
        if ($this->permissions('blocks')) {
            return $this->smarty->fetch('views/blocks/blocks.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');


    }


}