<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Helpers;

use Mnv\Models\Content;
use Mnv\Models\ContentType;
use Mnv\Models\ContentTypeCustomField;
use Mnv\Models\Exceptions\NotUpdateContentException;
use Mnv\Models\Exceptions\NotInsertContentException;

/**
 * Class ContentAdmin
 * @package Mnv\Admin\Controllers
 */
class ContentAdmin extends AdminMnv
{

    public function fetch()
    {
        global $SECTIONS;

        $content = new Content($this->request);

        /** работа с галереей */
        $image    = $this->request->get('image', '');
        $gallery  = $this->request->get('gallery', '');
        $docs     = $this->request->get('docs', '');

        $imageIds = $this->request->get('imageIds', '');
        $fileIds = $this->request->get('fileIds', '');
        $imageId  = (int) $this->request->get('imageId', '');
        $picture  = $this->request->get('picture', '');

        $content->contentType = $this->module . 's';
        $contentType = ContentType::getContentType($content->contentType);
        /** title */
        $this->smarty->assign('title', $contentType['name']);
        $this->smarty->assign('modules', $contentType['modules']);
        /** activeItem */
        $this->smarty->assign('activeItem', $content->contentType);
        /** generate url for type content */
        $this->smarty->assign('generate_url', $this->adminUrl . '/' . $content->contentType);
        /** statuses */
        $statuses = lang('general:statuses');
        array_shift($statuses);
//        array_pop($statuses);
        $this->smarty->assign('statuses', $statuses);

        /** select isFeatured */
        $this->smarty->assign('paramIsFeatured', [
            0 => lang('general:no'),
            1 => lang('general:yes')
        ]);
        /** select commentsEnabled */
        $this->smarty->assign('paramSettingComments', [
            0   => lang('general:defaultComments'),
            -1  => lang('general:disableComments'),
            1   => lang('general:enableComments')
        ]);

        /** получить дополнительные поля по типу контента */
        $fields = collect(ContentTypeCustomField::contentTypeFields($contentType['typeId'], 'V'))->map(function ($item) {
            if ($item['type'] == 'R' || $item['type'] == 'S' || $item['type'] == 'С')
                $item['properties'] = ContentTypeCustomField::contentTypeFieldProperty('propertyId ASC', $item['fieldId']);

            return $item;
        })->all();

        $this->smarty->assign('fields', $fields);


        /** получить разделы данного типа контента */
        $sections = Helpers::getSectionContent(0, $content->contentType);
        if (count($sections) < 2) $this->errors['no_sections'] = true;
        $this->smarty->assign('sections', $sections);


        if ($this->action === 'add' || $this->action === 'edit') {

            $content->edit()->getFiles()->gettingInfoAboutUsers();
        }
        /** сохранение данных */
        else if ($this->action == 'save' || $this->action == 'apply') {

            /** проверка полей */
            if (empty($content->data['title'])) $this->errors['title'] = true;
            /** избранное */
            $content->data['isFeatured'] = $content->data['isFeatured'] ?? 0;
            /** тип контента */
            $content->data['contentType'] = $content->contentType;

            /** проверка доступных разделов для статей */
            if (empty($content->data['sectionId']) || empty($sections[$content->data['sectionId']])) {
                $this->errors['sectionId'] = true;
            }

            /** проверка fileName на совпадение / если пустой то fileName пропишется от последнего ID из таблицы + 1 */
            if ($fileName = $content->checkFileName($content->data['fileName'])) {
                if ($fileName == $content->data['fileName']) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $content->data['fileName'] = $fileName;
                }
            }

            /** основная картинка */
            $images['general'] = !empty($image) ? $image : null;
            /** включить / отключить галерею у данного контента */
            $content->data['enableGallery'] = isset($content->data['enableGallery']) ? 1 : 0;
            $images['gallery'] = !empty($gallery) ? $gallery : null;
            /** файлы */
            $images['docs'] = !empty($docs) ? $docs : '';

            /** если ошибок нет то можно продолжить дальше */
            if (empty($this->errors)) {
                /** построение url из полученного url раздела/fileName статьи . расширение файла из настроек  (html / htm)  */
                $content->data['url'] = $SECTIONS[$content->data['sectionId']]['path'] . '/'. $content->data['fileName'] . '.' . $this->config['file_extension'];

                try {
                    $content->prepare($content->data, $this->manager['userId']);
                    if (!empty($images['general'])) $content->addFiles($content->id, $images);
                    if (!empty($images['gallery'])) $content->addFiles($content->id, $images, 'gallery');
                    if (!empty($images['docs'])) $content->addFiles($content->id, $images, 'docs');

                   $this->messages['saved'] = true;

                } catch (NotInsertContentException | NotUpdateContentException $e) {
                    $this->errors['not_saved'] = true;
                }
            }


            $content->edit()->getFiles()->gettingInfoAboutUsers();

            if (empty($this->errors) && $this->action === 'save') {
                redirect($this->buildQueryString($content->contentType, ['page' => $this->page]));
            }
        }
        /** удаление основной картинки */
        else if ($this->action == 'deleteFile') {
            $result = $content->deleteFile($imageId)
                ? array('status' => 200, 'message' => lang('javascript:deletingFile'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:deletingFileError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** удаление основной картинки */
        else if ($this->action == 'editPictureInfo') {
            $response = $content->editPicture($imageId, $picture)
                ? array('status' => 200, 'title' => $content->result['title'], 'alias' => $content->result['alias'], 'description' => $content->result['description'], 'link' => $content->result['link'], 'position' => $content->result['position'])
                : array('status' => 400, 'title' => '', 'alias' => '', 'description' => '', 'link' => '', 'position' => '');

            response()->json($response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** сортировка картинок в галерее */
        else if ($this->action == 'sortPictures') {
            $result = $content->sortingPictures($imageIds)
                ? array('status' => 200, 'message' =>  lang('javascript:sortingImage'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:sortingImageError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        $totalPrice = 0;
        if (!empty($content->id)) {
            $content->data += $content->getCustomFieldsValues($content->id);
        }

        $this->smarty->assign('article', $content->data);
        $this->smarty->assign('totalPrice', $totalPrice);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);
        if (!empty($this->notice)) $this->smarty->assign('notice', $this->notice);


        if ($this->permissions($this->module .'s')) {
            try {
                return $this->smarty->fetch('views/contents/article.tpl');
            } catch (\SmartyException | \Exception $e) {
                print $e->getMessage();
            }
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }



}