<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;

use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;
use Mnv\Models\ContentType;
use Mnv\Models\ContentTypeCustomField;
use Mnv\Models\UserGroups;

/**
 * Class ContentTypeCustomFieldAdmin
 */
class ContentTypeCustomFieldAdmin extends AdminMnv
{

    public function fetch()
    {
        $field = new ContentTypeCustomField($this->request);

        $this->smarty->assign('activeItem','articles');
        $this->smarty->assign('title', 'Добавить поле');
        /** statuses */
        $this->smarty->assign('statuses', lang('general:statuses'));
        $this->smarty->assign('selectContentTypes', ContentType::selectContentTypes('typeId ASC', 'typeId', 'name'));
        /** type fields */
        $this->smarty->assign('typeFields', ContentTypeCustomField::getTypeFields());

        $this->smarty->assign('positions', array(
            '0' => 'Выберите расположение поля',
            'M' => 'Основное',
            'S' => 'Статус и видимость',
//            'T' => 'Описание'
        ));
        $this->smarty->assign('radioGroupPositions', array(
            '0' => 'Выберите расположение группы',
            'V' => 'Вертикально',
            'H' => 'Горизонтально'
        ));


        if ($this->action == 'edit' || $this->action == 'add') {

            $field->edit()->gettingInfoAboutUsers();

            $this->smarty->assign('field', $field->data);

            $field->getProperties();
            $this->smarty->assign('properties', $field->properties);
        }
        /** сохранение данных */
        elseif ($this->action == 'save' || $this->action == 'apply') {

            if (empty($field->data['name'])) $this->errors['name'] = true;
            if (empty($field->data['typeId'])) $this->errors['typeId'] = true;

            if (empty($field->data['fileName'])) $this->errors['fileName'] = true;

            if (preg_match('/[^a-zA-Z\-_\.,]/i', $field->data['fileName'])) $this->errors['fileNameCharacters'] = true;

            if ($fileName = $field->checkFileName($field->data['fileName'])) {
                if ($fileName == $field->data['fileName']) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $field->data['fileName'] = $fileName;
                }
            }

            if (empty($this->errors)) {
                if ($field->prepare($field->data, $this->manager['userId'])) {
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $field->edit()->gettingInfoAboutUsers();
            $this->smarty->assign('field', $field->data);
            $this->smarty->assign('properties', $field->properties);

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->buildQueryString("contenttype", ['action' => 'edit', 'id' => $field->typeId]));
            }

        }
        /** удаление */
        elseif ($this->action == 'remove') {
            try {
                $field->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // Тип контента удален
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $field->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** изменение статуса */
        elseif ($this->action === 'status') {
            try {
                $field->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $field->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $field->status, 'message' => $e->getMessage(), 'type' => 'error');
            }

            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** сортировка */
        elseif ($this->action == 'reorder') {
            $i = 0;
            $field->data = [];
            foreach ($field->fieldIds as $fieldId) {
                $i++;
                $field->id = $fieldId;
                $field->data['orderBy'] = $i;
                $field->update($field->data);
            }
            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;
        }


        $this->smarty->assign('fields', $field->all($this->limit = 50, $this->page));
        $this->smarty->assign('typeId', $field->typeId);


        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        /** Права доступа к данному шаблону */
        if ($this->manager['userType'] == UserGroups::DEVELOPER) {
            return $this->smarty->fetch('views/contents/field.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }
}



