<?php

namespace Mnv\Admin\Controllers;

use Mnv\Core\AdminMnv;
use Mnv\Models\UserGroups;

/**
 * Class DocumentCsrfAdmin
 * @package Mnv\Admin\Controllers
 */
class DocumentCsrfAdmin extends AdminMnv
{

    public function fetch()
    {
        $this->smarty->assign('activeItem', 'csrf');
        $this->smarty->assign('title', 'Security Csrf Token');


        try {
            if ($this->manager['userType'] == UserGroups::DEVELOPER) {
                return $this->smarty->fetch('views/documents/csrf.tpl');
            }

            $this->smarty->assign('title', 'Access Denied');
            return $this->smarty->fetch('accessIsDenied.tpl');

        } catch (\SmartyException | \Exception $e) {
            return $e->getMessage();
        }
    }

}