<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use DateTime;
use Mnv\Core\AdminMnv;

use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;
use Mnv\Models\Feedbacks;

/**
 * Class FeedbacksAdmin
 * @package Mnv\Admin\Controllers
 */
class FeedbacksAdmin extends AdminMnv
{

    public function fetch()
    {

        $feedback = new Feedbacks($this->request);

        $this->smarty->assign('activeItem','feedbacks');
        $this->smarty->assign('title', 'Центр сообщений');

        /** statuses */
        $collection = collect([' ' => 'Выберите...']);
        $statuses = $collection->merge(array_slice(lang('comments:statuses'), 1))->all();
        $this->smarty->assign('statuses', $statuses);

        $this->smarty->assign('types', $feedback->getFormTypes());

        /** удаление */
        if ($this->action == 'remove') {
            try {
                $feedback->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // Письмо удалено
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $feedback->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** изменение статуса */
        elseif ($this->action == 'status') {
            try {
                $feedback->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $feedback->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $feedback->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        /** фильтровать контента */
        $feedback->filter = array_filter([
            'status'        => $this->filter['status'] ?? '',
            'type'          => $this->filter['type'] ?? '',
            'query'         => $this->query,
        ]);

        // Подготовка
        $currentDate = new DateTime();

        $feedbacks = collect($feedback->all($this->limit, $this->page))->map(function ($item) use ($currentDate) {
            $item['statusName'] = lang('comments:statuses:'.$item['status']);
            $item['created'] =  langDate(adjustTime($item['created'], false, 'd.m.Y H:i'));
            // Проверка на файл
            if (!empty($item['file'])) {
                $filePath = GLOBAL_ROOT . $item['file'];
                // Минимизируем обращение к файловой системе
                $item['fileSize'] = is_readable($filePath) ? formatsize(filesize($filePath)) : 'Unknown';
            }

            // Вычисление разницы в днях
            $createdDate = DateTime::createFromFormat('d.m.Y H:i', $item['created']);
            $dateKey = $createdDate->format('d.m.Y'); // Форматируем только дату без времени
            $daysDifference = $currentDate->diff(DateTime::createFromFormat('d.m.Y', $dateKey))->days;
            $item['daysAgo'] = (int) $daysDifference;

            return $item;
        })->all();

        $feedbackDays = collect($feedbacks)->groupBy('daysAgo')->toArray();
//print_r($feedbacks);

        $feedback->total();
        $pages = getPageNums($feedback->total, $this->page, $this->limit, 0, 4, 4, 0 );

//        $this->smarty->assign( 'feedbacks', $feedbacks);
        $this->smarty->assign( 'feedbackDays', $feedbackDays);
        $this->smarty->assign( 'pageNums', $pages);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);

        if ($this->permissions('feedbacks')) {
            return $this->smarty->fetch('views/feedbacks/feedbacks.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }

}