<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Validations\ValidateEmail;
use Mnv\Core\Validations\Exceptions\InvalidEmailException;

use Mnv\Models\User;
use Mnv\Models\UserGroups;

/**
 * Class ManagerAdmin
 * @package Mnv\Admin\Controllers
 */
class ManagerAdmin extends AdminMnv
{

    /**
     * Вывод всех пользователей
     */
    public function fetch()
    {
        $adminUser = new User($this->request);

        $this->smarty->assign('activeItem', 'managers');
        $this->smarty->assign('title', lang('managers:title'));

        $this->smarty->assign('statuses', array_slice(lang('managers:statuses'), 1, 3, true));
        $this->smarty->assign('genders', lang('users:genders'));
        $this->smarty->assign('choices', lang('general:choice'));
        $this->smarty->assign('groups', UserGroups::selectGroup($this->manager['groupId']));

        $image    = $this->request->get('image', '');
        $imageId  = (int) $this->request->get('imageId');


        if ($this->action == 'add' || $this->action == 'edit') {
            $adminUser->edit()->getFiles();

        }
        /** сохранение данных */
        elseif ($this->action == 'save' || $this->action == 'apply') {

            if (empty($adminUser->data['groupId'])) $this->errors['access_level_empty'] = true;
            if (empty($adminUser->data['status'])) $this->errors['status_empty'] = true;

            if (!empty($adminUser->data['groupId'])) {
                $adminUser->data['userType'] = UserGroups::getGroupLetter($adminUser->data['groupId']);
            } else {
                $this->errors['access_level_empty'] = true;
            }


            /** loginName */
            if (!empty($adminUser->data['loginName'])) {
                $adminUser->data['loginName'] = str_replace(" ", '', $adminUser->data['loginName']);
                if (empty($adminUser->data['loginName']) || preg_match('/[^a-zA-Z0-9]/', $adminUser->data['loginName'])) $this->errors['loginName'] = true;
            } else {
                $this->errors['login_empty'] = true;
            }

            /** проверяем существование loginName */
            if ($fileName = $adminUser->checkExistenceLoginName($adminUser->data['loginName'])) {
                if ($fileName == $adminUser->data['loginName']) {
                    $this->errors['login_exists'] = true;
                } else {
                    $adminUser->data['loginName'] = $fileName;
                }
            }

            /** fullName */
            $adminUser->data['fullName']  = trim($adminUser->data['fullName']);
            if (empty($adminUser->data['fullName']) || preg_match('/[^[а-яА-ЯёЁa-zA-Z0-9]+$]/', $adminUser->data['fullName'])) {
                $this->errors['fullName'] = true;
            }

            /** email */
            if (!empty($adminUser->data['email'])) {
                try {
                    ValidateEmail::fromString($adminUser->data['email']);
                } catch (InvalidEmailException | \InvalidArgumentException $error) {
                    $this->errors['invalid_email'] = true;
                }
            } else {
                $adminUser->data['email'] = null;
            }
            $adminUser->data['verified'] = ($adminUser->data['status'] == 3) ? 0 : 1;
            $adminUser->data['receiveEmails'] = !empty($adminUser->data['receiveEmails']) ? 1 : 0;

            /** password */
            if (empty($adminUser->id) && empty($adminUser->data['password'])) {
                $this->errors['password'] = true;
            }
            /** fileId */

            $images['general'] = !empty($image) ? $image : null;

            // получить старые данные для стравнения
            if (!empty($adminUser->id)) {
                $adminUser->getOldDataUser($adminUser->id);
                if (empty($adminUser->oldUser)) {
                    $this->errors['user_not_found'] = true;
                }
            }

            if (!empty($adminUser->data['userType'])) {
                // 1. Проверка, что менеджер может менять группу у любого пользователя, кроме пользователей с ID 1 или 2
                if ($this->manager['userType'] === UserGroups::DEVELOPER) {
                    if (in_array($adminUser->id, [1, 2], true)) {
                        $this->errors['restricted_user_ids'] = true;
                    }
                }

                // 2. Проверка, что менеджер `ADMIN` не может создавать пользователя с группой `DEVELOPER`
                if ($this->manager['userType'] === UserGroups::ADMIN) {
                    if ($adminUser->data['userType'] === UserGroups::DEVELOPER && empty($adminUser->oldUser['userType'])) {
                        $this->errors['no_developer_creation'] = true;
                    }
                }

                // 3. Нельзя изменять группу `ADMIN` у последнего пользователя с группой `ADMIN`
                if (!empty($adminUser->id) && !empty($adminUser->oldUser['userType']) &&
                    $adminUser->oldUser['userType'] === UserGroups::ADMIN &&
                    $adminUser->data['userType'] !== UserGroups::ADMIN) {

                    // Проверяем, есть ли другие пользователи с группой `ADMIN`
                    $hasOtherAdmins = $adminUser->hasOtherAdmins($adminUser->id); // Методу передаем ID текущего пользователя
                    if (!$hasOtherAdmins) {
                        $this->errors['last_admin'] = true;
                    }
                }
            }

            if (empty($this->errors)) {
                if ($adminUser->prepare($adminUser->data, $this->manager['userId'])) {
                    if (!empty($images['general']))  $adminUser->addFiles($adminUser->id, $images);

                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }

                if (empty($this->errors) && $this->action == 'save') {
                    redirect($this->buildQueryString("managers", ['page' => $this->page]));
                }
            }

            $adminUser->edit()->getFiles();

        }
        /** удаление (основной картинки / из галереи / docs */
        elseif ($this->action == 'deleteFile') {
            $result = $adminUser->deleteFile($imageId)
                ? array('status' => 200, 'message' => lang('javascript:deletingFile'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:deletingFileError'), 'type' => 'error');

             response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
             exit();
        }


        $this->smarty->assign('user', $adminUser->data);
        $this->smarty->assign('action', $this->action);


        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('managers')) {
            return $this->smarty->fetch('views/users/manager.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }


}
