<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\UserGroups;

/**
 * Class ManagerGroupAdmin
 * @package Mnv\Admin\Controllers
 */
class ManagerGroupAdmin extends AdminMnv
{

    public function fetch()
    {

        $userGroup = new UserGroups($this->request);

        $this->smarty->assign('activeItem', 'groups');
        $this->smarty->assign('title', "Группы пользователей");

        $this->smarty->assign('choices', lang('general:choice'));
        $this->smarty->assign('statuses', array_slice(lang('general:statuses'), 1, 2));

        $groups = $userGroup->groups;
        if ($this->manager['userType'] != UserGroups::DEVELOPER) {
            array_shift($groups);
        }

        $this->smarty->assign('groups', $groups);

        $this->smarty->assign('permission', $this->accessRights());

        if ($this->action == 'add' || $this->action == 'edit') {

            $userGroup->edit()->gettingInfoAboutUsers();
        }
        /** сохранение данных */
        elseif ($this->action == 'save' || $this->action == 'apply') {

            /** name */
            if (empty($userGroup->data['name'])) $this->errors['nameEmpty'] = true;
            if (empty($userGroup->data['fileName'])) $this->errors['fileNameEmpty'] = true;
            if (empty($userGroup->data['hasAdminAccess']) && $userGroup->data['hasAdminAccess'] === 1) {
                if (empty($userGroup->privileges)) $this->errors['privilegesEmpty'] = true;
            }

            /** проверяем существование loginName */
            if (preg_match('/[^A-Z]/', $userGroup->data['fileName'])) $this->errors['fileNameCharacters'] = true;
            if ($fileName = $userGroup->checkFileName($userGroup->data['fileName'])) {
                if ($fileName == $userGroup->data['fileName']) {
                    $this->errors['fileNameExists'] = true;
                } else {
                    $userGroup->data['fileName'] = $fileName;
                }
            }

            $userGroup->data['letter'] = strtoupper(substr($userGroup->data['fileName'], 0, 1)) ;

            if (empty($this->errors)) {
                if ($userGroup->prepare($userGroup->data, $this->manager['userId'])) {
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $userGroup->edit()->gettingInfoAboutUsers();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->buildQueryString("groups", ['page' => $this->page]));
            }

        }

        $this->smarty->assign('group', $userGroup->data);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        if ($this->permissions('groups')) {
            return $this->smarty->fetch('views/users/group.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }


}
