<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}


use Mnv\Core\Helpers;
use Mnv\Core\AdminMnv;
use Mnv\Core\SerializationManager;
use Mnv\Core\Test\Logger;

use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;
use Mnv\Models\Sections;
use Mnv\Models\ContentType;
use Mnv\Models\Users\UserSettingOption;

/**
 * Class SectionsAdmin
 * @package Mnv\Admin\Controllers
 */
class SectionsAdmin extends AdminMnv
{

    public function fetch()
    {
        global $SECTIONS;

        $build = new SerializationManager();
        $section = new Sections($this->request);

        $this->smarty->assign('title', lang('sections:title'));
        $this->smarty->assign('activeItem', 'sections');

        $addContents = ContentType::selectContentTypes('typeId ASC', 'fileName', 'name');
        if (!empty($addContents))   $section->contentTypes += $addContents;
        $this->smarty->assign('contentTypes', $section->contentTypes);

        /** подтвердить удаление */
        if ($this->action == 'confirmDelete') {
            /** проверить сущестуют ли у этого раздела подразделы и контент */
            if ($section->remove()) {

                if ($section->data['hasSubsections']) {
                    $subsectionOptions = array('delete' => lang('general:delete'));
                    $subsectionOptions[0] = lang('sections:moveToRoot');
                    $subsectionOptions += Helpers::getSectionOptions($section->id);
                    foreach ($subsectionOptions as $key => $name) {
                        if ($key > 0) {
                            $subsectionOptions[$key] = lang('sections:moveTo') . ': ' . $name;
                        }
                    }
                    $this->smarty->assign('subsectionOptions', $subsectionOptions);
                }

                if ($section->data['hasArticles']) {
                    $articleOptions = array('delete' => lang('general:delete'));
                    $articleOptions += Helpers::getSectionOptions($section->id);
                    foreach ($articleOptions as $key => $name) {
                        if ($key > 0) {
                            $articleOptions[$key] = lang('sections:moveTo') . ': ' . $name;
                        }
                    }
                    unset($articleOptions[0]);
                    $this->smarty->assign('articleOptions', $articleOptions);
                }

                $this->smarty->assign('section', $section->data);

            } else {

                $this->errors['section_not_found'] = true;
            }

        }
        /** удаление после подтверждения */
        elseif ($this->action == 'deleteConfirmed') {

            if (!empty($section->id)) {
                if ($section->deleteConfirmed($section->param)) {
                    Logger::init()->info("Раздел «" . $section->data['name'] . "» удален", $this->manager['userId'])->save();
                    $this->messages['deleted'] = true;
                }
                if (!$build->saveSerializations()) $this->errors['serializations'] = true;
                if (!$build->writeHtaccess()) $this->errors['htaccess'] = true;
            } else {
                $this->errors['section_not_found'] = true;
            }
        }
        /** отобразить или скрыть с главного меню */
        elseif ($this->action == 'menu') {

            if ($section->menuSection() && !$build->saveSerializations()) $this->errors['serializations'] = true;

            response()->json($section->result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();

        }
        /** изменение статуса */
        elseif ($this->action == 'status') {

            try {
                $section->status();
                if (!$build->saveSerializations()) $this->errors['serializations'] = true;
                if (!$build->writeHtaccess()) $this->errors['htaccess'] = true;
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $section->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $section->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** сортировать при перемещение */
        elseif ($this->action == 'reorder') {

            $ids = array_values($section->sectionIds);
            sort($section->sectionIds);
            $section->reorder($ids, $section->sectionIds);

            if (!$build->saveSerializations()) $this->errors['serializations'] = true;
            if (!$build->writeHtaccess()) $this->errors['htaccess'] = true;

            response()->json(array('status' => 200), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
        }

        if (!empty($section->parentId) && !connect('sections')->count('*', 'count')->where('parentId', $section->parentId)->getValue()) {
            $section->parentId = (int) connect('sections')->select('parentId')->where('sectionId', $section->parentId)->getValue();
            redirect($this->buildQueryString("sections", array_filter(['parentId' => $section->parentId, 'page' => $this->page])));

            die (lang('sections:noSubsections'));
        }

        /** получать информацию о родительском разделе */
        if ($section->parentId > 0) {
            $parent = $SECTIONS[$section->parentId];
            if ($parent['parentId'] > 0) {
                $parent['parent'] = $SECTIONS[$parent['parentId']];
            }
            $this->smarty->assign('parent', $parent);
        }


        /** получение всех разделов */
        $listSections = $section->all($this->limit, $this->page);
        $sections = collect($listSections)->map(function ($item, $i) use ($listSections, $SECTIONS, $section) {
            $item['typeName']           = lang('sections:types:' . $item['type']);
            $item['contentTypeName']    = $section->contentTypes[$item['contentType']] ?? null;
            if (($this->page > 1 && $i == 0) || (($i - $this->limit >= 0) && ($i == count($listSections) - 1))) $item['isHidden'] = true;
            $item['hasSubsections']  = !empty($SECTIONS[$item['sectionId']]['children']);

            return $item;
        })->all();


        /** pagination */
        $section->total();
        $pages = getPageNums($section->total, $this->page, $this->limit, 0, 4, 4, 0);

//        print_r($this->sections);
        /** вывод в шаблон результатов */
        $this->smarty->assign('pageNums', $pages);
        $this->smarty->assign('sections', $sections);
        $this->smarty->assign('parentId', $section->parentId);


        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }


        if ($this->permissions('sections')) {
            return $this->smarty->fetch('views/sections/sections.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }

}