<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\Stats;

/**
 * Class StatsErrorsAdmin
 * @package Mnv\Admin\Controllers
 */
class StatsErrorsAdmin extends AdminMnv
{

    public function fetch()
    {
        $stats = new Stats();
        $dateSelector       = new StatsDateSelector(false, null);
        $errorCodeSelector  = new StatsErrorCodeSelector();

        $this->smarty->assign('activeItem','errors');
        $this->smarty->assign('title', lang('stats:errorsTitle'));

        $errors = $stats->getStatsErrors($dateSelector->dateStart, $dateSelector->dateEnd, $errorCodeSelector->filterErrorCode, $this->limit, $this->page);
        if (!empty($errors)) foreach($errors as $i => $error) {
            if (!empty($error['referer'])) $errors[$i] += $stats->parseReferer($error['referer']);
        }

        /* page numbering */
        $totalItems = $stats->getTotalStatsErrors($dateSelector->dateStart, $dateSelector->dateEnd, $errorCodeSelector->filterErrorCode);

        $pages = getPageNums($totalItems, $this->page, $this->limit, 0, 4, 4, 0);

        $this->smarty->assign('filterErrorCodeOptions', $errorCodeSelector->get());
        $this->smarty->assign('filterErrorCode', $errorCodeSelector->filterErrorCode);
        $this->smarty->assign('errors', $errors);
        $this->smarty->assign('pageNums', $pages);
        $this->smarty->assign('totalItems', $totalItems);
        $this->smarty->assign('page', $this->page);

        if ($this->permissions('errors')) {
            return $this->smarty->fetch('views/stats/errors.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }
}
