<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;

use Mnv\Models\Stats;

/**
 * Class StatsOverviewAdmin
 * @package Mnv\Admin\Controllers
 */
class StatsOverviewAdmin extends AdminMnv
{

    public function fetch()
    {
        $stats = new Stats();
        $dateSelector = new StatsDateSelector(true, null);

        $this->smarty->assign('activeItem', 'overview');
        $this->smarty->assign('title', lang('stats:overviewTitle'));

        /** Обновить статистику если были посещения */
        $stats->updateStatsCacheDaily();

        /** получение статистики */
       $stats->getStatDays($dateSelector->dateStart, $dateSelector->dateEnd);
        $stats->stat['visitors']  = 0;
        $stats->stat['visits']    = 0;
        $stats->stat['rssVisits'] = 0;
        if (!empty($stats->days)) {
            foreach ($stats->days as $i => $row) {
                $stats->days[$i]['date'] = langDate(date($stats->dateFormat, strtotime($row['cacheDate'])));
                $stats->stat['visitors']  += $row['newVisitors'] + $row['retVisitors'];
                $stats->stat['visits']    += $row['articleVisits'] + $row['sectionVisits'] + $row['searchVisits'];
                $stats->stat['rssVisits'] += $row['rssVisits'];
            }
        }

        $this->smarty->assign('days', $stats->days);
        $this->smarty->assign('totals', $stats->stat);

        if ($this->permissions('overview')) {
            return $this->smarty->fetch('views/stats/overview.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }
}

