<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Database\Throwable\DatabaseException;
use Mnv\Core\SortTable;

use Mnv\Models\Exceptions\NoContentException;
use Mnv\Models\Exceptions\NotFoundException;
use Mnv\Models\User;
use Mnv\Models\UserGroups;

/**
 * Class UsersAdmin
 * @package Mnv\Admin\Controllers
 */
class UsersAdmin extends AdminMnv
{

    public function fetch()
    {
        $siteUser = new User($this->request);
        $siteUser->sortTableId = $this->module;

        /** Заголовок, название подключаемого шаблона */
        $this->smarty->assign('activeItem','users');
        $this->smarty->assign('title', lang('users:title'));

        $this->smarty->assign('statuses', lang('users:statuses'));
        $this->smarty->assign('subscribes', lang('users:subscribes'));

        /** удаление */
        if ($this->action === 'remove') {
            try {
                $siteUser->remove();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => 200, 'message' => 'Запись была успешно удалена.', 'type' => 'success'); // lang('socials:messages:1')
            } catch (DatabaseException|NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $siteUser->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** изменение статуса */
        elseif ($this->action == 'status') {
            try {
                $siteUser->status();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status, 'data' => $siteUser->status, 'message' => lang('general:restatus'), 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'data' => $siteUser->status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** одобрение */
        elseif ($this->action === 'approve') {
            try {
                $siteUser->approve();
                $status = \Mnv\Http\Response::HTTP_OK;
                $response = array('status' => $status,'message' => 'Пользователь был одобрен без предварительной модерации.', 'type' => 'success');
            } catch (NoContentException|NotFoundException $e) {
                $status =  \Mnv\Http\Response::HTTP_FORBIDDEN;
                $response = array('status' => $status, 'message' => $e->getMessage(), 'type' => 'error');
            }
            response()->json($response, $status, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        /** Сортировать таблицу */
        elseif ($this->action === 'sort_table') {
            SortTable::init()->setSort($siteUser->sortTableId, $siteUser->sortBy, $siteUser->sortOrder);
            $result = array('status' => 200, 'table' => $siteUser->sortTableId, 'sortBy' => $siteUser->sortBy, 'sortOrder' => $siteUser->sortOrder);

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        /** Очистить сортировку таблицы */
        elseif ($this->action === 'clear_sort_table') {
            SortTable::init()->clearSort($siteUser->sortTableId);
            $result = array('status' => 200, 'table' => $siteUser->sortTableId);

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        $siteUser->filter = array_filter([
            'status'        => $this->filter['status'] ?? '',
            'query'         => $this->query,
            'userType'      => UserGroups::CUSTOMER,
        ]);

        /** получение всех менеджеров с картинками */
        $users = $siteUser->all($this->limit, $this->page);
        $users = collect($users)->map(function ($item) {
            $item['statusName'] = lang('managers:statuses:' . $item['status']);

            $item['registered'] = langDate(adjustTimeNew($item['registered'], false, 'Y-m-d H:i'));
            return $item;
        })->all();

        /* получение кол-во менеджеров */
        $siteUser->total();
        $pages = getPageNums($siteUser->total, $this->page, $this->limit, 0, 4, 4, 0);
        
        $this->smarty->assign('pageNums', $pages);
        $this->smarty->assign('users', $users);
        $this->smarty->assign('page', $this->page);

        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        /** Права доступа к данному шаблону */
        if ($this->permissions('users')) {
            return $this->smarty->fetch('views/users/users.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }
}




