{literal}

<script>

	// конфигурация
	const maxFiles = 24
	window.locales = {
		en: window.en, // предполагается, что `en-en.js` экспортирует объект как `window.en`
		ru: window.ru,  // предполагается, что `ru-ru.js` экспортирует объект как `window.ru`
		uz: window.uz  // предполагается, что `uz-uz.js` экспортирует объект как `window.uz`
	};

	let modal_block_show = false,
        countSelected = 0;

	const attachmentDetails = document.querySelector('.attachment-details');
	const selectMime = document.querySelector("#attachment_filters_mime");
	const selectFilter = document.querySelector("#attachment_filters");

	const readMoreButton = document.querySelectorAll('.read-more');
	const mediaActions = document.querySelector('.media-actions')
	const mediaSearch = document.querySelector('.media-search')


	function capitalize(s) {
		return s[0].toUpperCase() + s.slice(1);
	}

	// название функции переименовывать нельзя (подвязно к tinymce)
	function media_content(path, type) {

		$("#media").modal('show');
		// set parameters in localStorage
		settingPath(path, 1);
		localStorage.setItem('type', type);
		const breadcrumbPath = document.querySelector('.breadcrumb_path');
		let prevLink = "";

		// Первая крошка - "Uploads"
		breadcrumbPath.innerHTML = `<a href="index.php?mod=uploads&path=/" data-path="/" class="breadcrumb-item read-more">Uploads</a>`;
		if (path) {
			const pathSegments = path.split('/').filter(item => item.length > 0); // Исключаем пустые элементы

			const breadcrumbItems = pathSegments.map((item) => {
				prevLink += `/${item}`; // Формируем путь для каждой крошки
				return `<a href="index.php?mod=uploads&path=${prevLink}"  data-path="${prevLink}"  class="breadcrumb-item read-more">${capitalize(item)}</a>`;
			}).join(''); // Объединяем элементы в одну строку

			breadcrumbPath.innerHTML += breadcrumbItems;

			// Скрытие деталей вложений
			if (attachmentDetails) {
				attachmentDetails.classList.add('d-none');
			}

			// Установка типа данных для кнопки добавления
			const addButton = document.querySelector(".add-content");
			if (addButton) {
				addButton.setAttribute('data-type', localStorage.getItem('type') || '');
			}
		}

		fetchDataToHTML();
	}

	function settingPath(path, page) {
		const modalShowMoreTrigger = document.querySelector('#modal_show_more_trigger'),
				inputSearch = document.querySelector('#search_file'),
				newDirectoryButton = document.querySelector('.new_folder');

		localStorage.setItem('path', path);
		localStorage.setItem('page', page);

		newDirectoryButton.setAttribute("data-path", localStorage.getItem('path'));
		modalShowMoreTrigger.setAttribute('data-page', localStorage.getItem('page'));
		modalShowMoreTrigger.setAttribute("data-path", localStorage.getItem('path'));

		let searchQuery = localStorage.getItem('query');
		if (searchQuery) {
			inputSearch.value = searchQuery;
		}
	}

	// установить кол-во выбранных элементов
	function selectCount(count) {
		const countCheck = document.querySelector('.count_check')

		if (count > 0) {
			mediaActions.classList.remove('d-none')
			countCheck.innerHTML  = 'Выделено (<b>' + count + '</b>)';
		} else {
			mediaActions.classList.add('d-none')
			mediaSearch.classList.remove('d-none')
		}
	}


	// генерация UUID
	function generateUUID() {

		if (crypto && crypto.randomUUID) {
			return crypto.randomUUID();
		} else {
			return ([1e7] + -1e3 + -4e3 + -8e3 + -1e11)
					.replace(/[018]/g, (c) =>
							(c ^ (crypto.getRandomValues(new Uint8Array(1))[0] & (15 >> (c / 4)))).toString(16)
					);
		}
	}

	const inputElement = document.querySelector('input.filepond');

	// Пример использования локализаций в другом JS файле
	const currentLocale = window.locales.{/literal}{$config.website_language}{literal} ?? window.locales.en;

	FilePond.setOptions(currentLocale)
	FilePond.registerPlugin(
			FilePondPluginImagePreview,
			FilePondPluginImageExifOrientation,
			FilePondPluginFileValidateSize,
			// FilePondPluginImageEdit,
			FilePondPluginFileValidateType,
			FilePondPluginMediaPreview
	);

	const handleRequestError = (response, error) => {
		if (!response.ok) {

			new Noty({ text: error, type: 'error' }).show();
			throw new Error(error);
		}
	};

	const pond = FilePond.create(inputElement, {
		name: 'file',
		maxFiles: maxFiles,
		maxFileSize: '{/literal}{$post_max_size|extract_int}{literal}MB',
		required: true,
		credits: false,
		allowMultiple: true,
		allowBrowse: true,

		allowImagePreview: true,
		allowImageFilter: true,
		imagePreviewHeight: 150,
		allowFileEncode: true,
		allowFileMetadata: true,
		allowImageTransform: true,
		allowImageResize: true,

		// imageResizeMode: 'cover',
		// imageCropAspectRatio: null,
		// imageResizeTargetHeight: null,
		// imageResizeTargetWidth: null,
		// imageResizeUpscale: true,

		allowVideoPreview: true,
		allowAudioPreview: true,
		mediaPreviewHeight: 150,
		mediaPreviewAutoplay: false,
		mediaPreviewThumbnail: false,

		allowRevert: true,
		acceptedFileTypes: null,
		allowFileTypeValidation: true,
		loadingIndicatorPosition: 'right',
		panelAspectRatio: null,
		panelLayout: 'compact',
		placeholder: null,
		maxSize: null,
		minSize: null,
		removeUploadedFileButtonPosition: 'left',
		shouldAppendFiles: false,
		shouldOrientImageFromExif: true,
		shouldTransformImage: false,
		uploadButtonPosition: 'right',
		uploadProgressIndicatorPosition: 'right',

		server: {
			process: async (fieldName, file, metadata, load, error, progress, abort, transfer, options) => {
				const uuid = generateUUID();
				const path = localStorage.getItem('path');
				const formData = new FormData();

				formData.append(fieldName, file, file.name);
				formData.append('uuid', uuid);
				formData.append('action', 'upload');
				formData.append('path', path);

				try {
					const response = await fetch('/admin/uploads', {
						method: 'POST',
						body: formData
					});

					const json = await response.json();
					// console.log("process =>", json);
					handleRequestError(response, json.message);
					// сообщение об успешной загрузки
					// new Noty({ text: json.message, type: json.type }).show();

					load(json);
					await fetchDataToHTML();
				} catch (err) {
					error(err.message);
				}

				return {
					abort: () => {
						abort();
					},
				};
			},
			revert: async (uniqueFileId, load, error) => {
				try {
					const fileId = JSON.parse(uniqueFileId).fileId;
					const response = await fetch('/admin/uploads?action=remove', {
						method: 'DELETE',
						headers: { 'Content-Type': 'application/json' },
						body: JSON.stringify({ fileIds: [fileId] })
					});

					handleRequestError(response, 'Failed to remove file');
					load();
					await fetchDataToHTML();
				} catch (err) {
					error('Failed to remove the file: ' + err.message);
				}
			},

			load: async (source, load, error, progress, abort, headers) => {
				try {
					const response = await fetch(source);
					handleRequestError(response, 'Failed to load file');

					const blob = await response.blob();
					headers(response.headers);
					progress(true, blob.size, blob.size);
					load(blob);
				} catch (err) {
					error('Failed to load file: ' + err.message);
				}
			},

			fetch: async (url, load, error, progress, abort, headers) => {
				try {
					const response = await fetch(url);
					handleRequestError(response, 'Failed to fetch file');

					const blob = await response.blob();
					headers(response.headers);
					load(blob);
				} catch (err) {
					error('Failed to fetch file: ' + err.message);
				}
			},

			restore: async (uniqueFileId, load, error, progress, abort, headers) => {
				try {
					const url = `/admin/uploads?action=&fileId=${JSON.parse(uniqueFileId).fileId}`;
					const response = await fetch(url);

					handleRequestError(response, 'Failed to restore file');

					const blob = await response.blob();
					headers(response.headers);
					load(blob);
				} catch (err) {
					error('Failed to restore file: ' + err.message);
				}
			},
			remove: async (source, load, error) => {
				try {
					const fileId = JSON.parse(source).fileId;
					const response = await fetch('/admin/uploads?action=remove', {
						method: 'DELETE',
						headers: { 'Content-Type': 'application/json' },
						body: JSON.stringify({ fileIds: [fileId] })
					});

					handleRequestError(response, 'Failed to remove file');
					load();
					await fetchDataToHTML();
				} catch (err) {
					error('Failed to remove file: ' + err.message);
				}
			},
		}
	});

	// ошибка о максимальном кол-ве
	pond.on('warning', (error, file) => {
		if (error.body === 'Max files') {
			// Show error message when maxFiles is exceeded
			new Noty({ text: currentLocale.maximumNumberFiles.replace('{maxFiles}', maxFiles), type: 'error' }).show();
		}
	});

	// скрытие после загрузки
	pond.on('processfile', (error, file) => {
		if (!error) {
			setTimeout(() => {
				pond.removeFile(file.id);
			}, 2500);
		} else {
			console.log('Image preview failed:', error);
		}
	});

	let type;

	//загрузка всех данных по пути
	$(document).on('click', '.read-more', function(e) {
		e.preventDefault();
		let element = $(this);
		modal_block_show = false;
		localStorage.setItem('page', element.data('type'))

		if (element.data('type') === undefined) {
			type = localStorage.getItem('type')
		} else {
			localStorage.setItem('type', element.data('type'))
			type = localStorage.getItem('type')
		}

		media_content (element.data('path'), type)
	});

	// читать файл
	document.addEventListener('click', async (e) => {
		let selectCardItem = e.target.closest('.card_file_item')

		if (selectCardItem) {
			let type = document.querySelector('.add-content').getAttribute('data-type'), template, fileIds = [];
			let element = selectCardItem.closest('.file-manager-list');

			if (type == 'image') {
				document.querySelectorAll('#file_list > figure.file-manager-list.selected').forEach(item => {
					item.classList.remove("selected", "details")
					item.children[0].classList.remove("border-primary", "border-opacity-50")
				})

				element.classList.add('selected', 'details');
				element.children[0].classList.add('border-primary', 'border-opacity-50');

				fileIds.push(selectCardItem.getAttribute('data-id'));
			} else {
				element.classList.toggle('selected');
				element.classList.toggle('details');
				element.children[0].classList.toggle('border-primary');
				element.children[0].classList.toggle('border-opacity-50');

				mediaActions.classList.remove('d-none')
				mediaSearch.classList.add('d-none')
				document.querySelectorAll('#file_list > figure.file-manager-list.selected')
						.forEach(item => fileIds.push(item.getAttribute('data-id')))
			}

			if (fileIds.length == 0) {
				mediaSearch.classList.remove('d-none')
			}
			selectCount(fileIds.length);
			if (fileIds.length > 0 && fileIds.length < 2) {
				let data = await fetchDataToJSON('load_file', {fileIds: fileIds, path: localStorage.getItem('path')});
				data.forEach(function (item) {
					previewTemplate(item);
					attachmentDetails.classList.remove('d-none')
				})
			} else {
				attachmentDetails.classList.add('d-none')
			}
		}

		let removeDirectory = e.target.closest('.remove_folder')
		if (removeDirectory) {
			let confirm = removeDirectory.getAttribute("data-confirm"), folder = removeDirectory.getAttribute("data-folder");
			bootbox.confirm({closeButton: false, message: confirm, callback: async function (res) {
				if (res === true) {
					let data = await fetchDataToJSON('delete_folder', {path: localStorage.getItem('path'), folder: folder});
					if (data.status == 200) {
						new Noty({text: data.message, type: data.type}).show();
						await fetchDataToHTML()
					} else {
						bootbox.confirm({closeButton: false, message: data.message, buttons: {confirm: {label: 'Yes', className: 'btn-sm btn-success'}, cancel: {label: 'No', className: 'btn-sm btn-danger'}}, callback: async function (res) {
							if (res === true) {
								let data = await fetchDataToJSON('confirm_remove_folder', {path: localStorage.getItem('path'), folder: folder});
								new Noty({text: data.message, type: data.type}).show();
								if (data.status == 200) {
									await fetchDataToHTML()
								}
							}
						}});
					}
				}
			}})
		}

		//  удаление файла / удаление файлов
		let removeFiles = e.target.closest('.remove-files')
		if (removeFiles) {
			let confirm =removeFiles.getAttribute("data-confirm"), fileIds = [removeFiles.getAttribute("data-id")];
			bootbox.confirm({ closeButton: false, message: confirm, callback: async function (result) {
				if (result === true) {
					document.querySelectorAll('#file_list > figure.file-manager-list.selected')
					.forEach(item => fileIds.push(item.getAttribute('data-id')))

					let data = await fetchDataToJSON('remove', { fileIds: fileIds, path: localStorage.getItem('path') });
					new Noty({text: data.message, type: data.type}).show();
					if (data.status == 200) {
						attachmentDetails.classList.add('d-none')
						await fetchDataToHTML();

					}
				}
			}})
		}
	})

	// Добавление к контенту, в галерею, как основную картинку, в описание, в документы
	document.querySelector('.add-content').addEventListener('click', async (e) => {
		const type = e.target.getAttribute('data-type');
		const fileIds = Array.from(document.querySelectorAll('#file_list > figure.file-manager-list.selected'))
				.map(item => item.getAttribute('data-id'));

		if (!fileIds.length) {
			console.error("Нет выбранных файлов");
			return;
		}

		const data = await fetchDataToJSON('load_file', { fileIds, path: localStorage.getItem('path') });

		if (!data || !Array.isArray(data)) {
			console.error("Не удалось загрузить данные файлов");
			return;
		}

		mediaActions.classList.add('d-none');
		mediaSearch.classList.remove('d-none');

		$("#media").modal('hide');

		const lastImageItem = getLastGalleryItem();
		const lastFileItem = getLastFileItem();

		data.forEach((item, index) => handleFileItem(item, type, lastImageItem, lastFileItem, index));
	});

	function handleFileItem(item, type, lastImageItem, lastFileItem, index) {
		if (!item || !item.fileType) {
			console.error("Некорректный элемент данных:", item);
			return;
		}

		const path = localStorage.getItem('path');
		const isAdmin = path === 'admin';

		if (item.fileType === 'image' || item.fileType === 'svg') {
			handleImageItem(item, type, lastImageItem, index, isAdmin);
		} else if (item.fileType === 'unknown' || item.fileType === 'archive') {
			// для документов, архивов
			contentFile(item, lastFileItem + index + 1);
		}
	}

	function handleImageItem(item, type, lastImageItem, index, isAdmin) {
		if (isAdmin || type === 'image') {
			contentMainImage(item); // основная картинка
		} else if (type === 'favicon') {
			faviconImageUrl(item.url); // favicon
		} else if (type === 'content') {
			insertIntoTinyMCE(item.url); // редактор tinyMCE
		} else {
			contentGalleryImage(item, lastImageItem + index + 1); // для галереи
		}
	}

	// вставка в редактор tinyMCE
	function insertIntoTinyMCE(url) {
		parent.tinyMCE.execCommand('mceInsertContent', false, `<img class="" src="${url}"/>`);
	}

	// добавление папки
	const buttonNewDirectory = document.querySelector('.new_folder');
	buttonNewDirectory.addEventListener('click', (e) => {
		// e.preventDefault();
		let confirm = buttonNewDirectory.getAttribute('data-confirm');
		bootbox.prompt({title: confirm, callback: async function (name) {
			if (name !== null) {
				let data = await fetchDataToJSON('new_folder', { path: localStorage.getItem('path'), name: name });
				if (data.status == 200) {
					await fetchDataToHTML()
				}
				new Noty({text: data.message, type: data.type}).show();
			}
		}})
	});

	// выделить все файлы
	document.querySelector('.select-all').addEventListener('click', async () => {
		let list = document.querySelectorAll('#file_list > figure.file-manager-list');
		let countSelected = list.length
		list.forEach((item, i) => {
			setTimeout(function() {
				if(!item.classList.contains('selected')) {
					item.classList.add("selected", "details")
					item.querySelector('.card').classList.add("border-primary", "border-opacity-50")
				}
			}, i * 100);
		})
		selectCount(countSelected);
		attachmentDetails.classList.add('d-none')
	})

	// отменить выделенные все файлы
	document.querySelector('.deselect-all').addEventListener('click', async () => {
		let list = document.querySelectorAll('#file_list > figure.file-manager-list.selected');
		list.forEach((item, i) => {
			setTimeout(function() {
				if (item.classList.contains('selected')) {
					item.classList.remove("selected", "details")
					item.querySelector('.card').classList.remove("border-primary", "border-opacity-50")
				}
			}, i * 100);
		})
		selectCount(0);
		attachmentDetails.classList.add('d-none')
	})

	// поиск по названию файлу
	document.querySelector("input#search_file").addEventListener("keyup", (e) => {
		console.log(e.target.value)
		localStorage.setItem('query', e.target.value);
		fetchDataToHTML();
	});

	/* загрузка всех данных по выбору */
	$(document).on("change", "#attachment_filters", function () {
		localStorage.setItem('filter', $(this).val());
		fetchDataToHTML();
	});

	$(document).on("change", "#attachment_filters_mime", function () {
		localStorage.setItem('mime', $(this).val());
		fetchDataToHTML();
	});

	// $(document).on('click', '.remove-gallery-image', function() {
	//     var elem = document.getElementById($(this).attr('data-val') + '-' + $(this).attr('data-id'));
	//     elem.parentNode.removeChild(elem);
	//     return false;
	// });

	// $(document).on('click','.remove-docs', function() {
	// 	let elem = document.getElementById('docs-item-' + $(this).attr('data-id'));
	// 	elem.parentNode.removeChild(elem);
	// 	return false;
	// });

	// кнопка копирование

	// Инициализируйте буфер обмена JS с помощью селектора для кнопки копирования
	const clipboard = new ClipboardJS('#button-copy', {
		text: function(trigger) {
			// Используйте элемент trigger для получения атрибута data-clipboard-text (данные-буфер обмена-текст)
			return trigger.getAttribute('data-clipboard-text');
		}
	});

	// Вспомогательная функция для обновления стиля и текста кнопок
	function updateButtonState(trigger, newState, newText) {
		// Определяем классы состояний
		const states = {
			light: 'btn-light',
			success: 'btn-success',
			danger: 'btn-danger'
		};
		// Удалить все классы состояний
		Object.values(states).forEach(state => trigger.classList.remove(state));
		// Добавьте новый класс state
		trigger.classList.add(states[newState]);
		// Обновите текст кнопки
		trigger.textContent = newText;
	}

	// Handle successful copy event
	clipboard.on('success', function(e) {
		console.info('Text:', e.text);
		const trigger = e.trigger;
		updateButtonState(trigger, 'success', 'Скопировано');
		setTimeout(() => {
			updateButtonState(trigger, 'light', 'Скопировать ссылку');
		}, 2000);
	});

	// Handle copy error event
	clipboard.on('error', function(e) {
		const trigger = e.trigger;
		updateButtonState(trigger, 'danger', 'Ошибка копирования');
		setTimeout(() => {
			updateButtonState(trigger, 'light', 'Скопировать ссылку');
		}, 2000);
	});


	// подгрузка при скроле
	function modalScrollMore() {

		const file_list = document.getElementById('file_list')
		const show_more = document.querySelector('#modal_show_more_trigger')
		const listFiles = $('#listFiles');

		if (modal_block_show) {
			return false;
		}

		let wt = $(window).scrollTop(),
				wh = $(window).height(),
				et = show_more.offsetTop,
				eh = show_more.outerHeight,
				dh = $(document).height();

		if (wt + wh >= et || wh + wt === dh || eh + et < wh) {
			let page = show_more.getAttribute('data-page');
			page++;

			modal_block_show = true;
			localStorage.setItem('page', page);
			show_more.setAttribute('data-page', page);
			$.ajax({
				type: "POST",
				url: 'index.php?mod=uploads&action=load_files&page=' + localStorage.getItem('page'),
				dataType: 'JSON',
				data : {
					query: localStorage.getItem('query'),
					path: localStorage.getItem('path'),
					type: localStorage.getItem('mime'),
					filters: localStorage.getItem('filter')
				},
				beforeSend: function() {
					listFiles.block({ centerY: false, centerX: false, message: '<i class="ph-spinner spinner"></i>',
						overlayCSS: { 'z-index' : 98, backgroundColor: '#fff', opacity: 0.8, cursor: 'wait' },
						css: { 'z-index' : 99,  border: 0, padding: 0, backgroundColor: 'none', position: 'fixed', margin: 'auto' }
					});
				},
				success: function(response) {
					file_list.insertAdjacentHTML('beforeend', response.items)
					modal_block_show = response.status !== 200;
					window.setTimeout(function () {
						listFiles.unblock();
					}, 400);

					// console.log("page => ", page)
					// console.log("totalPages => ", response.pagination.totalPages)

					if (page == response.pagination.totalPages) {
						modal_block_show = true;
					}
				}
			});
		}
	}

	document.querySelector('.attachments').addEventListener('scroll', () => {
		modalScrollMore();
	});

	// ajax
	async function fetchDataToJSON(actions, params) {
		let requestOptions = {
			method: 'POST',
			headers: {'Content-Type': 'application/json'},
			body: JSON.stringify(params)
		};
		try {
			const response = await fetch(`index.php?mod=uploads&action=${actions}`, requestOptions);
			return await response.json();
		} catch (error) {
			console.log('error', error);
			return null;
		}
	}

	// ajax
	async function fetchDataToHTML() {
		const file_list = document.getElementById('file_list')

		let query = localStorage.getItem('query'),
			path = localStorage.getItem('path'),
			type = localStorage.getItem('mime'),
			filters = localStorage.getItem('filter'),
			page = localStorage.getItem('page');

		await fetch("index.php?mod=uploads&action=load", {
			method: 'POST',
			headers: {'Content-Type': 'application/json'},
			body: JSON.stringify({
				query: query,
				path: path,
				type: type,
				filters: filters
			})
		}).then(response => response.json()).then(data => {
			$("#media").modal('show');
			selectCount(0);
			file_list.innerHTML = data.items;
			if (page == data.pagination.totalPages) {
				modal_block_show = true;
			}
		}).catch(error => console.error(error));
	}

	// Attachment Detail
	function previewTemplate(item) {
		switch (item.fileType) {
			case 'image':
			case 'svg': createImageCard(item); break;
			case 'video': createVideoCard(item); break;
			case 'audio': createAudioCard(item); break;
			default: createDefaultCard(item); break;
		}
	}

	function createImageCard(item) {
		// Create the outer card div
		const cardDiv = document.createElement('div');
		cardDiv.classList.add('card', 'border', 'shadow-sm');

		// Create the card-img div
		const cardImgDiv = document.createElement('div');
		cardImgDiv.classList.add('card-img', 'bg-light', 'rounded-top', 'text-center');

		// Create the img element
		const imgElement = document.createElement('img');
		imgElement.src = item.url;
		imgElement.classList.add('img-fluid', 'rounded-top');

		// Append img to the card-img div
		cardImgDiv.appendChild(imgElement);

		// Create the card body div
		const cardBodyDiv = document.createElement('div');
		cardBodyDiv.classList.add('card-file-upload-body', 'p-2');

		// Create the img-apply div
		const imgApplyDiv = document.createElement('div');
		imgApplyDiv.classList.add('img-apply');

		// Create the card title div
		const cardTitleDiv = document.createElement('div');
		cardTitleDiv.classList.add('card-title', 'fw-semibold', 'mb-1');
		cardTitleDiv.innerHTML = `<i class="ph-image text-muted me-2"></i>${item.fileName}`;

		// Create the file size div
		const fileSizeDiv = document.createElement('div');
		fileSizeDiv.classList.add('font-size-sm', 'text-muted', 'mb-1');
		fileSizeDiv.innerHTML = `<i class="ph-image me-2"></i>${item.size}`;

		// Create the copy link input field div
		const copyLinkDiv = document.createElement('div');
		copyLinkDiv.classList.add('font-size-sm', 'text-muted', 'mb-1');

		const copyLinkInput = document.createElement('input');
		copyLinkInput.type = 'text';
		copyLinkInput.id = 'copy_link';
		copyLinkInput.value = item.url;
		copyLinkInput.classList.add('form-control');
		copyLinkInput.readOnly = true;

		// Append the input to the copyLinkDiv
		copyLinkDiv.appendChild(copyLinkInput);

		// Create the button div
		const buttonDiv = document.createElement('div');
		buttonDiv.classList.add('font-size-sm', 'text-muted', 'mb-1');

		// Create the copy button
		const copyButton = document.createElement('button');
		copyButton.id = 'button-copy';
		copyButton.classList.add('btn', 'btn-light', 'btn-sm');
		copyButton.setAttribute('data-clipboard-action', 'copy');
		copyButton.setAttribute('data-clipboard-target', '#copy_link');
		copyButton.setAttribute('data-clipboard-text', item.url);
		copyButton.textContent = 'Скопировать ссылку';

		// Append the button to the buttonDiv
		buttonDiv.appendChild(copyButton);

		// Append all the inner elements to imgApplyDiv
		imgApplyDiv.appendChild(cardTitleDiv);
		imgApplyDiv.appendChild(fileSizeDiv);
		imgApplyDiv.appendChild(copyLinkDiv);
		imgApplyDiv.appendChild(buttonDiv);

		// Append imgApplyDiv to cardBodyDiv
		cardBodyDiv.appendChild(imgApplyDiv);

		// Append cardImgDiv and cardBodyDiv to the outer cardDiv
		cardDiv.appendChild(cardImgDiv);
		cardDiv.appendChild(cardBodyDiv);

		// Append the completed cardDiv to the container in your document
		appendCardAttachmentDetail(cardDiv)
	}

	function createVideoCard(item) {
		// Create the outer card div with the appropriate classes and file type
		const cardDiv = document.createElement('div');
		cardDiv.classList.add('card', 'border', 'shadow-sm', item.fileType);

		// Create the card-img div
		const cardImgDiv = document.createElement('div');
		cardImgDiv.classList.add('card-img', 'bg-light', 'rounded-top', 'text-center');

		// Create the video element
		const videoElement = document.createElement('video');
		videoElement.width = 400;
		videoElement.controls = true;
		videoElement.classList.add('img-fluid', 'rounded-top');
		videoElement.style.minHeight = '100px';

		// Create the source element
		const sourceElement = document.createElement('source');
		sourceElement.src = item.url;
		sourceElement.type = `${item.fileType}/${item.extension}`;

		// Append the source to the video element
		videoElement.appendChild(sourceElement);

		// Append the video element to the card-img div
		cardImgDiv.appendChild(videoElement);

		// Create the card body div
		const cardBodyDiv = document.createElement('div');
		cardBodyDiv.classList.add('card-file-upload-body', 'p-2');

		// Create the img-apply div
		const imgApplyDiv = document.createElement('div');
		imgApplyDiv.classList.add('img-apply');

		// Create the card title div
		const cardTitleDiv = document.createElement('div');
		cardTitleDiv.classList.add('card-title', 'fw-semibold', 'mb-1');
		cardTitleDiv.innerHTML = `<i class="ph-file-video text-muted"></i> ${item.fileName}`;

		// Create the file size div
		const fileSizeDiv = document.createElement('div');
		fileSizeDiv.classList.add('font-size-sm', 'text-muted', 'mb-1');
		fileSizeDiv.innerHTML = `<i class="ph-file-video"></i> ${item.size}`;

		// Create the copy link input field div
		const copyLinkDiv = document.createElement('div');
		copyLinkDiv.classList.add('font-size-sm', 'text-muted', 'mb-1');

		const copyLinkInput = document.createElement('input');
		copyLinkInput.type = 'text';
		copyLinkInput.id = 'copy_link';
		copyLinkInput.value = item.url;
		copyLinkInput.classList.add('form-control');
		copyLinkInput.readOnly = true;

		// Append the input to the copyLinkDiv
		copyLinkDiv.appendChild(copyLinkInput);

		// Create the button div
		const buttonDiv = document.createElement('div');
		buttonDiv.classList.add('font-size-sm', 'text-muted', 'mb-1');

		// Create the copy button
		const copyButton = document.createElement('button');
		copyButton.id = 'button-copy';
		copyButton.classList.add('btn', 'btn-light', 'btn-sm');
		copyButton.setAttribute('data-clipboard-action', 'copy');
		copyButton.setAttribute('data-clipboard-target', '#copy_link');
		copyButton.setAttribute('data-clipboard-text', item.url);
		copyButton.textContent = 'Скопировать ссылку';

		// Append the button to the buttonDiv
		buttonDiv.appendChild(copyButton);

		// Append all the inner elements to imgApplyDiv
		imgApplyDiv.appendChild(cardTitleDiv);
		imgApplyDiv.appendChild(fileSizeDiv);
		imgApplyDiv.appendChild(copyLinkDiv);
		imgApplyDiv.appendChild(buttonDiv);

		// Append imgApplyDiv to cardBodyDiv
		cardBodyDiv.appendChild(imgApplyDiv);

		// Append cardImgDiv and cardBodyDiv to the outer cardDiv
		cardDiv.appendChild(cardImgDiv);
		cardDiv.appendChild(cardBodyDiv);

		// Append the completed cardDiv to the container in your document
		appendCardAttachmentDetail(cardDiv)
	}

	function createAudioCard(item) {
		// Create the outer card div with the appropriate classes and file type
		const cardDiv = document.createElement('div');
		cardDiv.classList.add('card', 'border', 'shadow-sm', item.fileType);

		// Create the card-img div
		const cardImgDiv = document.createElement('div');
		cardImgDiv.classList.add('card-img', 'bg-light', 'rounded-top', 'text-center', 'media-wrapper');

		// Create the audio element
		const audioElement = document.createElement('audio');
		audioElement.id = 'player2';
		audioElement.preload = 'none';
		audioElement.src = item.url;
		audioElement.controls = true;
		audioElement.style.maxWidth = '100%';
		audioElement.style.backgroundColor = '#f1f3f4';

		// Create the source element
		const sourceElement = document.createElement('source');
		sourceElement.src = item.url;
		sourceElement.type = `${item.fileType}/${item.extension}`;

		// Append the source to the audio element
		audioElement.appendChild(sourceElement);

		// Append the audio element to the card-img div
		cardImgDiv.appendChild(audioElement);

		// Create the card body div
		const cardBodyDiv = document.createElement('div');
		cardBodyDiv.classList.add('card-file-upload-body', 'p-2');

		// Create the img-apply div
		const imgApplyDiv = document.createElement('div');
		imgApplyDiv.classList.add('img-apply');

		// Create the card title div
		const cardTitleDiv = document.createElement('div');
		cardTitleDiv.classList.add('card-title', 'fw-semibold', 'mb-1');
		cardTitleDiv.innerHTML = `<i class="ph-file-audio text-muted"></i> ${item.fileName}`;

		// Create the file size div
		const fileSizeDiv = document.createElement('div');
		fileSizeDiv.classList.add('font-size-sm', 'text-muted', 'mb-1');
		fileSizeDiv.innerHTML = `<i class="ph-file-audio"></i> ${item.size}`;

		// Create the copy link input field div
		const copyLinkDiv = document.createElement('div');
		copyLinkDiv.classList.add('font-size-sm', 'text-muted', 'mb-1');

		const copyLinkInput = document.createElement('input');
		copyLinkInput.type = 'text';
		copyLinkInput.id = 'copy_link';
		copyLinkInput.value = item.url;
		copyLinkInput.classList.add('form-control');
		copyLinkInput.readOnly = true;

		// Append the input to the copyLinkDiv
		copyLinkDiv.appendChild(copyLinkInput);

		// Create the button div
		const buttonDiv = document.createElement('div');
		buttonDiv.classList.add('font-size-sm', 'text-muted', 'mb-1');

		// Create the copy button
		const copyButton = document.createElement('button');
		copyButton.id = 'button-copy';
		copyButton.classList.add('btn', 'btn-light', 'btn-sm');
		copyButton.setAttribute('data-clipboard-action', 'copy');
		copyButton.setAttribute('data-clipboard-target', '#copy_link');
		copyButton.setAttribute('data-clipboard-text', item.url);
		copyButton.textContent = 'Скопировать ссылку';

		// Append the button to the buttonDiv
		buttonDiv.appendChild(copyButton);

		// Append all the inner elements to imgApplyDiv
		imgApplyDiv.appendChild(cardTitleDiv);
		imgApplyDiv.appendChild(fileSizeDiv);
		imgApplyDiv.appendChild(copyLinkDiv);
		imgApplyDiv.appendChild(buttonDiv);

		// Append imgApplyDiv to cardBodyDiv
		cardBodyDiv.appendChild(imgApplyDiv);

		// Append cardImgDiv and cardBodyDiv to the outer cardDiv
		cardDiv.appendChild(cardImgDiv);
		cardDiv.appendChild(cardBodyDiv);

		// Append the completed cardDiv to the container in your document
		appendCardAttachmentDetail(cardDiv)
	}

	function createDefaultCard(item) {
		// Create the outer card div with the default class
		const cardDiv = document.createElement('div');
		cardDiv.classList.add('card', 'default');

		// Create the card-img div
		const cardImgDiv = document.createElement('div');
		cardImgDiv.classList.add('card-img', 'bg-light', 'rounded-top', 'text-center');

		// Create the img element
		const imgElement = document.createElement('img');
		imgElement.src = item.icon;
		imgElement.classList.add('img-fluid');
		imgElement.style.minHeight = '100px';

		// Append the img to the card-img div
		cardImgDiv.appendChild(imgElement);

		// Create the card body div
		const cardBodyDiv = document.createElement('div');
		cardBodyDiv.classList.add('card-file-upload-body', 'p-2');

		// Create the img-apply div
		const imgApplyDiv = document.createElement('div');
		imgApplyDiv.classList.add('img-apply');

		// Create the card title div
		const cardTitleDiv = document.createElement('div');
		cardTitleDiv.classList.add('card-title', 'fw-semibold', 'mb-1');
		cardTitleDiv.textContent = item.fileName;

		// Create the file size div
		const fileSizeDiv = document.createElement('div');
		fileSizeDiv.classList.add('font-size-sm', 'text-muted', 'mb-1');
		fileSizeDiv.innerHTML = `<i class="ph-image"></i> ${item.size}`;

		// Create the copy link input field div
		const copyLinkDiv = document.createElement('div');
		copyLinkDiv.classList.add('font-size-sm', 'text-muted', 'mb-1');

		const copyLinkInput = document.createElement('input');
		copyLinkInput.type = 'text';
		copyLinkInput.id = 'copy_link';
		copyLinkInput.value = item.url;
		copyLinkInput.classList.add('form-control');
		copyLinkInput.readOnly = true;

		// Append the input to the copyLinkDiv
		copyLinkDiv.appendChild(copyLinkInput);

		// Create the button div
		const buttonDiv = document.createElement('div');
		buttonDiv.classList.add('font-size-sm', 'text-muted', 'mb-1');

		// Create the copy button
		const copyButton = document.createElement('button');
		copyButton.id = 'button-copy';
		copyButton.classList.add('btn', 'btn-light', 'btn-sm');
		copyButton.setAttribute('data-clipboard-action', 'copy');
		copyButton.setAttribute('data-clipboard-target', '#copy_link');
		copyButton.setAttribute('data-clipboard-text', item.url);
		copyButton.textContent = 'Скопировать ссылку';

		// Append the button to the buttonDiv
		buttonDiv.appendChild(copyButton);

		// Append all the inner elements to imgApplyDiv
		imgApplyDiv.appendChild(cardTitleDiv);
		imgApplyDiv.appendChild(fileSizeDiv);
		imgApplyDiv.appendChild(copyLinkDiv);
		imgApplyDiv.appendChild(buttonDiv);

		// Append imgApplyDiv to cardBodyDiv
		cardBodyDiv.appendChild(imgApplyDiv);

		// Append cardImgDiv and cardBodyDiv to the outer cardDiv
		cardDiv.appendChild(cardImgDiv);
		cardDiv.appendChild(cardBodyDiv);

		// Append the completed cardDiv to the container in your document
		appendCardAttachmentDetail(cardDiv)
	}

	function appendCardAttachmentDetail(card) {

		const attachmentDetail = document.querySelector('.attachment-details');
		// Проверьте, существуют ли сведения о вложении и есть ли дочерние узлы
		if (attachmentDetail) {
			if (attachmentDetail.hasChildNodes()) {
				// Очистите все дочерние узлы
				attachmentDetail.innerHTML = '';
			}
			// Добавляем заполненный файл card в контейнер attachmentDetail
			if (card) {
				attachmentDetail.appendChild(card);
			}
		} else {
			console.error('Element with class "attachment-details" not found.');
		}
	}

	/**
	 * Lобавление - остновная картинка.
	 *
	 * @param {Object} item - Данные изображения.
	 */
	function contentMainImage(item) {

		// заменить текст кнопки при добавлении картинки
		document.getElementById('content-image-preview-add').innerHTML = '<i class="ph-image me-2"></i>{general:changeFile}';

		const contentImagePreview = document.getElementById('content-image-preview');
		// Очистите предварительный просмотр содержимого изображения, если в нем есть какие-либо дочерние узлы
		if (contentImagePreview.hasChildNodes()) {
			contentImagePreview.innerHTML = ''; // Очистите все дочерние узлы
		}
		// Создайте внешний div
		const cardDiv = document.createElement('div');
		cardDiv.classList.add('card-img-actions', 'card-image-preview');
		cardDiv.id = `image_general-${item.fileId}`;

		// Создайте скрытый элемент ввода
		const hiddenInput = document.createElement('input');
		hiddenInput.type = 'hidden';
		// hiddenInput.name = 'image[fileId]';
		hiddenInput.name = `image[${item.fileId}][fileId]`;
		hiddenInput.value = item.fileId;

		// Создайте элемент img
		const imgElement = document.createElement('img');
		imgElement.classList.add('img-fluid');
		imgElement.src = item.url;
		imgElement.alt = '';

		// Добавьте элементы input и img во внешний div
		cardDiv.appendChild(hiddenInput);
		cardDiv.appendChild(imgElement);

		// Добавьте весь card целиком в контейнер content-image-preview
		contentImagePreview.appendChild(cardDiv);

		// проверить на существование кнопки, если нет то добавить кнопку удаления
		const element = document.getElementById('content-image-preview-remove');
		if (!element) {
			// Get the container where the button will be added
			const footer = document.getElementById('preview-image-footer');

			// Create the button element
			const button = document.createElement('button');
			button.id = 'content-image-preview-remove';
			button.type = 'button';
			button.classList.add('btn', 'btn-sm', 'btn-danger');
			button.onclick = removePreviewImage;

			// Create the icon element
			const icon = document.createElement('i');
			icon.classList.add('ph-trash', 'me-2');

			// Append the icon to the button
			button.appendChild(icon);

			// Add the text to the button
			const buttonText = document.createTextNode('{/literal}{general:delete}{literal}');
			button.appendChild(buttonText);

			// Append the button to the footer container
			footer.appendChild(button);
		}
	}

	// Добавлние блока в галерею к контенту
	function contentGalleryImage(item, index)
	{
		console.log("Последний элемент:", index);

		if (!item || !item.fileId || !item.url) {
			console.error("Неверный объект item:", item);
			return;
		}

		// Обновление текста кнопки
		const uploadButton = document.querySelector(".btn-upload");
		if (uploadButton) {
			uploadButton.innerHTML = '<i class="ph-image me-2"></i> Еще добавить';
		}

		// Получение контейнера imageList
		const imageList = document.getElementById('imageList');
		if (!imageList) {
			console.error("Контейнер #imageList не найден");
			return;
		}

		// Создание элементов
		const figure = createElement('figure', {
			classes: ['gallery-item', 'mb-0'],
			attributes: { id: `item-${index}`, 'data-id': item.fileId },
		});

		const divImage = createElement('div', { classes: ['image'] });

		const hiddenInput = createElement('input', {
			attributes: { type: 'hidden', name: `gallery[${index}][fileId]`, value: item.fileId },
		});

		const imgElement = createElement('img', { attributes: { src: item.url } });

		const ulControls = createElement('ul', { classes: ['gallery-item-controls'] });

		const liControl = createElement('li');
		const spanControl = createElement('span', { events: { click: () => removeRow('imageList', index) } });
		const iconElement = createElement('i', { classes: ['ph-trash'] });

		// Сборка карточки
		spanControl.appendChild(iconElement);
		liControl.appendChild(spanControl);
		ulControls.appendChild(liControl);

		divImage.append(hiddenInput, imgElement, ulControls);
		figure.appendChild(divImage);
		imageList.appendChild(figure);
	}

	// Добавлние блока документа к контенту
	function contentFile(item, index) {
		if (!item || !item.fileId || !item.extension || !item.fileName) {
			console.error("Неверный объект item:", item);
			return;
		}

		// Контейнер для документов
		const fileContainer = document.getElementById('fileList');
		if (!fileContainer) {
			console.error("Контейнер #fileList не найден");
			return;
		}

		// Обновление кнопки "Еще добавить"
		const uploadButton = document.querySelector(".btn-upload");
		if (uploadButton) {
			uploadButton.innerHTML = '<i class="ph-image me-2"></i> Еще добавить';
		}


		// Создание элементов
		const figure = createElement('figure', {
			classes: ['docs', 'my-2'],
			attributes: { id: `item-${index}` },
		});

		const inputGroup = createElement('div', { classes: ['input-group'] });

		const spanIcon = createElement('span', {
			classes: ['input-group-text']
		});
		const imgIcon = createElement('img', {
			attributes: { src: `/admin/assets/ico/${item.extension}.svg`, width: 30 },
		});

		const inputFileName = createElement('input', {
			classes: ['form-control'],
			attributes: { type: 'text', value: item.fileName }
		});

		const hiddenInput = createElement('input', {
			attributes: { type: 'hidden', name: `docs[${index}][fileId]`, value: item.fileId}
		});

		const titleInput = createElement('input', {
			classes: ['form-control'],
			attributes: { type: 'text', name: `docs[${index}][title]`, placeholder: "Название документа", value: ""}
		});

		const removeButton = createElement('button', {
			classes: ['btn', 'btn-danger'],
			attributes: { type: 'button', 'data-id': item.fileId },
			events: { click: () => removeRow('fileList', index) }, // Здесь мы передаем обработчик
		});
		const trashIcon = createElement('i', {
			classes: ['ph-trash']
		});


		// Построение структуры
		spanIcon.appendChild(imgIcon);
		removeButton.appendChild(trashIcon);

		inputGroup.append(spanIcon, inputFileName, hiddenInput, titleInput, removeButton);
		figure.appendChild(inputGroup);

		fileContainer.appendChild(figure);
	}



	/**
	 * Вспомогательная функция для создания DOM-элементов.
	 *
	 * @param {string} tagName - Имя тега элемента (например, 'div', 'img').
	 * @param {Object} [options={}] - Опции элемента.
	 * @param {string[]} [options.classes] - Массив классов для элемента.
	 * @param {Object} [options.attributes] - Атрибуты элемента (например, { src: 'image.jpg', id: 'uniqueId' }).
	 * @param {Node[]} [options.children] - Дочерние узлы, которые нужно добавить.
	 * @param {Object} [options.events] - Слушатели событий ({ click: () => {}, mouseover: () => {} }).
	 * @param {string|Node} [options.text] - Текстовое содержимое или узел (Node).
	 * @returns {HTMLElement} - Созданный DOM-элемент.
	 */
	function createElement(tagName, options = {}) {
		const element = document.createElement(tagName);

		// Добавляем классы (если переданы)
		if (options.classes) {
			element.classList.add(...options.classes);
		}

		// Добавляем атрибуты (если переданы)
		if (options.attributes) {
			Object.entries(options.attributes).forEach(([key, value]) => {
				element.setAttribute(key, value);
			});
		}

		// Устанавливаем текстовое содержимое (если передано)
		if (options.text) {
			if (typeof options.text === 'string') {
				element.textContent = options.text; // Если текст — простая строка
			} else {
				element.appendChild(options.text); // Если текст — узел (Node)
			}
		}

		// Добавляем дочерние элементы (если переданы)
		if (options.children) {
			options.children.forEach(child => {
				element.appendChild(child);
			});
		}

		// Добавляем обработчики событий (если переданы)
		if (options.events) {
			Object.entries(options.events).forEach(([event, handler]) => {
				element.addEventListener(event, handler);
			});
		}

		return element;
	}

	function getLastGalleryItem() {
		// Найти все элементы внутри #imageList, ID которых начинается с "item-"
		const items = document.querySelectorAll('#imageList [id^="item-"]');

		// Если такие элементы не найдены, вернуть null
		if (!items.length) {
			return null;
		}

		// Вернуть последний элемент
		let lastItem =  items[items.length - 1];

		// Если элемента нет, вернуть 0
		if (!lastItem) {
			return 0;
		}

		// Извлечь число из ID (например, "item-123" -> 123)
		const match = lastItem.id.match(/^item-(\d+)$/);
		return match ? parseInt(match[1], 10) : 0;
	}

	function getLastFileItem() {
		// Найти все элементы внутри #fileList, ID которых начинается с "item-"
		const items = document.querySelectorAll('#fileList [id^="item-"]');

		// Если такие элементы не найдены, вернуть null
		if (!items.length) {
			return null;
		}

		// Вернуть последний элемент
		let lastItem =  items[items.length - 1];

		// Если элемента нет, вернуть 0
		if (!lastItem) {
			return 0;
		}

		// Извлечь число из ID (например, "item-123" -> 123)
		const match = lastItem.id.match(/^item-(\d+)$/);
		return match ? parseInt(match[1], 10) : 0;
	}

	function faviconImageUrl(url) {
		let attachmentUrl = 'https://' + window.location.hostname + '' + url
		document.getElementById('master_picture_url').value = attachmentUrl
		prepareInlinePicture(attachmentUrl);
	}


</script>
{/literal}
