<IfModule mod_autoindex>
  Options -Indexes
</IfModule>

{if $config.mod_deflate}
<IfModule mod_deflate.c>
	# Compress HTML, CSS, JavaScript, Text, XML and fonts
	AddOutputFilterByType DEFLATE application/javascript
	AddOutputFilterByType DEFLATE application/rss+xml
	AddOutputFilterByType DEFLATE application/vnd.ms-fontobject
	AddOutputFilterByType DEFLATE application/x-font
	AddOutputFilterByType DEFLATE application/x-font-opentype
	AddOutputFilterByType DEFLATE application/x-font-otf
	AddOutputFilterByType DEFLATE application/x-font-truetype
	AddOutputFilterByType DEFLATE application/x-font-ttf
	AddOutputFilterByType DEFLATE application/x-javascript
	AddOutputFilterByType DEFLATE application/xhtml+xml
	AddOutputFilterByType DEFLATE application/xml
	AddOutputFilterByType DEFLATE font/opentype
	AddOutputFilterByType DEFLATE font/otf
	AddOutputFilterByType DEFLATE font/ttf
	AddOutputFilterByType DEFLATE image/svg+xml
	AddOutputFilterByType DEFLATE image/x-icon
	AddOutputFilterByType DEFLATE text/css
	AddOutputFilterByType DEFLATE text/html
	AddOutputFilterByType DEFLATE text/javascript
	AddOutputFilterByType DEFLATE text/plain
	AddOutputFilterByType DEFLATE text/xml

	# Remove browser bugs (only needed for really old browsers)
	BrowserMatch ^Mozilla/4 gzip-only-text/html
	BrowserMatch ^Mozilla/4\.0[678] no-gzip
	BrowserMatch \bMSIE !no-gzip !gzip-only-text/html
	Header append Vary User-Agent
</IfModule>
{/if}

{if $config.mod_headers}
<ifModule mod_headers.c>
	# Все html и htm файлы будут храниться в кэше браузера один день
	<FilesMatch "\.(html|htm)$">
	Header set Cache-Control "max-age=43200"
	</FilesMatch>
	# Все css, javascript и текстовые файлы будут храниться в кэше браузера одну неделю
	<FilesMatch "\.(js|css|txt)$">
	Header set Cache-Control "max-age=604800"
	</FilesMatch>
	# Все флэш файлы и изображения будут храниться в кэше браузера один месяц
	<FilesMatch "\.(flv|swf|ico|gif|jpg|jpeg|png)$">
	Header set Cache-Control "max-age=43200"
	</FilesMatch>
	# Отключаем кеширование php и других служебных файлов
	<FilesMatch "\.(pl|php|cgi|spl|scgi|fcgi)$">
	Header unset Cache-Control
	</FilesMatch>
</IfModule>
{/if}

{if $config.mod_expires}
	# Кэширование / поддерживается не на всех хостингах
	<ifmodule mod_expires.c>
		<filesmatch "\.(jpg|jpeg|png|gif|js|css|swf|ico|woff|mp3)$">
		ExpiresActive on
		ExpiresDefault "access plus 7 days"
		</filesmatch>
	</ifmodule>
{/if}

{if isset($homePageId)}
DirectoryIndex /public/section.php?sectionId={$homePageId}&rewrite={$rewrite}&SITE_LANG={$SITE_LANG}
{/if}
RewriteEngine On

{if $config.www_redirect eq 1}
# match any URL with www and rewrite it to https without the www
RewriteCond %{ldelim}HTTP_HOST{rdelim} ^(www\.)(.*) [NC]
RewriteRule (.*) https://%2%{ldelim}REQUEST_URI{rdelim} [L,R=301]
{/if}

{if IS_HTTPS || $config.http_redirect eq 1}
RewriteCond %{ldelim}HTTPS{rdelim} =off
{if $config.www_redirect eq 1}
# match urls that are non https (without the www)
RewriteCond %{ldelim}HTTP_HOST{rdelim} !^(www\.)(.*) [NC]
{/if}
RewriteRule (.*) https://%{ldelim}HTTP_HOST{rdelim}%{ldelim}REQUEST_URI{rdelim} [QSA,L]
{elseif $config.http_redirect eq 2}
RewriteCond %{ldelim}HTTPS{rdelim} =on [OR]
RewriteRule ^(.*)$ http://%{ldelim}HTTP_HOST{rdelim}%{ldelim}REQUEST_URI{rdelim} [QSA,L]
{/if}

ErrorDocument 404 /public/error-404.php?rewrite={$rewrite}&SITE_LANG={$SITE_LANG}

RewriteRule ^sitemap.xml$ /public/sitemap.php?rewrite={$rewrite}&SITE_LANG={$SITE_LANG} [L]

{foreach item=section from=$SECTIONS}
{if $section.type eq "plain"}
{if $section.fileName eq "index"}
RewriteRule ^{preg_quote($section.dir)}/$ {$SITE_URL}/ [L,R=301]
{else}
RewriteRule ^{preg_quote($section.dir)}/$ /public/section.php?sectionId={$section.sectionId}&rewrite={$rewrite}&SITE_LANG={$SITE_LANG} [L]
{/if}

{elseif $section.type eq "tree"}

RewriteRule ^{preg_quote($section.dir)}$ {$section.path}/ [L,R=301]
RewriteRule ^{preg_quote($section.dir)}/$ /public/section.php?{literal}%{QUERY_STRING}{/literal}&sectionId={$section.sectionId}&rewrite={$rewrite}&SITE_LANG={$SITE_LANG} [L]
RewriteRule ^{preg_quote($section.dir)}/page([0-9]+)\.{$config.file_extension}$ /public/section.php?{literal}%{QUERY_STRING}{/literal}&sectionId={$section.sectionId}&page=$1&rewrite={$rewrite}&SITE_LANG={$SITE_LANG} [L]
RewriteRule ^{preg_quote($section.dir)}/([^/]+)\.{$config.file_extension}$ /public/article.php?{literal}%{QUERY_STRING}{/literal}&fileName=$1&sectionId={$section.sectionId}&rewrite={$rewrite}&SITE_LANG={$SITE_LANG} [L]
{/if}{/foreach}

RewriteRule ^ajax-(.*) /public/ajax-$1.php?rewrite={$rewrite}&SITE_LANG={$SITE_LANG} [QSA]
RewriteRule ^api-(.*) /public/api-$1.php?rewrite={$rewrite}&SITE_LANG={$SITE_LANG} [QSA]

RewriteRule ^(.+\.php)$ {$GLOBAL_URI}/$1?SITE_LANG={$SITE_LANG} [QSA]
