{strip}
    {assign var=wrapper value="" scope=global}
{if isset($list)}
    {if isset($list.dirs)}
        {foreach item=dir from=$list.dirs}
			<div class="file-manager-list" data-name="{$dir.name|escape}">
				<div class="card border shadow-sm">
					<a href="javascript:void('')" data-path="{$path}{$dir.name|escape}" data-action="read_more" class="card-body bg-light rounded-top read-more p-0">
						<div class="card-img-actions mx-1"><i class="ph-folder-notch card-img img-fluid text-primary" style="font-size: 83px;"></i></div>
						<div class="card-file-upload-body text-left">
							<div class="img-apply">
								<div class="fw-semibold text-primary">{$dir.name|escape}</div>
								<div class="fs-sm text-muted mb-2">Size: {$dir.size}</div>
							</div>
						</div>
					</a>
					<div class="card-footer d-flex justify-content-center align-items-center p-1">
						<ul class="list-inline mb-0">
							<li class="list-inline-item">
								<button type="button" data-path="{$path|escape}" data-folder="{$dir.name|escape}" data-action="delete_folder" data-confirm="{javascript:sureToDelete} «{$dir.name|escape}»?" class="list-icons-item remove_folder btn btn-link">
									<i class="ph-trash"></i>
								</button>
							</li>
						</ul>
					</div>
				</div>
			</div>
        {/foreach}
    {/if}

    {if isset($list.files)}
        {foreach item=file from=$list.files}
			<figure class="file-manager-list" data-id="{$file.fileId}">
				<div class="card border shadow-sm">
					<a href="javascript:void('')" class="card-body card_file_item bg-light rounded-top p-1" data-action="read_file" data-id="{$file.fileId}" data-path="{$path|escape}">
						<div class="card-img-actions">
							<div class="card-img card-file-upload {$file.fileType}" style="{if $file.fileType|in_array:['image', 'svg']}background-image: url('{$file.original}'){else}background-size: contain; background-image: url('{$file.icon}'){/if}"></div>
						</div>
						<div class="card-file-upload-body text-left">
							<div class="img-apply">
								<div class="fw-semibold text-nowrap text-primary" style="overflow: hidden;text-overflow: ellipsis;white-space: nowrap;"> {$file.fileName}</div>
								<div class="fs-sm text-muted mb-2">Size: {$file.size}</div>
							</div>
						</div>
					</a>
					<div class="card-footer d-flex justify-content-center align-items-center p-1">
						<ul class="list-inline mb-0">
							<li class="list-inline-item">
								<a href="{$file.original}" download class="list-icons-item btn btn-link">
									<i class="ph-download-simple top-0"></i>
								</a>
							</li>
							<li class="list-inline-item">
								<button type="button" data-id="{$file.fileId}" data-path="{$path|escape}" data-action="remove" data-confirm="{javascript:sureToDelete} «{$file.fileName|escape}»?" class="list-icons-item remove-files btn btn-link">
									<i class="ph-trash"></i>
								</button>
							</li>
						</ul>
					</div>
				</div>
			</figure>
        {/foreach}
    {/if}
{/if}
{/strip}
