{assign var=wrapper value="" scope=global}
<!DOCTYPE html>
<html lang="{$config.website_language}" data-url="{$adminUrl}">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<title>{login:title} - {productName}</title>
	<!-- Global stylesheets -->
	<link href="/admin/assets/fonts/inter/inter.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/icons/phosphor/styles.min.css" rel="stylesheet" type="text/css">
	<link href="/admin/assets/css/all.min.css" id="stylesheet" rel="stylesheet" type="text/css">
	<!-- /global stylesheets -->

	{script src='/admin/assets/js/bootstrap/bootstrap.bundle.min.js'}
	{*script src='/admin/assets/js/vendor/forms/inputs/imask.min.js'*}
</head>

<body>
{*	<div class="page-content">*}
	<div class="page-content login-cover">
		<div class="content-wrapper">
			<div class="content d-flex justify-content-center align-items-center">

				{* form login *}
				<form class="login-form form-validation" method="post" action="{$adminUrl}/auth" id="login" accept-charset="{$config.charset}" novalidate>
					{* input action *}
					<input type="hidden" name="action" value="login" class="form-control d-none">
					{* /input action *}

					{* input token *}
					{security_csrf_token input=true}
					{* /input token *}

					<div class="card mb-0">

						<div class="card-body">
							<div class="text-center mb-3">
								<i class="icon-reading icon-2x text-slate-300 border-slate-300 border-3 rounded-round p-3 mb-3 mt-1"></i>
								<h5 class="mb-0">{login:title}</h5>
								<span class="d-block text-muted">{login:alias}</span>
							</div>

							{if isset($isBanned)}
								<div class="alert bg-danger text-white alert-dismissible fade show mb-2">{$isBanned nofilter}</div>
							{else}

								{if isset($errors)}
									{foreach from=$errors item=error key=key}
										{if !empty($error)}<div class="alert bg-danger text-white alert-dismissible fade show mb-2">{$error}</div>{/if}
									{/foreach}
								{/if}

								{if isset($limit_cnt)}
									<div class="alert bg-danger text-white alert-dismissible fade show mb-2">{login:left} {$limit_cnt} {$limit_cnt|plural:'попытка':'попыток':'попытки'}</div>
								{/if}

								<div class="notification"></div>

								{* input login *}
								<div class="form-group mb-3">
									<label class="form-label" for="login_name">{login:username}</label>
									<div class="form-control-feedback form-control-feedback-start">
										<input type="text" class="form-control" id="login_name" name="login" value="{$login.login|default:''}" placeholder="admin" minlength="5" required>
										<div class="form-control-feedback-icon"><i class="ph-user-circle text-muted"></i></div>
									</div>
								</div>
								{* /input login *}

								{* input password *}
								<div class="form-group mb-3">
									<label class="form-label" for="password">{login:password}</label>
									<div class="form-control-feedback form-control-feedback-start">
										<input type="password" class="form-control" id="password" name="password" value="{$login.password|default:''}" autocomplete="off" placeholder="•••••••••••" minlength="6" required>
										<div class="form-control-feedback-icon"><i class="ph-lock text-muted"></i></div>
									</div>
								</div>
								{* /input password *}

								{* input remember *}
								<div class="form-group d-flex align-items-center mb-3">
									<label class="form-check">
										<input id="remember_check" type="checkbox" name="remember" value="1" class="form-check-input" checked>
										<span class="form-check-label">{login:remember}</span>
									</label>
								</div>
								{* /input remember *}

								{* button submit *}
								<div class="form-group mb-3">
									<button type="submit" class="btn btn-primary w-100" typeof="submit">{login:signIn}</button>
								</div>
								{* /button submit *}

							{/if}

						</div>
					</div>

				</form>
				{* /form login *}

			</div>
		</div>
	</div>

	{literal}
	<script>

		const FormStyles = function() {

			// const componentMaskInput = function() {
			// 	const maskPhoneElement = document.querySelector('#phone');
			// 	if (maskPhoneElement) {
			// 		IMask(maskPhoneElement, { mask: '+998 (00) 000-00-00' });
			// 	}
			// }

			const validationForm = () => {

				const form = document.querySelector('.form-validation');
				const formItems = document.querySelectorAll('.form-group');
				const token = document.querySelector('input[name="token"]');
				const notificationAlert = document.querySelector('.notification');

				form.addEventListener('submit', handleFormSubmit);

				// Handle form submission and AJAX request
				async function handleFormSubmit(event) {
					event.preventDefault();

					form.classList.add('was-validated'); // Show validation feedback
					if (!form.checkValidity()) return; // Stop if form is invalid

					const formData = new FormData(form);
					try {
						const response = await sendAjaxRequest(formData);
						handleResponse(response);
					} catch (error) {
						displayNotification('danger', `Error: ${error.message}`);
					}
				}

				// Send AJAX request
				async function sendAjaxRequest(formData) {
					const httpReferer = document.referrer;
					const currentUrl = document.documentElement.getAttribute("data-url");
					try {
						const response = await fetch(`${currentUrl}/ajaxauth`, { method: 'POST', headers: {
							'X-Requested-With': 'XMLHttpRequest', 'X-CSRF-Token': token.value, 'Referer': httpReferer
						}, body: formData});

						if (!response.ok) {
							throw new Error(`HTTP error! Status: ${response.status}`);
						}

						return await response.json();
					} catch (error) {
						throw new Error(`Failed to fetch: ${error.message}`);
					}
				}

				// Handle the response from the server
				function handleResponse(response) {
					if (response.status === 200) {
						displayNotification('success', response.message);
						setTimeout(() => window.location.href = response.redirect, 1000);
					} else {
						displayNotification('danger', response.message, response.blocked);
						if (response.limit) {
							displayLimitAlert('warning', response.limit, response.blocked);
						}
					}

					if (response.blocked) {
						clearFormItems();
					}
				}

				// Display notification with smooth animation
				function displayNotification(type, message, blocked) {
					clearElement(notificationAlert);
					displayAlert(type, message, blocked);
				}

				// Display limit alert with smooth animation
				function displayLimitAlert(type, message, blocked) {
					displayAlert(type, message, blocked);
				}

				// Create and display an alert dynamically
				function displayAlert(type, message, blocked) {
					const alertDiv = createAlertDiv(type, message);
					notificationAlert.appendChild(alertDiv);

					requestAnimationFrame(() => alertDiv.classList.add('show')); // Trigger fade-in
					if (!blocked) {
						setTimeout(() => {
							alertDiv.classList.remove('show'); // Trigger fade-out
							setTimeout(() => alertDiv.remove(), 500); // Remove after fade-out transition
						}, 3000);
					}
				}

				// Create alert div element
				function createAlertDiv(type, message) {
					const alert = document.createElement('div');
					alert.className = `alert bg-${type} text-white alert-dismissible fade mb-2`; // #262626
					alert.innerHTML = message;
					return alert;
				}

				// Clear all form items
				function clearFormItems() {
					formItems.forEach(formItem => formItem.remove());
				}

				// Clear any previous alerts or elements
				function clearElement(element) {
					while (element.firstChild) {
						element.removeChild(element.firstChild);
					}
				}
			};


			return {
				init: function() {
					validationForm();
				}
			}
		}();

		document.addEventListener('DOMContentLoaded', function() {
			FormStyles.init();
		});

	</script>
	{/literal}

</body>
</html>
