<form method="post" enctype="multipart/form-data" class="content-inner">
	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/banners?page={if !empty($page)}{$page}{/if}{$buildQueryString}"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/banners" class="breadcrumb-item">{$title}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">
        <div class="row"> 
            <div class="col-md-8">
    		    <div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{general:card:general}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
	                    <div class="card-body">
	                        <div class="row">
								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label is-visible {if isset($errors.sectionIds)}text-danger{/if}">{general:section}</label>
										{html_options options=$sections name="sectionIds[]" id="sectionId" selected=$sectionIds|default:'' class="form-control select-search form-control-sm select" multiple="multiple"}
									</div>
								</div>
	                            <div class="col-md-6">
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible {if isset($errors.title)}text-danger{/if}">{sliders:general:title}</label>
	                                    <input type="text" class="form-control" autocomplete="off" name="banner[title]" value="{$banner.title|default:''}" />
	                                </div>
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible">{sliders:text}</label>
	                                    <input type="text" class="form-control" autocomplete="off" name="banner[text]" value="{$banner.text|default:''}" />
	                                </div>
	                            </div>
	                            <div class="col-md-6">
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible">{sliders:alias}</label>
	                                    <input type="text" class="form-control" autocomplete="off" name="banner[alias]" value="{$banner.alias|default:''}" />
	                                </div>
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible">{sliders:links}</label>
	                                    <input type="text" class="form-control" autocomplete="off" name="banner[url]" value="{$banner.url|default:''}" />
	                                </div>
	                            </div>
	                        </div>
	                    </div>
			        </div>
    		    </div>

				{* фото галерея *}
				{include file="cards/card-gallery.tpl" galleries=$banner.gallery|default:[] enable=$banner.enableGallery|default:0 module='banner'}
				{* /фото галерея *}

	            <div class="card border shadow-sm">
		            <div class="card-header d-flex flex-wrap">
			            <h6 class="mb-0">{general:card:description}</h6>
			            <div class="d-inline-flex ms-auto">
				            <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
			            </div>
		            </div>
		            <div class="card-body collapse show flex-md-row m-0 p-0">
			            <textarea id="description" name="banner[summary]" class="description">{if isset($banner.summary)}{$banner.summary}{/if}</textarea>
		            </div>
	            </div>
            </div>

            <div class="col-md-4">
        		{* STATUS *}
                <div class="card border shadow-sm">
	                <div class="card-header d-flex flex-wrap">
		                <h6 class="mb-0">{general:card:statusAndVisibility}</h6>
		                <div class="d-inline-flex ms-auto">
			                <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
		                </div>
	                </div>
	                <div class="collapse show">
		                <div class="card-body border-top-0">

                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="banner[status]" array=$statuses selected=$banner.status|default:'visible' class="form-group mb-3"}
                            {* /field status *}

							<div class="form-check mb-3">
								<input type="checkbox" class="form-check-input" id="enableGallery" name="banner[enableGallery]" value="1" {if isset($banner.enableGallery) and $banner.enableGallery eq 1}checked{/if} data-bs-toggle="collapse" data-bs-target="#gallery-card">
								<label class="form-check-label" for="enableGallery">Фотогалерея к этой публикации</label>
							</div>

	                    </div>
                        {if isset($banner.addedOn) && isset($banner.modifiedOn)}
		                <div class="card-footer hstack gap-3 justify-content-between">
			                <div class="text-muted">
				                <ul class="list list-unstyled mb-0 fs-sm">
                                    <li>{general:created}</li>
                                    <li>{general:modified}</li>
				                </ul>
			                </div>
			                <div class="hstack gap-1">
				                <ul class="list list-unstyled mb-0 fs-sm">
					                <li>{$banner.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$banner.addedBy.loginName|default:"{general:unknownUser}"})</li>
                                    <li>{$banner.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$banner.modifiedBy.loginName|default:"{general:unknownUser}"})</li>
				                </ul>
			                </div>
		                </div>
                        {/if}
	                </div>
    			</div>

	            {* image preview *}
                {include file="cards/card-image.tpl"
                image="{if isset($banner.image)}{$banner.image.original}{/if}"
                id="{if isset($banner.image)}{$banner.image.imageId}{/if}"
                module='banner'}
                {* /image preview *}

            </div>

	        <div class="col-md-12 main main_buttons text-center">
                {if isset($banner.bannerId)}<input type="hidden" class="form-control" id="id" name="id" value="{$banner.bannerId|default:''}">{/if}
                {$smarty.capture.buttons nofilter}
	        </div>

        </div>
    </div>
</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>
    $(document).ready(function () {
        {if isset($messages.saved)} new Noty({ text: '{sliders:messages:0}', type: 'success' }).show(); {/if}

        {if isset($errors.title)} new Noty({ text: '{sliders:errors:1}', type: 'error' }).show(); {/if}
        {if isset($errors.sectionIds)} new Noty({ text: 'Пожалуйста, выберите хотя бы один раздел, в котором должен отображаться баннер.', type: 'error' }).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: '{sliders:errors:3}', type: 'error', timeout: 1500 }).show(); {/if}
    });

    </script>
