
	<!-- Page header -->
	{capture name="buttons"}
{*		<a class="btn btn-sm btn-primary me-2" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/field?action=add{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-plus"></i></a>*}
		<a class="btn btn-sm btn-icon btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/contenttype?action=add{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-plus"></i></a>
	{/capture}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/contenttypes" class="breadcrumb-item">{$title}</a>
	{/capture}

	{capture name="showBy"}
	    {include file="module/show-by.tpl" url="{$adminUrl}/contenttypes"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->


	<div class="content">
	    <div class="row">
	        <div class="col-md-12">
	            <div class="card border shadow-sm">
		            <div class="">
			            <table class="table table-xs table-togglable table-striped table-hover" id="contenttypes">
		                    <thead>
		                        <tr>
			                        <th class="text-center" width="30">#</th>
		                            <th data-toggle="true">Тип контента</th>
		                            <th data-toggle="true">PATH</th>
		                            <th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
		                        </tr>
		                    </thead>
		                    {if !empty($types)}
			                    <tbody class="sortable">
			                        {foreach item=type from=$types name=types}
			                        <tr id="contenttype-{$type.typeId}" data-id="{$type.typeId}" data-value="{$type.fileName}" class="{if $type.status eq 'H'}table-warning{/if}">
				                        <td class="text-center text-nowrap"><i class="ph-dots-six text-muted"></i></td>
			                            <td class="text-start"> {$type.name nofilter}</td>
			                            <td class="text-start"> {$type.fileName nofilter}</td>
			                            <td class="text-center">
			                                <div class="d-inline-flex">
				                                <a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/contenttype?action=edit&id={$type.typeId}"><i class="ph-note-pencil me-2"></i></a>
			                                    <div class="dropdown">
				                                    <a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>

			                                        <div class="dropdown-menu dropdown-menu-end">
			                                            <a class="dropdown-item" href="{$adminUrl}/contenttype?action=edit&id={$type.typeId}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
														{include file="components/actions/dropdown-status.tpl" module="contenttypes" id=$type.typeId status=$type.status scope=parent}
														{include file="components/actions/dropdown-delete.tpl" id=$type.typeId title="{$type.name|escape|default:''}" module="contenttypes" scope=parent}
			                                        </div>
			                                    </div>
			                                </div>
			                            </td>
			                        </tr>
			                        {/foreach}

			                    </tbody>
		                    {else}
		                        <tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
		                    {/if}
	                    </table>
		            </div>

	                {include file="module/pagination.tpl" url="{$adminUrl}/contenttype" params="{$buildQueryString}"}

	            </div>
	        </div>
	    </div>
	</div>

	<script>
	    $(document).ready(function() {
	        {if isset($errors.not_saved)} new Noty({ text: '{socials:errors:3}', type: 'error', timeout: 1500 }).show(); {/if}
	        {if isset($messages.saved)} new Noty({ text: '{socials:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}
	    });

		$(document).on('click', '.sortable_save_button', function () {
			const ids = [];
			document.querySelectorAll('.sortable tr').forEach(row => {
				const typeId = row.getAttribute('data-id');
				const fileName = row.getAttribute('data-value');
				ids.push({ id: typeId, fileName: fileName });
			});
			console.log(ids);
			fetch("{$adminUrl}/contenttypes?action=reorder", {
				method: 'POST',
				headers: {
					'Content-Type': 'application/json'
				},
				body: JSON.stringify({ ids: ids })
			}).then(response => response.json()).then(response => {
				document.querySelector('.sortable_footer_navbar').classList.remove('show');
				new Noty({ text: response.message, type: response.type, timeout: 1500 }).show();

				if (response.status === 200) {
					setTimeout(() => {
						// location.reload();
					}, 1500);
				}
			}).catch(error => console.error('Error:', error));
		})

        $(document).on('click', '.sortable_cancel_button', function () {
			document.querySelector('.sortable_footer_navbar').classList.remove('show');
            location.reload();
        })

	</script>






