<!-- Inner content -->
<div class="content-inner" data-bs-spy="scroll" data-bs-target="#page_nav">

	<!-- Page header -->
    {capture name="buttons"}{/capture}

    {capture name="breadcrumb"}
		<span class="breadcrumb-item active">{$title}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->
	<!-- Content area -->
	<div class="content">

		<!-- Inner container -->
		<div class="d-flex align-items-stretch align-items-lg-start flex-column flex-lg-row">

			<!-- Left content -->
			<div class="flex-1 order-2 order-lg-1">

				<!-- Scrollspy -->
				<div class="card">
					<div class="card-header"><h5 class="mb-0">Database</h5></div>

					<div class="card-body">
						<div class="mb-4">
							<h6 class="fw-semibold" id="introduction">Конфигурация</h6>
							<pre class="language-php mb-2">
								<code>
$config = [
	'driver'    => 'mysql',
	'host'      => 'localhost',
	'database'  => 'test',
	'username'  => 'root',
	'password'  => '',
	'charset'   => 'utf8',
	'collation' => 'utf8_general_ci',
	'prefix'    => '',
	'options'   => [ ]
];
$db = new Database($config);

# OR

DB::init()->connect();
								</code>
							</pre>
							<p class="mb-2">Теперь можем использовать <kbd>Database</kbd></p>
						</div>
						<!-- How it works -->
						<div class="mb-4">
							<h6 class="fw-semibold" id="introduction">Пример использования</h6>
							<p>Класс <kbd>\Mnv\Core\Database\Database</kbd> предоставляет свободную и удобную оболочку для работы с базой данных.
								Например, ознакомьтесь со следующим кодом.
								Мы будем использовать помощник <code>connect()</code> для создания нового экземпляра <kbd>Database</kbd> :</p>

							<pre class="language-php mb-2">
								<code>
DB::init()->connect();
$records = DB::init()->connect()->table('users')->select('id, name, surname, age')->where('age', '>', 18)->orderBy('id', 'desc')->limit(20)->getAll();

var_dump($records);

# OR

connect();
$records = connect()->table('users')->select('id, name, surname, age')->where('age', '>', 18)->orderBy('id', 'desc')->limit(20)->getAll();

var_dump($records);

# OR

connect('users');
$records = connect('users')->select('id, name, surname, age')->where('age', '>', 18)->orderBy('id', 'desc')->limit(20)->getAll();

var_dump($records);
								</code>
							</pre>
							<div class="alert bg-info text-white alert-icon-start alert-dismissible fade show border-0">
								<span class="alert-icon bg-black bg-opacity-20"><i class="ph-info"></i></span>
								<span class="fw-semibold">Примечание!</span> Так же название таблицы можно передать в `connect('users')`.
							</div>

						</div>

						<div class="mb-4">
							<h6 class="fw-semibold" id="available-methods">Доступные методы</h6>
							<p class="mb-3">В большей части оставшейся документации коллекции мы обсудим каждый метод, доступный в классе <kbd>Collection</kbd>.<br>
								Помните, что все эти методы могут быть объединены в цепочку для плавного управления базовым массивом.
								Кроме того, почти каждый метод возвращает новый <kbd>Database</kbd> экземпляр, что позволяет при необходимости сохранить исходную копию коллекции:
							</p>

							<div class="mb-3">
								<ul class="list-inline mb-0">
									<li class="list-inline-item"><a href="#method-select">select</a></li>
									<li class="list-inline-item"><a href="#method-select-functions-min-max-sum-avg-count">select functions (min, max, sum, avg, count)</a></li>
									<li class="list-inline-item"><a href="#method-table">table</a></li>
									<li class="list-inline-item"><a href="#method-get-and-getall">get AND getAll</a></li>
									<li class="list-inline-item"><a href="#method-pluck">pluck</a></li>
									<li class="list-inline-item"><a href="#method-keyBy">keyBy</a></li>
									<li class="list-inline-item"><a href="#method-join">join</a></li>
									<li class="list-inline-item"><a href="#method-where">where</a></li>
									<li class="list-inline-item"><a href="#method-in">whereIn</a></li>
									<li class="list-inline-item"><a href="#method-whereAny">whereAny</a></li>
									<li class="list-inline-item"><a href="#method-in">in</a></li>
									<li class="list-inline-item"><a href="#method-whereExists">whereExists</a></li>
									<li class="list-inline-item"><a href="#method-grouped">grouped</a></li>
									<li class="list-inline-item"><a href="#method-findInSet">findInSet</a></li>
									<li class="list-inline-item"><a href="#method-between">between</a></li>
									<li class="list-inline-item"><a href="#method-like">like</a></li>
									<li class="list-inline-item"><a href="#method-groupBy">groupBy</a></li>
									<li class="list-inline-item"><a href="#method-having">having</a></li>
									<li class="list-inline-item"><a href="#method-orderBy">orderBy</a></li>
									<li class="list-inline-item"><a href="#method-limit-offset">limit - offset</a></li>
									<li class="list-inline-item"><a href="#method-pagination">pagination</a></li>
									<li class="list-inline-item"><a href="#method-insert">insert</a></li>
									<li class="list-inline-item"><a href="#method-update">update</a></li>
									<li class="list-inline-item"><a href="#method-increment">increment</a></li>
									<li class="list-inline-item"><a href="#method-delete">delete</a></li>
									<li class="list-inline-item"><a href="#method-query">query</a></li>
									<li class="list-inline-item"><a href="#method-analyze">analyze</a></li>
									<li class="list-inline-item"><a href="#method-check">check</a></li>
									<li class="list-inline-item"><a href="#method-checksum">checksum</a></li>
									<li class="list-inline-item"><a href="#method-optimize">optimize</a></li>
									<li class="list-inline-item"><a href="#method-repair">repair</a></li>
									<li class="list-inline-item"><a href="#method-insertId">insertId</a></li>
									<li class="list-inline-item"><a href="#method-numRows">numRows</a></li>
									<li class="list-inline-item"><a href="#method-cache">cache</a></li>
									<li class="list-inline-item"><a href="#method-transaction">transaction</a></li>
									<li class="list-inline-item"><a href="#method-transaction">commit</a></li>
									<li class="list-inline-item"><a href="#method-transaction">rollBack</a></li>
									<li class="list-inline-item"><a href="#method-error">error</a></li>
									<li class="list-inline-item"><a href="#method-queryCount">queryCount</a></li>
									<li class="list-inline-item"><a href="#method-getQuery">getQuery</a></li>
								</ul>
							</div>
						</div>

						<div class="mb-4">
							<div class="mb-3">
								<h6 class="fw-semibold" id="method-select">select()</h6>
								<p>Метод <code>select()</code> :</p>
								<pre class="language-php mb-2">
									<code>
# Использование 1: string parameter
connect()->select('title, content')->table('test')->getAll();
# Результат: "SELECT title, content FROM test"

connect()->select('title AS t, content AS c')->table('test')->getAll();
# Результат: "SELECT title AS t, content AS c FROM test"

# Использование: array parameter
connect()->select(['title', 'content'])->table('test')->getAll();
# Результат: "SELECT title, content FROM test"

connect()->select(['title AS t', 'content AS c'])->table('test')->getAll();
# Результат: "SELECT title AS t, content AS c FROM test"
									</code>
								</pre>
							</div>
							<div class="mb-3">
								<h6 class="fw-semibold" id="method-select-functions-min-max-sum-avg-count">select functions (min(), max(), sum(), avg(), count())</h6>
								<p>Метод <code>max()</code> , <code>count()</code> :</p>
								<pre class="language-php mb-2">
									<code>
# Использование 1:
connect()->table('test')->max('price')->get();
# Результат: "SELECT MAX(price) FROM test"

# Использование 2:
connect()->table('test')->count('id', 'total_row')->get();
# Результат: "SELECT COUNT(id) AS total_row FROM test"
									</code>
								</pre>
							</div>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-table">table()</h6>
							<p>Метод <code>table()</code> :</p>
							<pre class="language-php mb-2">
								<code>
### Использование 1: string parameter
connect()->table('table');
# Результат: "SELECT * FROM table"

connect()->table('table1, table2');
# Результат: "SELECT * FROM table1, table2"

connect()->table('table1 AS t1, table2 AS t2');
# Результат: "SELECT * FROM table1 AS t1, table2 AS t2

### Использование 2: array parameter
connect()->table(['table1', 'table2']);
# Результат: "SELECT * FROM table1, table2"

connect()->table(['table1 AS t1', 'table2 AS t2']);
# Результат: "SELECT * FROM table1 AS t1, table2 AS t2"
								</code>
							</pre>

						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-get-and-getall">get() AND getAll()</h6>
							<p>Метод <code>get() AND getAll()</code> :</p>
							<pre class="language-php mb-2">
								<code>
# get(): return 1 record.
# getAll(): return multiple records.

$db->table('test')->getAll();
# Результат: "SELECT * FROM test"

$db->select('username')->table('users')->where('status', 1)->getAll();
# Результат: "SELECT username FROM users WHERE status='1'"

$db->select('title')->table('pages')->where('id', 17)->get();
# Результат: "SELECT title FROM pages WHERE id='17' LIMIT 1"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-pluck">pluck()</h6>
							<p>Метод <code>pluck()</code> :</p>
							<pre class="language-php mb-2">
								<code>

$db->table('users')->select('user_id, username')->pluck('username', 'user_id');
# Результат: Array(
#	'1' => 'john'
#)

$db->table('users')->select('user_id, username')->where('id', 17)->pluck('username');
# Результат: Array (
#    [0] => 'john',
#    [1] => 'ivanov'
#)

								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-keyBy">keyBy()</h6>
							<p>Метод <code>keyBy()</code> :</p>
							<pre class="language-php mb-2">
								<code>

$db->table('users')->select('user_id, username, email')->keyBy('user_id');
# Результат: Array(
#	'1' => array (
		'username' => 'john',
		'email' => 'john@gmail.com',
	)
#)


								</code>
							</pre>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-join">join()</h6>
							<p>Метод <code>join()</code> :</p>
							<pre class="language-php mb-2">
								<code>
$db->table('test as t')->join('foo as f', 't.id', 'f.t_id')->where('t.status', 1)->getAll();
# Результат: "SELECT * FROM test as t JOIN foo as f ON t.id=f.t_id WHERE t.status='1'"
								</code>
							</pre>
							<p class="mb-2">
								You can use this method in 7 ways. These;<br>
								<br>
								- join<br>
								- left_join<br>
								- right_join<br>
								- inner_join<br>
								- full_outer_join<br>
								- left_outer_join<br>
								- right_outer_join<br>
								<br>
								Примеры:
							</p>
							<pre class="language-php mb-2">
								<code>
$db->table('test as t')->leftJoin('foo as f', 't.id', 'f.t_id')->getAll();
# Результат: "SELECT * FROM test as t LEFT JOIN foo as f ON t.id=f.t_id"
								</code>
							</pre>
							<pre class="language-php mb-2">
								<code>
$db->table('test as t')->fullOuterJoin('foo as f', 't.id', 'f.t_id')->getAll();
# Результат: "SELECT * FROM test as t FULL OUTER JOIN foo as f ON t.id=f.t_id"
								</code>
							</pre>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-where">where()</h6>
							<p>Метод <code>where()</code> :</p>
							<pre class="language-php mb-2">
								<code>
$where = [
	'name' => 'Burak',
	'age' => 23,
	'status' => 1
];
$db->table('test')->where($where)->get();
# Результат: "SELECT * FROM test WHERE name='Burak' AND age='23' AND status='1' LIMIT 1"

# OR

$db->table('test')->where('active', 1)->getAll();
# Результат: "SELECT * FROM test WHERE active='1'"

# OR

$db->table('test')->where('age', '>=', 18)->getAll();
# Результат: "SELECT * FROM test WHERE age>='18'"

# OR

$db->table('test')->where('age = ? OR age = ?', [18, 20])->getAll();
# Результат: "SELECT * FROM test WHERE age='18' OR age='20'"
								</code>
							</pre>
							<p class="mb-2">You can use this method in 4 ways. These;<br>
								<br>
								- where<br>
								- orWhere<br>
								- notWhere<br>
								- orNotWhere<br>
								- whereNull<br>
								- whereNotNull<br>
								<br>
								Примеры:
							</p>
							<pre class="language-php mb-3">
								<code>
$db->table('test')->where('active', 1)->notWhere('auth', 1)->getAll();
# Результат: "SELECT * FROM test WHERE active = '1' AND NOT auth = '1'"

# OR

$db->table('test')->where('age', 20)->orWhere('age', '>', 25)->getAll();
# Результат: "SELECT * FROM test WHERE age = '20' OR age > '25'"

$db->table('test')->whereNotNull('email')->getAll();
# Результат: "SELECT * FROM test WHERE email IS NOT NULL"
								</code>
							</pre>
						</div>


						<div class="mb-3">
							<h6 class="fw-semibold" id="method-whereExists">whereExists()</h6>
							<p>Метод <code>whereExists()</code> :</p>
							<pre class="language-php mb-2">
								<code>
$db->table('users')
	->whereExists(function($q) {
        $q->table('book_genres AS bg')->selectExists('1')->where(['bg.bookId' => 'b.bookId']);
    })
	->where('status', 'V')
	->orderBY('popularity DESC')
 	->pagination(10, 1)
	->getAll('array');
# Результат: "SELECT * FROM books AS b WHERE b.status = 'V' AND EXISTS (SELECT 1 FROM book_genres AS bg WHERE bg.bookId=b.bookId) ORDER BY popularity DESC LIMIT 10 OFFSET 0;"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-whereAny">whereAny()</h6>
							<p>Метод <code>whereAny()</code> :</p>
							<pre class="language-php mb-2">
								<code>
$db->table('users')->whereAny(['firstName', 'lastName', 'fullName', 'phone'], 'like', "%" . $this->filter['query'] . "%");
	->where('userType', 'C')
 	->pagination(20, 1)
	->getAll('array');
# Результат: "SELECT * FROM users WHERE (loginName like '%wer%' OR fullName like '%wer%' OR firstName like '%wer%' OR lastName like '%wer%' OR phone like '%wer%') AND userType = 'C' LIMIT 20 OFFSET 0"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-in">whereIn() или in()</h6>
							<p>Метод <code>whereIn() или in()</code> :</p>
							<pre class="language-php mb-2">
								<code>
$db->table('test')->where('active', 1)->whereIn('id', [1, 2, 3])->getAll();
$db->table('test')->where('active', 1)->in('id', [1, 2, 3])->getAll();
# Результат: "SELECT * FROM test WHERE active = '1' AND id IN ('1', '2', '3')"
								</code>
							</pre>
							<p class="mb-2">
								You can use this method in 4 ways. These;<br>
								<br>
								- whereIn<br>
								- in<br>
								- orIn<br>
								- notIn<br>
								- orNotIn<br>
								<br>
								Примеры:
							</p>
							<pre class="language-php mb-2">
								<code>
$db->table('test')->where('active', 1)->notIn('id', [1, 2, 3])->getAll();
# Результат: "SELECT * FROM test WHERE active = '1' AND id NOT IN ('1', '2', '3')"

# OR

$db->table('test')->where('active', 1)->orIn('id', [1, 2, 3])->getAll();
# Результат: "SELECT * FROM test WHERE active = '1' OR id IN ('1', '2', '3')"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-grouped">grouped()</h6>
							<p>Метод <code>grouped()</code> :</p>
							<pre class="language-php mb-2">
								<code>
$db->table('users')
	->grouped(function($q) {
		$q->where('country', 'UZBEKISTAN')->orWhere('country', 'ENGLAND');
	})
	->where('status', 1)
	->getAll();
# Результат: "SELECT * FROM users WHERE (country='UZBEKISTAN' OR country='ENGLAND') AND status ='1'"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-findInSet">findInSet()</h6>
							<p>Метод <code>findInSet()</code> :</p>
							<pre class="language-php mb-2">
								<code>
$db->table('test')->where('active', 1)->findInSet('selected_ids', 1)->getAll();
# Output: "SELECT * FROM test WHERE active = '1' AND FIND_IN_SET (1, selected_ids)"
								</code>
							</pre>
							<p class="mb-2">
								You can use this method in 4 ways. These;<br>
								<br>
								- findInSet<br>
								- orFindInSet<br>
								- notFindInSet<br>
								- orNotFindInSet<br>
								<br>
								Примеры:</p>
							<pre class="language-php mb-2">
								<code>
$db->table('test')->where('active', 1)->notFindInSet('selected_ids', 1)->getAll();
# Output: "SELECT * FROM test WHERE active = '1' AND NOT FIND_IN_SET (1, selected_ids)"

# OR

$db->table('test')->where('active', 1)->orFindInSet('selected_ids', 1)->getAll();
# Output: "SELECT * FROM test WHERE active = '1' OR FIND_IN_SET (1, selected_ids)"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-between">between()</h6>
							<p>Метод <code>between()</code> :</p>
							<pre class="language-php mb-2">
								<code>
$db->table('test')->where('active', 1)->between('age', 18, 25)->getAll();
# Результат: "SELECT * FROM test WHERE active = '1' AND age BETWEEN '18' AND '25'"
								</code>
							</pre>
							<p class="mb-2">
								You can use this method in 4 ways. These;

								- between
								- orBetween
								- notBetween
								- orNotBetween

								Example:
							</p>
							<pre class="language-php mb-2">
								<code>
$db->table('test')->where('active', 1)->notBetween('age', 18, 25)->getAll();
# Результат: "SELECT * FROM test WHERE active = '1' AND age NOT BETWEEN '18' AND '25'"

# OR

$db->table('test')->where('active', 1)->orBetween('age', 18, 25)->getAll();
# Результат: "SELECT * FROM test WHERE active = '1' OR age BETWEEN '18' AND '25'"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-like">like()</h6>
							<p>Метод <code>like()</code> :</p>
							<pre class="language-php mb-2">
								<code>
$db->table('test')->like('title', "%php%")->getAll();
# Результат: "SELECT * FROM test WHERE title LIKE '%php%'"
								</code>
							</pre>
							<p class="mb-2">
								You can use this method in 4 ways. These;<br>
								<br>
								- like<br>
								- orLike<br>
								- notLike<br>
								- orNotLike<br>
								<br>
								Примеры:
							</p>
							<pre class="language-php mb-2">
								<code>
$db->table('test')->where('active', 1)->notLike('tags', '%dot-net%')->getAll();
# Результат: "SELECT * FROM test WHERE active = '1' AND tags NOT LIKE '%dot-net%'"

# OR

$db->table('test')->like('bio', '%php%')->orLike('bio', '%java%')->getAll();
# Результат: "SELECT * FROM test WHERE bio LIKE '%php%' OR bio LIKE '%java%'"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-groupBy">groupBy()</h6>
							<p>Метод <code>groupBy()</code> :</p>
							<pre class="language-php mb-2">
								<code>
# Использование 1: One parameter
$db->table('test')->where('status', 1)->groupBy('cat_id')->getAll();
# Результат: "SELECT * FROM test WHERE status = '1' GROUP BY cat_id"
								</code>
							</pre>
							<pre class="language-php mb-2">
								<code>
# Использование 1: Array parameter
$db->table('test')->where('status', 1)->groupBy(['cat_id', 'user_id'])->getAll();
# Результат: "SELECT * FROM test WHERE status = '1' GROUP BY cat_id, user_id"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-having">having()</h6>
							<p>Метод <code>having()</code> :</p>
							<pre class="language-php mb-2">
								<code>
$db->table('test')->where('status', 1)->groupBy('city')->having('COUNT(person)', 100)->getAll();
# Результат: "SELECT * FROM test WHERE status='1' GROUP BY city HAVING COUNT(person) > '100'"

# OR

$db->table('test')->where('active', 1)->groupBy('department_id')->having('AVG(salary)', '<=', 500)->getAll();
# Результат: "SELECT * FROM test WHERE active='1' GROUP BY department_id HAVING AVG(salary) <= '500'"

# OR

$db->table('test')->where('active', 1)->groupBy('department_id')->having('AVG(salary) > ? AND MAX(salary) < ?', [250, 1000])->getAll();
# Результат: "SELECT * FROM test WHERE active='1' GROUP BY department_id HAVING AVG(salary) > '250' AND MAX(salary) < '1000'"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-orderBy">orderBy()</h6>
							<p>Метод <code>orderBy()</code> :</p>
							<pre class="language-php mb-2">
								<code>
# Использование 1: One parameter
$db->table('test')->where('status', 1)->orderBy('id')->getAll();
# Результат: "SELECT * FROM test WHERE status='1' ORDER BY id ASC"

### OR

$db->table('test')->where('status', 1)->orderBy('id desc')->getAll();
# Результат: "SELECT * FROM test WHERE status='1' ORDER BY id desc"
								</code>
							</pre>
							<pre class="language-php mb-2">
								<code>
# Использование 1: Two parameters
$db->table('test')->where('status', 1)->orderBy('id', 'desc')->getAll();
# Результат: "SELECT * FROM test WHERE status='1' ORDER BY id DESC"
								</code>
							</pre>
							<pre class="language-php mb-2">
								<code>
# Использование 3: Rand()
$db->table('test')->where('status', 1)->orderBy('rand()')->limit(10)->getAll();
# Результат: "SELECT * FROM test WHERE status='1' ORDER BY rand() LIMIT 10"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-limit-offset">limit() - offset()</h6>
							<p>Метод <code>limit()</code> ,<code>offset()</code> :</p>
							<pre class="language-php mb-2">
								<code>
# Использование 1: One parameter
$db->table('test')->limit(10)->getAll();
# Результат: "SELECT * FROM test LIMIT 10"
								</code>
							</pre>
							<pre class="language-php mb-2">
								<code>
# Использование 2: Two parameters
$db->table('test')->limit(10, 20)->getAll();
# Результат: "SELECT * FROM test LIMIT 10, 20"

# Использование 3: with offset method
$db->table('test')->limit(10)->offset(10)->getAll();
# Результат: "SELECT * FROM test LIMIT 10 OFFSET 10"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-pagination">pagination()</h6>
							<p>Метод <code>pagination()</code> :</p>
							<pre class="language-php mb-2">
								<code>
# First parameter: Data count of per page
# Second parameter: Active page

$db->table('test')->pagination(15, 1)->getAll();
# Результат: "SELECT * FROM test LIMIT 15 OFFSET 0"

$db->table('test')->pagination(15, 2)->getAll();
# Результат: "SELECT * FROM test LIMIT 15 OFFSET 15"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-insert">insert()</h6>
							<p>Метод <code>insert()</code> :</p>
							<pre class="language-php mb-2">
								<code>
$data = [
	'title' => 'test',
	'content' => 'Lorem ipsum dolor sit amet...',
	'time' => '2017-05-19 19:05:00',
	'status' => 1
];

$db->table('pages')->insert($data);
# Результат: "INSERT INTO test (title, content, time, status) VALUES ('test', 'Lorem ipsum dolor sit amet...', '2017-05-19 19:05:00', '1')"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-update">update()</h6>
							<p>Метод <code>update()</code> :</p>
							<pre class="language-php mb-2">
								<code>
$data = [
	'username' => 'admin',
	'password' => 'pass',
	'activation' => 1,
	'status' => 1
];

$db->table('users')->where('id', 10)->update($data);
# Результат: "UPDATE users SET username='admin', password='pass', activation='1', status='1' WHERE id='10'"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-increment">increment()</h6>
							<p>Метод <code>increment()</code> :</p>
							<pre class="language-php mb-2">
								<code>

$incrementValue = 1;

connect('contents')->where('content_id', 1)->increment('counter', $incrementValue);
# Результат: "UPDATE articles SET counter=counter + 1 WHERE articleId = '2'"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-delete">delete()</h6>
							<p>Метод <code>delete()</code> :</p>
							<pre class="language-php mb-2">
								<code>
$db->table('test')->where("id", 17)->delete();
# Результат: "DELETE FROM test WHERE id = '17'"

# OR

$db->table('test')->delete();
# Результат: "TRUNCATE TABLE delete
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-transaction">transaction()</h6>
							<p>Метод <code>transaction()</code> :</p>
							<pre class="language-php mb-2">
								<code>
$db->transaction();

$data = [
	'title' => 'new title',
	'status' => 2
];
$db->table('test')->where('id', 10)->update($data);

$db->commit();
# OR
$db->rollBack();
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-analyze">analyze()</h6>
							<p>Метод <code>analyze()</code> генерирует табличную статистику:</p>
							<pre class="language-php mb-2">
								<code>
$db->table('users')->analyze();
# Результат: "ANALYZE TABLE users"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-check">check()</h6>
							<p>Метод <code>check()</code> проверяет таблицу или таблицы на наличие ошибок:</p>
							<pre class="language-php mb-2">
								<code>
$db->table(['users', 'pages'])->check();
# Результат: "CHECK TABLE users, pages"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-checksum">checksum()</h6>
							<p>Метод <code>checksum()</code> возвращает контрольную сумму, которая вычисляется построчно, используя метод, зависящий от формата хранения строк таблицы:</p>
							<pre class="language-php mb-2">
								<code>
$db->table(['users', 'pages'])->checksum();
# Результат: "CHECKSUM TABLE users, pages"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-optimize">optimize()</h6>
							<p>Метод <code>optimize()</code> реорганизует физическое хранилище данных таблицы и связанных данных индекса, чтобы уменьшить пространство для хранения и повысить эффективность ввода-вывода при доступе к таблице:</p>
							<pre class="language-php mb-2">
								<code>
$db->table(['users', 'pages'])->optimize();
# Результат: "OPTIMIZE TABLE users, pages"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-repair">repair()</h6>
							<p>Метод <code>repair()</code> восстанавливает возможно поврежденную таблицу только для определенных механизмов хранения:</p>
							<pre class="language-php mb-2">
								<code>
$db->table(['users', 'pages'])->repair();
# Результат: "REPAIR TABLE users, pages"
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-query">query()</h6>
							<p>Метод <code>query()</code> :</p>
							<pre class="language-php mb-2">
								<code>
# Использование 1: Выберите все записи
$db->query('SELECT * FROM test WHERE id=? AND status=?', [10, 1])->fetchAll();

# Использование 2: Выберите одну запись
$db->query('SELECT * FROM test WHERE id=? AND status=?', [10, 1])->fetch();

# Использование 3: Другие запросы, такие как Update, Insert, Delete etc...
$db->query('DELETE FROM test WHERE id=?', [10])->exec();
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-insertId">insertId()</h6>
							<p>Метод <code>insertId()</code> возвращает значение, созданное для столбца AUTO_INCREMENT последним запросом :</p>
							<pre class="language-php mb-2">
								<code>
$data = [
	'title' => 'test',
	'content' => 'Lorem ipsum dolor sit amet...',
	'time' => time(),
	'status' => 1
];
$db->table('pages')->insert($data);

var_dump($db->insertId());
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-numRows">numRows()</h6>
							<p>Метод <code>numRows()</code> возвращает количество рядов результата запроса:</p>
							<pre class="language-php mb-2">
								<code>
$db->select('id, title')->table('test')->where('status', 1)->orWhere('status', 2)->getAll();

var_dump($db->numRows());
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-error">error()</h6>
							<p>Метод <code>error()</code> получение ошибки:</p>
							<pre class="language-php mb-2">
								<code>
$db->error();
								</code>
							</pre>
						</div>


						<div class="mb-3">
							<h6 class="fw-semibold" id="method-cache">cache()</h6>
							<p>Метод <code>cache()</code> кэширование запроса:</p>
							<pre class="language-php mb-2">
								<code>
# Использование: ...->cache($time)->...
$db->table('pages')->where('slug', 'example-page')->cache(60)->get();
# время кэширования: 60 секунд
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-queryCount">queryCount()</h6>
							<p>Метод <code>queryCount()</code> количество всех SQL-запросов на странице от начала до конца:</p>
							<pre class="language-php mb-2">
								<code>
$db->queryCount();
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-getQuery">getQuery()</h6>
							<p>Метод <code>getQuery()</code> последний SQL-запрос:</p>
							<pre class="language-php mb-2">
								<code>
$db->getQuery();
								</code>
							</pre>
						</div>

					</div>
				</div>
			</div>

			<div class="sticky-lg-top order-1 order-lg-2 wmin-lg-300 ms-lg-3 mb-3" id="page_nav">
				<h6 class="fw-semibold mt-lg-3 mb-3">Database</h6>

				<ul class="nav nav-scrollspy flex-column">
					<li class="nav-item"><a href="#introduction" class="nav-link">Введение</a></li>
					<li class="nav-item">
						<a href="#available-methods" class="nav-link">Доступные методы</a>
						<ul class="nav nav-scrollspy flex-column">
							<li class="nav-item"><a href="#method-all" class="nav-link">all</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-select">select</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-pluck">pluck</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-keyBy">keyBy</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-join">join</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-where">where</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-grouped">grouped</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-whereExists">whereExists</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-in">in</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-between">between</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-like">like</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-groupBy">groupBy</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-having">having</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-orderBy">orderBy</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-limit-offset">limit - offset</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-pagination">pagination</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-insert">insert</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-update">update</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-increment">increment</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-delete">delete</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-query">query</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-analyze">analyze</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-check">check</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-checksum">checksum</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-optimize">optimize</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-repair">repair</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-insertId">insertId</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-numRows">numRows</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-cache">cache</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-transaction">transaction</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-transaction">commit</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-transaction">rollBack</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-error">error</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-queryCount">queryCount</a></li>
							<li class="nav-item"><a class="nav-link" href="#method-getQuery">getQuery</a></li>
						</ul>
					</li>
				</ul>
			</div>

		</div>

	</div>
</div>