
	<!-- Page header -->
	{capture name="buttons"}
		<a class="btn btn-sm btn-icon btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="top" href="{$adminUrl}/faq?action=add"><i class="ph-plus"></i></a>
	{/capture}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/faqs" class="breadcrumb-item">{$title}</a>
	{/capture}

	{capture name="showBy"}
	    {include file="module/show-by.tpl" url="{$adminUrl}/faqs"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->


	<div class="content">

	    <div class="row">
	        <div class="col-md-12">
	            <div class="card border shadow-sm">
		            <div class="">
		                <table class="table table-togglable table-xs table-striped table-hover" id="faqs">
		                    <thead>
		                        <tr>
		                            <th data-hide="ID" class="text-center" width="30">#</th>
		                            <th data-toggle="true">Вопрос</th>
		                            <th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
		                        </tr>
		                    </thead>
		                    {if $faqs}
		                    <tbody class="sortable">
		                        {foreach item=faq from=$faqs name=faqs}
		                        <tr id="faq-{$faq.faqId}" data-id="{$faq.faqId}" class="{if $faq.status eq 'H'}table-warning{/if}">
			                        <td class="text-center text-nowrap"><i class="ph-dots-six text-muted" data-bs-popup="tooltip" title="Переместить" data-bs-placement="auto"></i></td>
		                            <td width="100%">{$faq.question|escape nofilter}</td>
		                            <td class="text-center">
		                                <div class="d-inline-flex">
			                                <a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/faq?action=edit&id={$faq.faqId}"><i class="ph-note-pencil me-2"></i></a>
		                                    <div class="list-icons-item dropdown">
			                                    <a type="button" class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>

		                                        <div class="dropdown-menu dropdown-menu-right">
		                                            <a class="dropdown-item" href="{$adminUrl}/faq?action=edit&id={$faq.faqId}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
													{include file="components/actions/dropdown-status.tpl" module="faqs" id=$faq.faqId status=$faq.status scope=parent}
													{include file="components/actions/dropdown-delete.tpl" id=$faq.faqId title="{$faq.question|escape|default:''}" module="faqs" scope=parent}
		                                        </div>
		                                    </div>
		                                </div>
		                            </td>
		                        </tr>
		                        {/foreach}
		                    </tbody>
		                {else}
		                    <tbody><tr class="odd"><td class="text-center" colspan="6">- {general:none} -</td></tr></tbody>
		                    {/if}
		                </table>
		            </div>
                    {include file="module/pagination.tpl" url="{$adminUrl}/faqs" params="{$buildQueryString}"}
	            </div>
	        </div>
	    </div>

	</div>

	<script>
    $(document).ready(function () {
        {if isset($errors.not_saved)} new Noty({ text: 'Вопрос не сохранен', type: 'error' }).show(); {/if}
        {if isset($messages.saved)} new Noty({ text: 'Вопрос сохранен', type: 'success' }).show(); {/if}
    });


	$(document).on('click', '.sortable_save_button', function () {
        var ids = new Array();
        $('.sortable tr').each(function () {
            console.log($(this).attr('data-id'))

            ids.push($(this).attr('data-id'));
        })
        $.post( "{$adminUrl}/faqs?action=reorder", { ids : ids }, function( data ) {
            $('.sortable_footer_navbar').removeClass('show');
            // location.reload();
        });
    })
    $(document).on('click', '.sortable_cancel_button', function () {
        $('.sortable_footer_navbar').removeClass('show');
        location.reload();
    })



</script>


