<!-- Page header -->
{capture name="buttons"}
{/capture}

{capture name="breadcrumb"}
	<a href="{$adminUrl}/feedbacks" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url="{$adminUrl}/feedbacks"}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->


<!-- Content area -->
<div class="content">

	<div class="row">
		<div class="col-md-12">
			<div class="card">
				<form action="{$adminUrl}/feedbacks" method="post">
					<div class="card-header bg-light py-2 d-sm-flex align-items-sm-center">
						<div class="mb-0">
							<div class="input-group">
								<input type="text" class="form-control" name="query" value="{$query|default:''}" autocomplete="off" placeholder="{general:searchByName}">
								<button type="submit" class="btn btn-sm btn-primary"><i class="icon-search4 me-2"></i>{general:search}</button>
							</div>
						</div>

						<div class="ms-sm-auto">
							<ul class="list-inline list-inline-condensed mb-0">
								<li class="list-inline-item">
									<div class="input-group">
										{if isset($types) && !empty($types)}
											{html_options options=$types selected=$filter.type|default:'' name="filter[type]" class="form-control select" onchange="this.form.submit()" data-width="250"}
										{/if}

										{if isset($statuses) && !empty($statuses)}
											{html_options options=$statuses selected=$filter.status|default:'' name="filter[status]" class="form-control select" onchange="this.form.submit()" data-width="200"}
										{/if}

									</div>

								</li>
							</ul>
						</div>
					</div>
				</form>
			</div>

			<div class="card border shadow-sm">
				<div class="">
					<table class="table table-togglable table-striped table-hover mails-archive" id="feedbacks">
						<thead>
						<tr>
							<th class="text-center" width="100">{users:table:date}</th>
							<th class="text-start">Ф.И.О.</th>
							<th class="text-start">{users:table:phone}</th>
							<th class="text-start" width="30%">Сообщение</th>
							<th class="text-start">Файл</th>
							<th class="text-center">Тема</th>
							<th class="text-center">{general:table:status}</th>
							<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
						</tr>
						</thead>
                        {if !empty($feedbackDays)}
							<tbody>
                            {foreach item=feedbackDay from=$feedbackDays key=daysAgo}
								<tr class="table-light">
									<td colspan="8">
										{if $daysAgo eq 0}
											Сегодня
										{elseif $daysAgo eq 1}
											Вчера
										{else}
											<span class="fw-semibold">{$daysAgo}</span> {$daysAgo|plural:'день':'дней':'дня'} назад
										{/if}
									</td>
								</tr>
								{foreach item=feedback from=$feedbackDay name=feedbacks}
									<tr id="feedback-{$feedback.id}" data-id="{$feedback.id}" class="{if $feedback.status eq 'hidden'}table-warning{/if}">
										<td class="text-center text-nowrap"><b>{$feedback.created}</b></td>
										<td class="text-start text-nowrap">{$feedback.fullName}</td>
										<td class="text-start text-nowrap">{$feedback.phone}</td>

										<td class="text-start">{$feedback.message nofilter}</td>
										<td class="text-start">
											{if !empty($feedback.file)}
												<div class="bg-light rounded p-2 my-2">
													<div class="d-flex align-items-center">
														<div class="flex-fill">Бриф <div class="fs-sm text-muted">{$feedback.fileSize}</div></div>
														<div class="ms-2">
															<button type="button" class="btn btn-flat-dark text-body btn-icon btn-sm border-transparent rounded-pill" onclick="downloadFile('{$GLOBAL_URL}{$feedback.file}')">
																<i class="ph-arrow-down"></i>
															</button>
														</div>
													</div>
												</div>
											{/if}
										</td>
										<td class="text-center">
											<span class="badge bg-{if $feedback.subject eq 'Заказ'}success	{else}warning{/if}">{$feedback.subject nofilter}</span>
										</td>
										<td class="text-start">
											{html_options options=$statuses name="feedback[status]" id="status_{$feedback.id}" selected=$feedback.status|default:"" data-id="{$feedback.id}" class="form-control select change_status"}
										</td>
										<td class="text-center">
											<div class="d-inline-flex">
												<a class="text-primary btn btn-link p-1" href="{$adminUrl}/feedback?action=read&id={$feedback.id}"><i class="ph-note-pencil"></i></a>
												<button class="dropdown-item text-danger ms-2" onclick="remove({$feedback.id}, '{$feedback.fullName|escape|default:''}', 'feedbacks');"><i class="ph-trash me-2"></i></button>
											</div>
										</td>
									</tr>
								{/foreach}
                            {/foreach}

							</tbody>
                        {else}
							<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                        {/if}
					</table>
				</div>
                {include file="module/pagination.tpl" url="{$adminUrl}/feedbacks" params="{$buildQueryString}"}
			</div>
		</div>

	</div>
</div>

<script>

	$(document).on('change', '.change_status', function () {
        var $this = $(this), id = $this.attr('data-id'), status = $this.val();

		// Make the POST request with Fetch API
		fetch("{$adminUrl}/feedbacks?action=status", {
			method: 'POST',
			headers: {
				'Content-Type': 'application/json',
			},
			body: JSON.stringify({ id: id, status: status})
		}).then(response => response.json()).then(data => {
			new Noty({ text: data.message, type: data.type }).show();
		}).catch(error => {
			console.error('Error:', error);
		});

    })

</script>
