<form method="post" enctype="multipart/form-data">
	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/form?action=edit{if isset($formId)}&id={$formId}{/if}"}

    {capture name="breadcrumb"}
	    <a href="{$adminUrl}/forms" class="breadcrumb-item">Тип контента</a>
		<a href="{$adminUrl}/form?action=edit{if isset($formId)}&id={$formId}{/if}" class="breadcrumb-item">{$title|default:''}</a>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">

		<div class="row">
			<div class="col-md-12">
				<div class="card border shadow-sm">
					<div class="card-body">
						<div class="row mb-3">
							<label class="col-lg-3 col-form-label">Тип:</label>
							<div class="col-lg-9 d-flex justify-content-start">
								<div class="field-types me-2">
									{html_options options=$types name="button[type]" id="type" selected=$button.type|default:'' class="form-control form-control-sm select"  data-width='220'}
								</div>
							</div>
						</div>

						<div class="row mb-3">
							<label class="col-lg-3 col-form-label {if isset($errors.name)}text-danger{/if}">Наименование:</label>
							<div class="col-lg-9"><input type="text" class="form-control" id="label" autocomplete="off" name="button[label]" value="{$button.label|default:''}"></div>
						</div>


						<div class="row mb-3">
							<label class="col-lg-3 col-form-label {if isset($errors.name) || isset($errors.nameExists) || isset($errors.nameCharacters)}text-danger{/if}">Наименование на анг.:</label>
							<div class="col-lg-9">
								<input type="text" class="form-control" id="name" autocomplete="off" name="button[name]" value="{$button.name|default:''}" placeholder="name">
								<div class="form-control form-control-plaintext fs-sm text-danger">
									<p>Последовательность символов, используемая в качестве идентификатора. Вы можете использовать цифры от 0 до 9, символы английского алфавита и знак "_".</p>
								</div>
							</div>
						</div>

						<div class="row mb-3">
							<label class="col-lg-3 col-form-label">Значение:</label>
							<div class="col-lg-9"><input type="text" class="form-control" id="value" autocomplete="off" name="button[value]" value="{$button.value|default:''}" placeholder="value"></div>
						</div>
						<div class="row mb-3">
							<label class="col-lg-3 col-form-label">Пользовательский CSS-класс:</label>
							<div class="col-lg-9"><input type="text" class="form-control" id="css" autocomplete="off" name="button[className]" value="{$button.className|default:'form-control'}" placeholder="form-control"></div>
						</div>
						
					</div>
				</div>
			</div>

			<div class="col-md-12 text-center">
                {if isset($button.buttonId)}<input type="hidden" class="form-control" id="id" name="id" value="{$button.buttonId|default:''}">{/if}
                {if isset($formId)}<input type="hidden" class="form-control" id="formId" name="button[formId]" value="{$formId|default:''}">{/if}
                {$smarty.capture.buttons nofilter}
			</div>

		</div>
	</div>
</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}


<script>

    $(document).ready(function () {
        {if isset($messages.saved)} new Noty({ text: 'Новая кнопка "{$button.name|default:''}" сохранена', type: 'success', timeout: 1500 }).show(); {/if}

        {if isset($errors.name)} new Noty({ text: 'Введите название кнопки', type: 'error', timeout: 2500 }).show();{/if}
        {if isset($errors.not_saved)} new Noty({ text: 'Новая кнопка "{$button.name|default:''}" не сохранено', type: 'error', timeout: 2500 }).show(); {/if}

        {if isset($errors.name)} new Noty({ text: 'Введите ключ кнопки на анг. языке', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.nameExists)} new Noty({ text: 'Ключ с этим названием уже сужествует', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.nameCharacters)} new Noty({ text: 'Ключ может содержать только следующие символы: A-Z a-z _', type: 'error', timeout: 2500 }).show(); {/if}
    });


</script>