<form method="post" enctype="multipart/form-data">
	<!-- Page header -->
	{include file="components/group-buttons.tpl" url="{$adminUrl}/form?action=edit{if isset($formId)}&id={$formId}{/if}"}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/forms" class="breadcrumb-item">Тип контента</a>
		<a href="{$adminUrl}/form?action=edit{if isset($formId)}&id={$formId}{/if}" class="breadcrumb-item">{$title|default:''}</a>
	{/capture}

	{capture name="showBy"}{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">

		<div class="row">
			<div class="col-md-12">
				<div class="card border shadow-sm">
					<div class="card-body">
						<div class="row mb-3">
							<label class="col-lg-3 col-form-label">Обязательное поле:</label>
							<div class="col-lg-9">
								<div class="form-check mb-2">
									<input type="checkbox" class="form-check-input" id="required" name="attributes[required]" value="1" {if isset($attributes.required) and  $attributes.required eq 1}checked{/if}>
									<label class="form-check-label" for="required">Required</label>
								</div>
							</div>
						</div>

						<div class="row mb-3">
							<label class="col-lg-3 col-form-label {if isset($errors.name)}text-danger{/if}">Наименование:</label>
							<div class="col-lg-9"><input type="text" class="form-control" id="label" autocomplete="off" name="field[label]" value="{$field.label|default:''}"></div>
						</div>

                        <div class="row mb-3">
                            <label class="col-lg-3 col-form-label {if isset($errors.name) || isset($errors.nameExists) || isset($errors.nameCharacters)}text-danger{/if}">Наименование на анг.:</label>
                            <div class="col-lg-9">
                                <input type="text" class="form-control" id="name" autocomplete="off" name="field[name]" value="{$field.name|default:''}" placeholder="name">
                                <div class="form-control form-control-plaintext fs-sm text-danger">
                                    <p>Последовательность символов, используемая в качестве идентификатора. Вы можете использовать цифры от 0 до 9, символы английского алфавита и знак "_".</p>
                                </div>
                            </div>
                        </div>


{*						<div class="row mb-3 input-hidden collapse  {if isset($field.fieldType) && ($field.fieldType eq 'T')}show{/if}">*}
						<div class="row mb-3 input-hidden collapse  {if isset($field.fieldType) && in_array($field.fieldType, ['T', 'S', 'C'])}show{/if}">
							<label class="col-lg-3 col-form-label">Подсказка:</label>
							<div class="col-lg-9"><input type="text" class="form-control" id="description" name="field[description]" value="{$field.description|default:''}"></div>
						</div>


						<div class="row mb-3">
							<label class="col-lg-3 col-form-label">Значение:</label>
							<div class="col-lg-9"><input type="text" class="form-control" id="value" autocomplete="off" name="field[value]" value="{$field.value|default:''}" placeholder="value"></div>
						</div>

                        {* input-hidden *}
{*						<div class="row mb-3 input-hidden collapse  {if isset($field.fieldType) && ($field.fieldType eq 'T')}show{/if}">*}
						<div class="row mb-3 collapse show">
							<label class="col-lg-3 col-form-label">Пользовательский CSS-класс:</label>
							<div class="col-lg-9"><input type="text" class="form-control" id="css" autocomplete="off" name="field[className]" value="{$field.className|default:'form-control'}" placeholder="form-control"></div>
						</div>
                        {* /input-hidden *}

						<div class="row mb-3">
							<label class="col-lg-3 col-form-label">Тип:</label>
							<div class="col-lg-9 d-flex justify-content-start">
								<div class="field-types me-2">
									{html_options options=$fieldTypes name="field[fieldType]" id="fieldTypes" selected=$field.fieldType|default:'' class="form-control form-control-sm select"  data-width='220'}
								</div>
								<div class="input-types me-2 fade collapse {if isset($field.fieldType) && ($field.fieldType eq 'I')}show{/if}">
									{html_options options=$inputTypes name="field[inputType]" id="inputTypes" selected=$field.inputType|default:'' class="form-control form-control-sm select"  data-width='220'}
								</div>
								<div class="button-types me-2 fade collapse {if isset($field.fieldType) && ($field.fieldType eq 'I')}show{/if}">
									{html_options options=$buttonTypes name="field[buttonType]" id="buttonTypes" selected=$field.buttonType|default:'' class="form-control form-control-sm select"  data-width='220'}
								</div>
							</div>
						</div>

                        {* input-text *}
						<div class="row mb-3 input-text collapse">
							<label class="col-lg-3 mb-2 col-form-label text-lg-end">Макс. длина:</label>
							<div class="col-lg-9 mb-2"><input type="number" class="form-control" id="maxlength" autocomplete="off" name="attributes[maxlength]" value="{$attributes.maxlength|default:''}" style="width: 220px"></div>
							<label class="col-lg-3 mb-2 col-form-label"></label>
							<div class="col-lg-9 mb-2">
								<div class="form-check mb-2">
									<input type="checkbox" class="form-check-input" id="readonly" name="attributes[readonly]" value="1" {if isset($attributes.readonly) and  $attributes.readonly eq 1}checked{/if}>
									<label class="form-check-label" for="readonly">Readonly</label>
								</div>
							</div>
						</div>
                        {* /input-text *}

                        {* input-number *}
						<div class="row mb-3 input-number collapse">
							<label class="col-lg-3 mb-2 col-form-label text-lg-end">Мин:</label>
							<div class="col-lg-9 mb-2"><input type="number" class="form-control" id="min" autocomplete="off" name="attributes[min]" value="{$attributes.min|default:''}" style="width: 220px"></div>

							<label class="col-lg-3 mb-2 col-form-label text-lg-end">Мax:</label>
							<div class="col-lg-9 mb-2"><input type="number" class="form-control" id="max" autocomplete="off" name="attributes[max]" value="{$attributes.max|default:''}" style="width: 220px"></div>
						</div>
                        {* /input-number *}

						<div class="row mb-3 group_position collapse {if isset($field.fieldType) && $field.fieldType eq 'R'}show{/if}">
							<label class="col-lg-3 col-form-label">Расположение элементов:</label>
							<div class="col-lg-9">
								<div class="col-md-6 mb-3">
									{html_options options=$groupPositions name="field[groupPosition]" id="groupPositions" selected=$field.groupPosition|default:'V' class="form-control form-control-sm select"  data-width='300'}
								</div>
							</div>
						</div>

                        {* input-file *}
						<div class="row mb-3 input-file collapse">
							<label class="col-lg-3 mb-2 col-form-label text-lg-end">Accept:</label>
							<div class="col-lg-9 mb-2"><input type="text" class="form-control" id="accept" autocomplete="off" name="attributes[accept]" value="{$attributes.accept|default:''}" placeholder=".pdf,.doc,.docx,.txt" style="width: 220px"></div>
							<label class="col-lg-3 col-form-label">Несколько файлов:</label>
							<div class="col-lg-9">
								<div class="form-check mb-2">
									<input type="checkbox" class="form-check-input" id="multiple" name="attributes[multiple]" value="1" {if isset($attributes.multiple) and  $attributes.multiple eq 1}checked{/if}>
									<label class="form-check-label" for="multiple">Разрешить пользователям загружать несколько файлов</label>
								</div>
							</div>
						</div>
                        {* /input-file *}

                        {* block options *}
						<div class="row mb-3 fade collapse {if isset($field.fieldType) && ($field.fieldType eq 'C' || $field.fieldType eq 'R' || $field.fieldType eq 'S')}show{/if}" id="block_options">
							<label class="col-lg-3 col-form-label">Варианты:</label>
							<div class="col-lg-9">
								<table class="table table-xs table-togglable table-striped table-hover table_options mb-3" id="options">
									<thead>
									<tr>
										<th class="text-center" width="30">#</th>
										<th class="text-start" width="200">Активный</th>
										<th class="text-start">Название/Значение</th>
									</tr>
									</thead>
									<tbody class="sortable_options">
									{assign var=option_row value=0}
									{if !empty($options)}
										{foreach $options as $option}
											<tr id="option_row-{$option_row}">
												<td class="move_list"><i class="ph-dots-six text-muted" data-bs-popup="popover-solid" data-bs-trigger="hover" title="Переместить"></i></td>
												<td>
													<select name="options[{$option_row}][selected]" id="selected_{$option_row}" class="form-control select" data-width="160">
														<option value="0" {if isset($option.selected) && $option.selected eq 0}selected{/if}>НЕТ</option>
														<option value="1" {if isset($option.selected) && $option.selected eq 1}selected{/if}>ДА</option>
													</select>
												</td>
												<td class="variant_name">
													<div class="input-group">
														<input class="form-control" type="text" name="options[{$option_row}][label]" value="{$option.label|default:''}"/>
														<input class="form-control" type="text" name="options[{$option_row}][value]" value="{$option.value|default:''}">
														<button type="button" class="btn btn-light" onclick="removeOptionRow('{$option_row}')"><i class="ph-trash"></i></button>
													</div>
												</td>

											</tr>
											{assign var=option_row value=$option_row+1}
										{/foreach}
									{/if}
									</tbody>
								</table>
								<div class="text-end">
									<button type="button" class="btn btn-outline-primary" onclick="addOption();">Добавить опцию +</button>

								</div>
							</div>
						</div>
                        {* /block options *}
					</div>
				</div>
			</div>

			<div class="col-md-12 text-center">
				{if isset($field.fieldId)}<input type="hidden" class="form-control" id="id" name="id" value="{$field.fieldId|default:''}">{/if}
				{if isset($formId)}<input type="hidden" class="form-control" id="formId" name="field[formId]" value="{$formId|default:''}">{/if}
				{$smarty.capture.buttons nofilter}
			</div>

		</div>
	</div>
</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* script для работы с полями *}
{include file='../feedbacks/script.tpl'}

<script>

	$(document).ready(function () {
		{if isset($messages.saved)} new Noty({ text: 'Новое поле "{$field.name|default:''}" сохранено', type: 'success', timeout: 1500 }).show(); {/if}

		{if isset($errors.name)} new Noty({ text: 'Введите название поля', type: 'error', timeout: 2500 }).show();{/if}
		{if isset($errors.not_saved)} new Noty({ text: 'Новое поле "{$field.name|default:''}" не сохранено', type: 'error', timeout: 2500 }).show(); {/if}

		{if isset($errors.name)} new Noty({ text: 'Введите ключ поля на анг. языке', type: 'error', timeout: 2500 }).show(); {/if}
		{if isset($errors.nameExists)} new Noty({ text: 'Ключ с этим названием уже сужествует', type: 'error', timeout: 2500 }).show(); {/if}
		{if isset($errors.nameCharacters)} new Noty({ text: 'Ключ может содержать только следующие символы: A-Z a-z _', type: 'error', timeout: 2500 }).show(); {/if}
	});

	var option_row = {$option_row};

	dragula(Array.from(document.querySelectorAll('.sortable_options')), {
		direction: 'vertical',
		slideFactorY: 100,
		mirrorContainer: document.querySelector('.sortable_options')
	});

	function addOption() {
		html  = '<tr id="option_row-' + option_row + '">';
		html += '<td class="move_list"><i class="ph-dots-six text-muted" data-bs-popup="popover-solid" data-bs-trigger="hover" title="Переместить"></i></td>';
		html += ' <td>';
		html += '	  <select  name="options[' + option_row + '][selected]" id="selected_' + option_row + '" class="form-control select" data-width="160">';
		html += '	      <option value="0">НЕТ</option>';
		html += '	      <option value="1">ДА</option>';
		html += '	  </select>';
		html += '    </td>';
		html += ' <td class="variant_name">';
		html += '       <div class="input-group">';
		html += '           <input class="form-control" type="text" name="options[' + option_row + '][label]"  placeholder="Название"/>';
		html += '           <input class="form-control" type="text" name="options[' + option_row + '][value]"  placeholder="Значение"/>';
		html += '           <button type="button" class="btn btn-light" onclick="confirm(\'Данное действие необратимо. Вы уверены?\') ? $(\'#option_row-' + option_row + '\').remove() : false;"><i class="ph-trash"></i></button>';
		html += '       </div>';
		html += '    </td>';
		html += ' </tr>';


		$('.table_options tbody').append(html);

		$('.select').select2({
			minimumResultsForSearch: Infinity,
			placeholder: 'Выберите...'
		});

		option_row++;
	}

	/**
	 * Удаление строки с подтверждением.
	 * @param  rowId - ID строки для удаления.
	 */
	function removeOptionRow(rowId) {
		if (confirm('Данное действие необратимо. Вы уверены?')) {
			document.getElementById('option_row-' + rowId).remove();
		}
	}


</script>