<form method="post" enctype="multipart/form-data">
	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/forms"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/forms" class="breadcrumb-item">{$title}</a>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">

		<div class="row">
			<div class="col-md-8">
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:general}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div class="row">
								<div class="col-md-12">
									{* field status *}
									{include file="components/fields/select.tpl" col="col-md-12" id="status" title="{general:status}" field="form[status]" array=$statuses selected=$form.status|default:'V' class="form-group mb-3"}
									{* /field status *}
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label {if isset($errors.name)}text-danger{/if}">{general:title}</label>
										<input type="text" class="form-control" id="name" autocomplete="off" name="form[name]" value="{$form.name|default:''}">
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameProhibited) || isset($errors.fileNameCharacters)}text-danger{/if}">ID формы (только буквы)</label>
										<input type="text" class="form-control" id="fileName" name="form[fileName]" value="{$form.fileName|default:''}">
									</div>
								</div>

								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label">Method</label>
										{html_options options=$methods name="form[method]" id="method" selected=$form.method|default:'' class="form-control form-control-sm select"}
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label">Endpoint</label>
										<input type="text" class="form-control" id="endpoint" name="form[endpoint]" value="{$form.endpoint|default:''}">
									</div>
								</div>

								<div class="col-md-6">
									<div class="form-group mb-2">
										<div class="form-check form-check-inline">
											<input type="checkbox" class="form-check-input" id="enableCsrfToken" name="form[enableCsrfToken]" value="1" {if isset($form.enableCsrfToken) and $form.enableCsrfToken eq 1}checked{/if}>
											<label class="form-check-label" for="enableCsrfToken">Включить CSRF-защиту</label>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

				{* текст summary/content *}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:description}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-{if !empty($form.content)}down{else}up{/if}"></i></a>
						</div>
					</div>
					<div class="collapse {if !empty($form.content)}show{/if}">
						<textarea id="description" name="form[content]" class="description">{$form.content|default:''}</textarea>
					</div>
				</div>
				{* /текст описание *}
			</div>

			<div class="col-md-4">

				{* image preview *}
				{include file="cards/card-image.tpl"
				image="{if isset($form.image)}{$form.image.original}{/if}"
				id="{if isset($form.image)}{$form.image.imageId}{/if}"
				module='form'}
				{* /image preview *}

			</div>


			<div class="col-md-12">
				{* поля *}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">Поля / Кнопки</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body flex-column flex-md-row m-0  p-0">
							<table class="table table-xs table-togglable table-striped table-hover" id="fields">
								<thead>
								<tr>
									<th class="text-center" width="30">#</th>
									<th>Название</th>
									<th>Варианты</th>
									<th>Значение</th>
									<th>Тип</th>
									<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
								</tr>
								</thead>
								{if !empty($fields)}
									<tbody class="sortable">
									{foreach from=$fields item=field}
										<tr id="field-{$field.fieldId}" data-id="{$field.fieldId}" {if $field.status eq 'H'}class="table-warning"{/if}>
											<td class="text-center text-nowrap"><i class="ph-dots-six text-muted"></i></td>
											<td class="text-start"> {$field.label nofilter} {if isset($field.attributes.required) && $field.attributes.required eq 1}<span class="text-danger">*</span>{/if}</td>
											<td class="text-start"> {$field.options nofilter}</td>
											<td class="text-start"> {$field.name nofilter}</td>
											<td class="text-start"> {$field.fieldTypeName nofilter} {if $field.inputType}({$field.inputType}){/if} {if $field.buttonType}({$field.buttonType}){/if}</td>
											<td class="text-center">
												<div class="d-inline-flex">
													<a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="top" href="{$adminUrl}/formfields?action=edit{if isset($form.formId)}&formId={$form.formId}{/if}&id={$field.fieldId}"><i class="ph-note-pencil me-2"></i></a>

													<div class="list-icons-item dropdown">
														<a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>

														<div class="dropdown-menu dropdown-menu-right">
															<a class="dropdown-item" href="{$adminUrl}/formfields?action=edit{if isset($form.formd)}&formId={$form.formId}{/if}&id={$field.fieldId}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
															<button class="dropdown-item ajax_action" data-module="formfields" data-action="status" data-id="{$field.fieldId}" type="button"><i class="{if $field.status eq 'V'}ph-eye{else}ph-eye-slash{/if} me-2"></i> {general:status}</button>
															<div class="dropdown-divider"></div>
															<button type="button" class="dropdown-item text-danger" onclick="removeField({$field.fieldId}, '{$field.name}');"><i class="ph-trash me-2"></i> {general:delete}</button>
														</div>
													</div>
												</div>
											</td>
										</tr>
									{/foreach}

									</tbody>
								{else}
									<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
								{/if}
							</table>
						</div>
						<div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">
							<a class="btn btn-sm btn-primary" href="{$adminUrl}/formfields?action=add{if isset($form.formId)}&formId={$form.formId}{/if}"><i class="ph-plus me-2"></i>{general:add}</a>
						</div>
					</div>
				</div>
				{* /поля *}

			</div>

{*			<div class="col-md-2">*}
{*				<div class="card border shadow-sm">*}
{*					<div class="card-body p-0">*}
{*						<table class="table" id="buttons">*}
{*							<tbody>*}
{*							<tr><td class="text-start"><button type="button" class="btn btn-sm btn-light" data-bs-toggle="modal" data-bs-target="#modal_xlarge">Строковое поле</button></td></tr>*}
{*							<tr><td class="text-start"><button type="button" class="btn btn-sm btn-light" data-bs-toggle="modal" data-bs-target="#modal_xlarge">Числовое поле</button></td></tr>*}
{*							<tr><td class="text-start"><button type="button" class="btn btn-sm btn-light" data-bs-toggle="modal" data-bs-target="#modal_xlarge">Скрытое поле</button></td></tr>*}
{*							<tr><td class="text-start"><button type="button" class="btn btn-sm btn-light" data-bs-toggle="modal" data-bs-target="#modal_xlarge">Радио-кнопки</button></td></tr>*}
{*							<tr><td class="text-start"><button type="button" class="btn btn-sm btn-light" data-bs-toggle="modal" data-bs-target="#modal_xlarge">Выбор</button></td></tr>*}
{*							<tr><td class="text-start"><button type="button" class="btn btn-sm btn-light" data-bs-toggle="modal" data-bs-target="#modal_xlarge">Загрузка файла</button></td></tr>*}

{*							</tbody>*}

{*						</table>*}
{*					</div>*}
{*				</div>*}
{*			</div>*}

			<div class="col-md-12 text-center">
                {if isset($form.formId)}<input type="hidden" class="form-control" id="id" name="id" value="{$form.formId|default:''}">{/if}
                {$smarty.capture.buttons nofilter}
			</div>

		</div>
	</div>
</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}


{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<div id="modal_xlarge" class="modal fade" tabindex="-1">
	<div class="modal-dialog modal-xl">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title">Large modal</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
			</div>

			<div class="modal-body">
				<h6 class="fw-semibold">Text in a modal</h6>
				<p>Duis mollis, est non commodo luctus, nisi erat porttitor ligula, eget lacinia odio sem. Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor.</p>

				<hr>

				<h6 class="fw-semibold">Another paragraph</h6>
				<p>Cras mattis consectetur purus sit amet fermentum. Cras justo odio, dapibus ac facilisis in, egestas eget quam. Morbi leo risus, porta ac consectetur ac, vestibulum at eros.</p>
				<p>Praesent commodo cursus magna, vel scelerisque nisl consectetur et. Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor.</p>
			</div>

			<div class="modal-footer">
				<button type="button" class="btn btn-link" data-bs-dismiss="modal">Close</button>
				<button type="button" class="btn btn-primary">Save changes</button>
			</div>
		</div>
	</div>
</div>

<script>

    $(document).ready(function () {
        {if isset($messages.saved)} new Noty({ text: 'Форма "{if isset($form.name)}{$form.name}{/if}" сохранена', type: 'success', timeout: 1500 }).show(); {/if}

        {if isset($errors.name)} new Noty({ text: 'Введите название формы', type: 'error', timeout: 2500 }).show();{/if}
        {if isset($errors.not_saved)} new Noty({ text: 'Форма "{$form.name|default:''}" не сохранен', type: 'error', timeout: 2500 }).show(); {/if}

        {if isset($errors.fileName)} new Noty({ text: 'Введите название свойства на анг. языке', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.fileNameExists)} new Noty({ text: 'Введите название свойства на анг. языке', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.fileNameProhibited)} new Noty({ text: 'Такое название нельзя использовать', type: 'error', timeout: 2500 }).show(); {/if}
        {if isset($errors.fileNameCharacters)} new Noty({ text: 'Имя файла может содержать только буквы', type: 'error', timeout: 2500 }).show(); {/if}

    });

    $(document).on('click', '.sortable_save_button', function () {
        var ids = [];
        $('.sortable tr').each(function () {
            console.log($(this).attr('data-id'))

            ids.push($(this).attr('data-id'));
        })
        $.post( "{$adminUrl}/formfields?action=reorder", { ids : ids }, function( data ) {
            $('.sortable_footer_navbar').removeClass('show');
            new Noty({ text: 'Поле перемещено', type: 'success', timeout: 1500 }).show();
        });
    })
    $(document).on('click', '.sortable_cancel_button', function () {
        $('.sortable_footer_navbar').removeClass('show');
        location.reload();
    })

    // рабочее удаление id, заголовок, ссылка
    function removeField(id, title) {
        bootbox.confirm({
            closeButton: false,
            message: lang['sureToDelete'] + ' "'+title+'"?',
            callback: function(result) {
                if (result === true) {
                    $.post('index.php?mod=formfields&action=remove&id='+id, function (response) {
                        console.log(response);
                        if (response.status == 200) {
                            removeElement(id, 'field');
                        }
                        new Noty({ text: response.message, layout: 'topRight', type: response.type, timeout: 1500 }).show();

                    }, 'json');
                }
            }
        });
        return false;
    }


</script>




