<form method="post" id="geo">

	<!-- Page header -->
	{include file="components/group-buttons.tpl" url="{$generate_url}?page={if !empty($page)}{$page}{/if}{$buildQueryString}"}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/countries" class="breadcrumb-item">{$title} {$buildQueryString}</a>
		<span class="breadcrumb-item active">{general:add}</span>
	{/capture}

	{capture name="showBy"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<!-- Content area -->
	<div class="content">
		<div class="row">
			<div class="col-md-8">
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:general}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div class="row">
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label {if isset($errors.name)}text-danger{/if}">{general:title}</label>
										<input type="text" class="form-control" autocomplete="off" id="name" name="country[name]" value="{$country.name|default:""}">
									</div>
								</div>

								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label">Столица</label>
										<input type="text" class="form-control" autocomplete="off" id="capital" name="country[capital]" value="{$country.capital|default:""}">
									</div>
								</div>

								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label">Валюта</label>
										<input type="text" class="form-control" autocomplete="off" id="currency" name="country[currency]" value="{$country.currency|default:""}">
									</div>
								</div>

								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label">TLD <span class="ph-question text-primary" data-bs-popup="tooltip" title="**TLD** (домен верхнего уровня) — это последний сегмент доменного имени, расположенный после конечной точки (`.`). Он является частью системы доменных имен (DNS) и помогает классифицировать доменные имена по разным группам" data-bs-placement="auto"></span></label>
										<input type="text" class="form-control" autocomplete="off" id="tld" name="country[tld]" value="{$country.tld|default:""}">
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label">ISO 2 <span class="ph-question text-primary" data-bs-popup="tooltip" title="ISO 2 (Альфа-2): Двухбуквенный код. Он широко используется в международных почтовых службах и доменных именах (например, .us, .ca)." data-bs-placement="auto"></span></label>
										<input type="text" class="form-control" id="fileName" name="country[iso2]" value="{$country.iso2|default:""}">
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label">ISO 3 <span class="ph-question text-primary" data-bs-popup="tooltip" title="ISO 3 (Альфа-3): Трехбуквенный код. Это обеспечивает более четкое распознавание названия страны и часто используется в базах данных и приложениях, где важна ясность." data-bs-placement="auto"></span></label>
										<input type="text" class="form-control" id="fileName" name="country[iso3]" value="{$country.iso3|default:""}">
									</div>
								</div>

								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label">Код страны</label>
										<input type="text" class="form-control" id="fileName" name="country[numericCode]" value="{$country.numericCode|default:""}">
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label">Телефонный код</label>
										<input type="text" class="form-control" id="fileName" name="country[phoneCode]" value="{$country.phoneCode|default:""}">
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label is-visible">Широта</label>
										<input type="text" class="form-control" autocomplete="off" id="alias" name="country[latitude]" value="{$country.latitude|default:""}">
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label is-visible">Долгота</label>
										<input type="text" class="form-control" autocomplete="off" id="alias" name="country[longitude]" value="{$country.longitude|default:""}">
									</div>
								</div>


							</div>
						</div>
					</div>
				</div>
			</div>

			<div class="col-md-4">
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:statusAndVisibility}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							{* field status *}
							{include file="components/fields/select.tpl" id="status" title="{general:status}" field="country[status]" array=$statuses selected=$country.status|default:'visible'  class="form-group mb-3"}
							{* /field status *}
						</div>
					</div>
				</div>

				{assign var=translation_row value=0}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">Переводы</h6>
						<div class="d-inline-flex ms-auto">
							<button type="button" class="btn btn-sm btn-outline-primary" onclick="addTranslation();"><i class="ph-plus me-2"></i>{general:add} перевод</button>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body card-translations">
							{foreach from=$country.translations item=translation key=key}
								<div class="input-group mb-3" id="translation-{$translation_row}">
									<span class="input-group-text">{$key|upper}</span>
									<input type="hidden" class="form-control"  name="translations[{$translation_row}][key]" value="{$key}" >
									<input type="text" class="form-control"  name="translations[{$translation_row}][name]" value="{$translation}" >
									<button type="button" class="btn btn-danger" onclick="confirm('Данное действие необратимо. Вы уверены?') ? $('#translation-{$translation_row}').remove() : false;"><i class="ph-trash"></i></button>
								</div>
								{assign var=translation_row value=$translation_row+1}
							{/foreach}
						</div>
					</div>
				</div>
			</div>

			<div class="col-md-12 main main_buttons text-center">
				{if isset($country.id)}<input type="hidden" class="form-control" id="id" name="id" value="{$country.id|default:''}">{/if}
				{$smarty.capture.buttons nofilter}
			</div>

		</div>
	</div>

</form>

<script>
	$(document).ready(function() {
		{if isset($errors.name)} new Noty({ text: 'Введите название страны', type: 'error'}).show(); {/if}
		{if isset($errors.fileName)}new Noty({ text: 'Введите код страны', type: 'error'}).show(); {/if}
		{if isset($errors.not_saved)} new Noty({ text: 'Страна НЕ сохранена', type: 'error' }).show(); {/if}
		{if isset($messages.saved)} new Noty({ text: 'Страна сохранена', type: 'success' }).show(); {/if}
	});

	var translation_row = {$translation_row};

	function addTranslation() {
		let  rowHtml  = '<div class="input-group mb-3" id="translation-' + translation_row + '">';
		rowHtml += '<input type="text" class="form-control"  name="translations[' + translation_row + '][key]">';
		rowHtml += '<input type="text" class="form-control"  name="translations[' + translation_row + '][name]">';
		rowHtml += '<button type="button" class="btn btn-danger" onclick="confirm(\'Данное действие необратимо. Вы уверены?\') ? $(\'#translation-' + translation_row + '\').remove() : false;"><i class="ph-trash"></i></button>';
		rowHtml += '</div>';
		rowHtml += '</tr>';

		$('.card-translations').append(rowHtml);

		translation_row++;
	}

</script>