<form method="post" id="geo">

	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/districts"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/districts" class="breadcrumb-item">{$title}</a>
	    <span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}
    {/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

    <!-- Content area -->
    <div class="content">
        <div class="row"> 
            <div class="col-md-8">
    		    <div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{general:card:general}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
	                    <div class="card-body">
	                        <div class="row">
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label is-visible {if isset($errors.cityId)}text-danger{/if}">Город</label>
										{html_options options=$countries name="district[cityId]" id="cityId" selected=$district.cityId|default:'' class="form-control select"}
									</div>
								</div>
	                            <div class="col-md-6">
	                                <div class="form-group mb-3">
	                                    <label class="form-label is-visible {if isset($errors.name)}text-danger{/if}">{general:title}</label>
	                                    <input type="text" class="form-control" autocomplete="off" id="name" name="district[name]" value="{$district.name|default:""}">
	                                </div>
	                            </div>
{*		                        <div class="col-md-6">*}
{*			                        <div class="form-group mb-3">*}
{*				                        <label class="form-label is-visible {if isset($errors.fileName)}text-danger{/if}">На латинице</label>*}
{*				                        <input type="text" class="form-control" id="fileName" name="district[fileName]" value="{$district.fileName|default:""}">*}
{*			                        </div>*}
{*		                        </div>*}
					            <div class="col-md-6">
						            <div class="form-group mb-3">
							            <label class="form-label is-visible">Сумма доставки</label>
							            <input type="text" class="form-control" autocomplete="off" id="alias" name="district[price]" value="{$district.price|default:""}">
						            </div>
					            </div>
		                        <div class="col-md-6">
						            <div class="form-group mb-3">
							            <label class="form-label is-visible">Координаты</label>
							            <input type="text" class="form-control" autocomplete="off" id="alias" name="district[coordinates]" value="{$district.coordinates|default:""}">
						            </div>
					            </div>
	                        </div>
	                    </div>
			        </div>
    		    </div>
            </div>
    
            <div class="col-md-4">
        		<div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{general:card:statusAndVisibility}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
	                    <div class="card-body">
                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="district[status]" array=$statuses selected=$district.status|default:'visible'  class="form-group mb-3"}
                            {* /field status *}
	                    </div>
			        </div>
    				
    			</div>
            </div>

	        <div class="col-md-12 main main_buttons text-center">
                {if isset($district.id)}<input type="hidden" class="form-control" id="id" name="id" value="{$district.id|default:''}">{/if}
                {$smarty.capture.buttons nofilter}
	        </div>

        </div>
    </div>

</form>

<script>
    $(document).ready(function() {
        {if isset($errors.name)} new Noty({ text: 'Введите название района', type: 'error'}).show(); {/if}
        {if isset($errors.cityId)}new Noty({ text: 'Выберите город', type: 'error'}).show(); {/if}
        {if isset($errors.not_saved)} new Noty({ text: 'Район НЕ сохранена', type: 'error' }).show(); {/if}
        {if isset($messages.saved)} new Noty({ text: 'Район сохранена', type: 'success' }).show(); {/if}
    });

</script>