
<!-- Page header -->
{capture name="buttons"}
	<a class="btn btn-sm btn-icon btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/region?action=add?action=edit{if isset($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-plus"></i></a>
{/capture}

{capture name="breadcrumb"}
	<a href="{$adminUrl}/regions" class="breadcrumb-item">{$title}</a>
{/capture}

{capture name="showBy"}
    {include file="module/show-by.tpl" url="{$adminUrl}/regions"}
{/capture}

{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
<!-- /page header -->


<div class="content">
	<div class="row">
		<div class="col-md-12">
			<div class="card border shadow-sm">
				<div class="">
					<table class="table table-xs table-togglable table-striped table-hover" id="regions">
						<thead>
						<tr>
							<th class="text-center" width="30">#</th>
							<th data-hide="ID" class="text-center" width="30">{general:table:id}</th>
							<th data-toggle="true">Название</th>
							<th data-hide="phone" class="text-center">{general:status}</th>
							<th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
						</tr>
						</thead>
                        {if !empty($regions)}
							<tbody class="sortable">
                            {foreach item=region from=$regions name=regions}
								<tr id="region-{$region.id}" data-id="{$region.id}" class="{if $region.status eq 'H'}table-warning{/if}">
									<td class="text-center text-nowrap"><i class="ph-dots-six text-muted" data-bs-popup="tooltip" title="Переместить" data-bs-placement="auto"></i></td>
									<td class="text-start text-nowrap">{$region.id}</td>
									<td class="text-start" width="100%"> {$region.name nofilter}</td>
									<td class="text-center" id="status-{$region.id}" >{$region.statusName nofilter}</td>
									<td class="text-center">
										<div class="d-inline-flex">
											<a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="auto" href="{$adminUrl}/region?action=edit&id={$region.id}{if isset($page)}&page={$page}{/if}"><i class="ph-note-pencil me-2"></i></a>
											<div class="dropdown">
												<a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>

												<div class="dropdown-menu dropdown-menu-right">
													<a class="dropdown-item" href="{$adminUrl}/region?action=edit&id={$region.id}{if isset($page)}&page={$page}{/if}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>

													{include file="components/actions/dropdown-status.tpl" module="regions" id=$region.id status=$region.status scope=parent}
													{include file="components/actions/dropdown-delete.tpl" id=$region.id title="{$region.name|escape|default:''}" module="regions" scope=parent}
												</div>
											</div>
										</div>
									</td>
								</tr>
                            {/foreach}

							</tbody>
                        {else}
							<tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
                        {/if}
					</table>
				</div>

                {include file="module/pagination.tpl" url="{$adminUrl}/regions" params="{$buildQueryString}"}

			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
        {if isset($errors.not_saved)} new Noty({ text: 'Страна НЕ сохранена', type: 'error', timeout: 1500 }).show(); {/if}
        {if isset($messages.saved)} new Noty({ text: 'Страна сохранена', type: 'success', timeout: 1500 }).show(); {/if}
    });


	$(document).on('click', '.sortable_save_button', function () {
		let ids = [];
		$('.sortable tr').each(function () {
			ids.push($(this).attr('data-id'));
		})
		$.post( "{$adminUrl}/regions?action=reorder", { ids : ids }, function( data ) {
			$('.sortable_footer_navbar').removeClass('show');
			// location.reload();
		});
	})
	$(document).on('click', '.sortable_cancel_button', function () {
		$('.sortable_footer_navbar').removeClass('show');
		location.reload();
	})

</script>




