
	<!-- Page header -->
	{capture name="buttons"}
		<a class="btn btn-sm btn-icon btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/lang?action=add"><i class="ph-plus"></i></a>
	{/capture}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/langs" class="breadcrumb-item">{$title}</a>
	{/capture}

	{capture name="showBy"}
	    {if $LANGUAGES|@count > 1 AND empty($SITE_LANG)}
			<button class="btn btn-sm btn-primary" type="button" data-bs-toggle="collapse" data-bs-target="#changeLangRow">
				<i class="ph-arrows-out-line-vertical me-2"></i> {languages:changeDefaultLang}
			</button>
	    {/if}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	{if isset($action) && $action == 'confirmDelete'}
	    {* подтверждение на удаление языка *}
		<div class="content">
		    <div class="row">
		        <div class="col-md-12">
		            <div class="card border shadow-sm">
		                <div class="card-body">
		                     <form action="{$adminUrl}/langs" method="post" id="language">
			                     <div class="alert bg-danger text-white alert-dismissible mb-3">
				                     <span class="font-weight-semibold">{languages:delete}<br>{if !$language.isDefault} {languages:deleteDesc} {/if}</span>
			                     </div>
			                     <div class="form-check mb-2">
				                     <input type="checkbox" class="form-check-input" id="confirmDelete" onclick="document.getElementById('submitBtn').disabled = !this.checked;">
				                     <label class="form-check-label" for="confirmDelete">{languages:confirmDelete}: <b>{$language.languageName}</b></label>
			                     </div>

		                        <div class="text-center mt-3">
		                            <input type="hidden" name="id" value="{$language.languageId}" />
		                            <input type="hidden" name="action" value="remove" />
		                            <button class="btn btn-sm btn-primary me-2" type="button" id="submitBtn" disabled="disabled" onclick="this.form.submit()" ><i class="ph-trash me-2"></i>{general:delete}</button>
		                            <a class="btn btn-sm btn-light" type="button" href="{$adminUrl}/langs">{general:cancel}</a>
		                        </div>
		                    </form>
		                </div>
		            </div>

		        </div>
		    </div>
		</div>
	    {* /подтверждение на удаление языка *}

	{else}

		<div class="content">
		    <div class="row">
		        <div class="col-md-12">
				    {* Изменить основной язык *}
		            <div id="changeLangRow" class="collapse">
				        <div class="card border shadow-sm bg-light p-2 d-sm-flex align-items-sm-center">
					        <div class="mb-0"></div>
					        <div class="ms-sm-auto">
						        <ul class="list-inline list-inline-condensed mb-0">
							        <li class="list-inline-item text-muted"><i class="ph-arrows-out-line-vertical"></i> {languages:changeDefaultLang}</li>
							        <li class="list-inline-item">
								        <form action="{$adminUrl}/langs" method="post" id="searchForm" onclick="confirmLanguageChange(this)">
									        <div class="input-group">
										        {html_options options=$defaultLanguageOptions id=defaultLang name="id" class="form-control select" data-width="300"}
										        <button class="btn btn-sm btn-primary" type="submit" name="action" value="changeDefaultLanguage">{languages:setAsDefault}</button>
									        </div>
								        </form>
							        </li>
						        </ul>
					        </div>
				        </div>
		            </div>
		            {* /Изменить основной язык *}

		            <div class="card border shadow-sm">
			            <div class="">
			                <table class="table table-togglable table-striped table-hover" id="languages">
			                    <thead>
			                        <tr>
			                            <th data-hide="phone" class="text-center" width="30">#</th>
			                            <th data-hide="phone" class="text-center" nowrap="nowrap">{languages:codename}</th>
			                            <th data-hide="phone" >{languages:flag}</th>
			                            <th data-toggle="true">{languages:language}</th>
			                            <th class="text-center text-muted" width="50"><i class="ph-check"></i></th>
			                        </tr>
			                    </thead>
			                    {if isset($languages)}
			                    <tbody class="sortable">
			                        {foreach item=language from=$languages name=languages}
			                        <tr id="language-{$language.languageId}" data-id="{$language.languageId}" class="{if $language.status eq 'H'}table-warning{/if}">
				                        <td class="text-center text-nowrap"><i class="ph-dots-six text-muted"></i></td>
			                            <td class="text-center text-nowrap"><a href="{$language.url}" target="_blank">{$language.codename}</a></td>
			                            <td class="text-center text-nowrap"><img src="{$GLOBAL_URL}/admin/assets/lang/{$language.codename}.svg" style="width: 30px;"></td>
			                            <td width="100%">{$language.languageTransName|default:$navLang->languageName}{if $language.isDefault} (<b>{languages:default}</b>){/if}</td>

			                            <td class="text-end">
			                                <div class="d-inline-flex">
				                                <div class="text-body">
	                                                {if !$language.isDefault}
						                                <div class="form-check form-switch mb-2">
							                                <input type="checkbox" class="form-check-input ajax_action" data-module="langs" data-action="status" data-id="{$language.languageId}" {if $language.status eq 'V'}checked{/if}>
						                                </div>
	                                                {/if}
				                                </div>
			                                    <div class="list-icons-item dropdown">
				                                    <a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>

			                                        <div class="dropdown-menu dropdown-menu-right">
			                                            <a class="dropdown-item" href="{$adminUrl}/lang?action=edit&id={$language.languageId}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
			                                            {if !$language.isDefault}
			                                                <div class="dropdown-divider"></div>
			                                                <a class="dropdown-item text-danger" href="{$adminUrl}/langs?action=confirmDelete&id={$language.languageId}" ><i class="ph-trash me-2"></i> {general:delete}</a>
			                                            {/if}
			                                        </div>
			                                    </div>
			                                </div>
			                            </td>
			                        </tr>
			                        {/foreach}

			                    </tbody>

			                    {else}
			                    <tbody><tr class="odd"><td class="text-center" colspan="8">- {general:none} -</td></tr></tbody>
			                    {/if}
			                </table>
			            </div>
		            </div>
		        </div>
		    </div>
		</div>
	{/if}

	 <script>
	    $(document).ready(function () {
	        {if isset($errors.language_not_found)} new Noty({ text: '{languages:errors:1}', type: 'error', timeout: 1500 }).show(); {/if}
	        {if isset($errors.serializations)} new Noty({ text: '{languages:errors:6}', type: 'error', timeout: 1500 }).show(); {/if}

	        {if isset($messages.saved)} new Noty({ text: '{languages:messages:0}', type: 'success', timeout: 1500 }).show(); {/if}
	        {if isset($messages.deleted)} new Noty({ text: '{languages:messages:1}', type: 'success', timeout: 1500 }).show(); {/if}
	    });

        $(document).on('click', '.sortable_save_button', function () {
            var ids = new Array();
            $('.sortable tr').each(function () {
                console.log($(this).attr('data-id'))

                ids.push($(this).attr('data-id'));
            })
            $.post( "{$adminUrl}/langs?action=reorder", { ids : ids }, function( data ) {
                $('.sortable_footer_navbar').removeClass('show');
                // location.reload();
            });
        })
        $(document).on('click', '.sortable_cancel_button', function () {
            $('.sortable_footer_navbar').removeClass('show');
            location.reload();
        })

	</script>






