<form class="form-validation" method="post" enctype="multipart/form-data" novalidate>
	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/managers"}

    {capture name="breadcrumb"}
	    <a href="{$adminUrl}/managers" class="breadcrumb-item">{$title}</a>
        {if isset($action) && $action == 'edit'}
		    <span class="breadcrumb-item active">{managers:editing}</span>
        {else}
		    <span class="breadcrumb-item active">{managers:adding}</span>
        {/if}
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

    <!-- Content area -->
    <div class="content">
        <div class="row">
	        <div class="col-md-8">
		        <div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{general:tabs:general}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
						<div class="collapse show">
							<div class="card-body">
								<div class="row mb-3">
									<label class="col-lg-3 col-form-label">{users:general:gender}</label>
									<div class="col-lg-9">
										<div class="form-check-horizontal">
											{foreach from=$genders item=gender key=key name=genderItems}
												<label class="form-check form-check-inline">
													<input type="radio" class="form-check-input" name="user[gender]" value="{$key}" {if $smarty.foreach.genderItems.first || $key eq $user.gender|default:''}checked{/if}>
													<span class="form-check-label">{$gender}</span>
												</label>
											{/foreach}
										</div>
									</div>
								</div>

								<div class="row mb-3">
									<label class="col-lg-3 col-form-label {if isset($errors.fullName)}text-danger{/if}" for="fullName">{managers:fullname}: <span class="text-danger">*</span></label>
									<div class="col-lg-9"><input type="text" class="form-control" autocomplete="off" id="fullName" name="user[fullName]" value="{$user.fullName|default:''}" /></div>
								</div>
								<div class="row mb-3">
									<label class="col-lg-3 col-form-label {if isset($errors.login_empty) || isset($errors.login_exists) || isset($errors.loginName)}text-danger{/if}" for="loginName">{managers:loginname}: <span class="text-danger">*</span></label>
									<div class="col-lg-9"><input type="text" class="form-control" autocomplete="off" id="loginName" name="user[loginName]" value="{$user.loginName|default:''}" /></div>
								</div>
								<div class="row mb-3">
									<label class="col-lg-3 col-form-label {if isset($errors.email)}text-danger{/if}" for="email">{general:email}:</label>
									<div class="col-lg-9"><input type="email" class="form-control" autocomplete="off" id="email" name="user[email]" value="{$user.email|default:''}"/></div>
								</div>
								<div class="row mb-3">
									<label class="col-lg-3 col-form-label" for="phone">{managers:phone}:</label>
									<div class="col-lg-9"><input type="tel" class="form-control" autocomplete="off" id="phone" data-mask="{$config.phone_mask}" name="user[phone]" value="{$user.phone|default:''}" /></div>
								</div>
								<div class="row mb-3">
									<label class="col-lg-3 col-form-label" for="address">{managers:address}:</label>
									<div class="col-lg-9"><input type="text" class="form-control maxlength-threshold" maxlength="100" autocomplete="off" id="address" name="user[address]" value="{$user.address|default:''}"/></div>
								</div>

								<div class="row mb-3">
									{if !empty($user.userId)}
										<label class="col-lg-3 col-form-label {if isset($errors.password)}text-danger{/if}">{managers:newPassword}:</label>
										<div class="col-lg-9">
											<div class="input-group">
												<input  type="text" class="form-control group-indicator" id="newPassword" name="user[newPassword]" />
												<span class="input-group-text password-indicator-group">No password</span>
												<button type="button" class="btn btn-info generate-group">Сгенерировать пароль</button>
											</div>
										</div>
									{else}
										<label class="col-lg-3 col-form-label {if isset($errors.password)}text-danger{/if}">{managers:password}: <span class="text-danger">*</span></label>
										<div class="col-lg-9">
											<div class="input-group">
												<input type="text" class="form-control group-indicator" id="password" name="user[password]"/>
												<span class="input-group-text  password-indicator-group">No password</span>
												<button type="button" class="btn btn-info generate-group">Сгенерировать пароль</button>
											</div>
										</div>
									{/if}
								</div>

								<div class="row mb-3">
									<label class="col-lg-3 col-form-label {if isset($errors.no_more_admins) OR isset($errors.no_more_developers) OR isset($errors.access_level_empty)}text-danger{/if}">Группа: <span class="text-danger">*</span></label>
									<div class="col-lg-9">{html_options options=$groups selected=$user.groupId|default:'' id="groupId" name="user[groupId]" class="form-control select"}</div>
								</div>

								<div class="row mb-3">
									<label class="col-lg-3 col-form-label {if isset($errors.status_empty)}text-danger{/if}">{general:status}: <span class="text-danger">*</span></label>
									<div class="col-lg-9">{html_options options=$statuses selected=$user.status|default:'V' id="status" name="user[status]" class="form-control select"}</div>
								</div>

								<div class="row mb-3">
									<label class="col-lg-3 col-form-label">Получать писема:</label>
									<div class="col-lg-9">
										<div class="form-check-horizontal">
											{foreach from=$choices item=choice key=choiceId name=choiceItems}
												<label class="form-check form-check-inline">
													<input type="radio" class="form-check-input form-check-input-{if $smarty.foreach.choiceItems.first}success{else}danger{/if}" name="user[receiveEmails]" value="{$choiceId}" {if $choiceId eq $user.receiveEmails|default:0}checked{/if}>
													<span class="form-check-label">{$choice}</span>
												</label>
											{/foreach}
										</div>

									</div>
								</div>
							</div>

							<div class="card-footer hstack gap-3 justify-content-between">
								<div class="text-muted">
									<ul class="list list-unstyled mb-0 fs-sm">
										<li>{managers:registration}</li>
										<li>{managers:activity}</li>
									</ul>
								</div>
								<div class="hstack gap-1">
									<ul class="list list-unstyled mb-0 fs-sm">
										<li>{if isset($user.addedOn)}{$user.addedOn|date_format:"%d.%m.%Y %H:%M"}{/if}</li>
										<li>{if isset($user.lastLogin)}{$user.lastLogin|date_format:"%d.%m.%Y %H:%M"}{/if}</li>
									</ul>
								</div>
							</div>

						</div>
			        </div>
		        </div>
	        </div>

	        <div class="col-md-4">

				{* image preview *}
				{include file="cards/card-image.tpl"
				image="{if isset($user.image)}{$user.image.original}{/if}"
				id="{if isset($user.image)}{$user.image.imageId}{/if}"
				module='manager' type="admin" path="admin"}
				{* /image preview *}

	        </div>

            {* права доступа *}
	        <div class="col-md-12 text-center">
                {if isset($user.userId)}<input type="hidden" class="form-control" id="id" name="id" value="{$user.userId}">{/if}
		        {$smarty.capture.buttons nofilter}
	        </div>

        </div>

    </div>

</form>

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>
$(document).ready(function () {

    {if isset($errors.login_empty)}     new Noty({ text: '{managers:errors:13}', type: 'error' }).show(); {/if}
    {if isset($errors.login_exists)}    new Noty({ text: '{managers:errors:0}', type: 'error' }).show(); {/if}
    {if isset($errors.user_not_found)}  new Noty({ text: '{managers:errors:1}', type: 'error' }).show();  {/if}
    {if isset($errors.loginName)}       new Noty({ text: '{managers:errors:2}', type: 'error' }).show(); {/if}
    {if isset($errors.fullName)}        new Noty({ text: '{managers:errors:3}', type: 'error' }).show(); {/if}
    {if isset($errors.password)}        new Noty({ text: '{managers:errors:4}', type: 'error' }).show(); {/if}
    {if isset($errors.not_saved)}       new Noty({ text: '{managers:errors:5}', type: 'error' }).show(); {/if}
    {if isset($errors.no_more_admins)}  new Noty({ text: '{managers:errors:6}', type: 'error' }).show(); {/if}

    {if isset($errors.developer_status)}    new Noty({ text: '{managers:errors:9}', type: 'error' }).show(); {/if}
    {if isset($errors.no_more_developers)}  new Noty({ text: '{managers:errors:10}', type: 'error' }).show(); {/if}
    {if isset($errors.access_level_empty)}  new Noty({ text: '{managers:errors:16}', type: 'error' }).show(); {/if}
    {if isset($errors.permission)}          new Noty({ text: '{managers:errors:11}', type: 'error' }).show(); {/if}
    {if isset($errors.invalid_email)}       new Noty({ text: '{managers:errors:12}', type: 'error' }).show(); {/if}
    {if isset($errors.image_not_saved)}     new Noty({ text: '{managers:errors:8}', type: 'error' }).show();{/if}
    {if isset($errors.status_empty)}     new Noty({ text: 'Нужно указать статус', type: 'error' }).show();{/if}

    {if isset($errors.restricted_user_ids)}     new Noty({ text: 'Изменение группы для пользователя с ID {$user.userId|default:''} невозможна!', type: 'error' }).show();{/if}
    {if isset($errors.no_developer_creation)}	new Noty({ text: '«Администратор» не может создать пользователя с группой «Разработчик».', type: 'error' }).show();{/if}
    {if isset($errors.last_admin)}     			new Noty({ text: 'Вы не можете изменить у пользователя группу «Администратор».', type: 'error' }).show();{/if}

    {if isset($messages.saved)} new Noty({ text: '{managers:messages:0}', type: 'success' }).show(); {/if}
});


</script>
