
	<!-- Page header -->
	{capture name="buttons"}
		<a class="btn btn-sm btn-icon btn-primary" data-bs-popup="tooltip" title="{general:add}" data-bs-placement="auto" href="{$adminUrl}/manager?action=add{if !empty($page)}&page={$page}{/if}"><i class="ph-plus"></i></a>
	{/capture}
	{capture name="breadcrumb"}
		<a href="{$adminUrl}/managers" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
	{/capture}

	{capture name="showBy"}
	    {include file="module/show-by.tpl" url="{$adminUrl}/managers"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->


	<div class="content">


		<div class="card border shadow-sm">
			<form action="{$generate_url}" method="post">
				<div class="card-header bg-light py-2 d-sm-flex align-items-sm-center">
					<div class="mb-0">
						<div class="input-group">
							<input type="text" class="form-control" name="query" value="{$query|default:''}" autocomplete="off" placeholder="{general:searchByName}">
							<button type="submit" class="btn btn-sm btn-primary"><i class="icon-search4 me-2"></i>{general:search}</button>
						</div>
					</div>

					<div class="ms-sm-auto">
						<ul class="list-inline list-inline-condensed mb-0">
							<li class="list-inline-item">
								<div class="input-group">
									{if isset($groups) && !empty($groups)}
										{html_options options=$groups selected=$filter.group|default:'' name="filter[group]" class="form-control select" onchange="this.form.submit()" data-width="250"}
									{/if}

									{if isset($statuses) && !empty($statuses)}
										{html_options options=$statuses selected=$filter.status|default:'' name="filter[status]" class="form-control select" onchange="this.form.submit()" data-width="160"}
									{/if}
								</div>
							</li>
						</ul>
					</div>
				</div>
			</form>
		</div>

	    <div class="card border shadow-sm">
		    <div class="table-responsive">
		        <table class="table table-togglable table-xs table-striped table-hover managers-archive" id="{$module}">
	            <thead>
	                <tr>
						<th class="text-start gridjs-th-sort main-th-col-sortable" onclick="tableSort(this, '{$module}'); return false;" data-sort-by="fullName" data-sort-order="{if isset($sortOrder.column) && $sortOrder.column eq 'fullName'}{if $sortOrder.sort eq 'asc'}desc{else}asc{/if}{else}asc{/if}">{managers:title} <button class="gridjs-sort gridjs-sort-{if isset($sortOrder.column) && $sortOrder.column eq 'fullName'}{$sortOrder.sort}{else}neutral{/if}"></button></th>
						<th class="text-start gridjs-th-sort main-th-col-sortable" onclick="tableSort(this, '{$module}'); return false;" data-sort-by="email" data-sort-order="{if isset($sortOrder.column) && $sortOrder.column eq 'email'}{if $sortOrder.sort eq 'asc'}desc{else}asc{/if}{else}asc{/if}">{managers:email} <button class="gridjs-sort gridjs-sort-{if isset($sortOrder.column) && $sortOrder.column eq 'email'}{$sortOrder.sort}{else}neutral{/if}"></button></th>
						<th data-toggle="true">{general:table:type}</th>
						<th data-toggle="true">{general:table:status}</th>
						<th class="text-center text-muted" width="30">
							<div class="btn-group">
								<a href="javascript:void(0);" class="align-items-center text-body dropdown-toggle" data-bs-toggle="dropdown"><i class="ph-gear"></i></a>
								<div class="dropdown-menu" style="">
									<button class="dropdown-item" onclick="clearTableSort(this, '{$module}'); return false;" type="button"><i class="ph-check me-2"></i>Сбросить сортировку</button>
								</div>
							</div>
						</th>
	                </tr>
	            </thead>
	            {if !empty($managers)}
					<tbody>
						{foreach item=manager from=$managers name=managers}
							<tr id="{$module|substr:0:-1}-{$manager.userId}" class="">
								<td class="text-nowrap">
									<div class="d-flex align-items-center">
										<div class="status-indicator-container me-3">
											<img src="{$manager.image.medium|default:'/admin/assets/images/no_images.jpg'}" class="rounded-circle" width="40" height="40">
											<span class="status-indicator {if $manager.status eq 1}bg-success{elseif $manager.status eq 1}bg-slate{elseif $manager.status eq 2 || $manager.status eq 3}bg-danger{elseif $manager.status eq 4 || $manager.status eq 5}bg-primary {else}bg-grey{/if} mr-1"></span>
										</div>
										<div>
											<a href="{$adminUrl}/manager?action=edit&id={$manager.userId}" class="text-body fw-semibold letter-icon-title">{$manager.fullName|default:''}</a>
											<div class="d-flex align-items-center text-muted fs-sm">{$manager.lastLogin|date_format:"%d.%m.%Y %H:%M"}</div>
										</div>
									</div>
								</td>

								<td class="text-nowrap">{$manager.email|default:'Email не указан'}</td>
								<td class="text-nowrap">{$manager.name}</td>
								<td class="text-nowrap">{$manager.statusName}</td>
								<td class="text-left">
									<div class="d-inline-flex">
										<a class="text-primary me-2" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="top" href="{$adminUrl}/manager?action=edit&id={$manager.userId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil"></i></a>
										<button class="btn btn-link text-danger p-0" onclick="remove({$manager.userId}, '{$manager.fullName|escape|default:""}', '{$module}');"><i class="ph-trash"></i></button>
									</div>
								</td>
							</tr>
						{/foreach}
					</tbody>
	            {else}
	            	<tbody><tr class="odd"><td class="text-center" colspan="5">- {general:none} -</td></tr></tbody>
	            {/if}
	        </table>
		    </div>
	        {include file="module/pagination.tpl" url="{$adminUrl}/managers" params="{$buildQueryString}"}
	    </div>
	</div>

	<script>

	    function deleteSuccess(id) {
	        new Noty({ text: '{managers:messages:1}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
	        removeElement(id, 'manager');
	    }

	    function deleteError() {
	        new Noty({ text: '{managers:errors:15}', layout: 'topRight', type: 'error' }).show();
	    }

	    function userNotFound() {
	        new Noty({ text: '{managers:errors:1}', layout: 'topRight', type: 'error' }).show();
	    }

	    function notDeleteAdministrator() {
	        new Noty({ text: '{managers:errors:6}', layout: 'topRight', type: 'error' }).show();
	    }

	    function notDeleteDeveloper() {
	        new Noty({ text: '{managers:errors:14}', layout: 'topRight', type: 'error' }).show();
	    }



	</script>


