<?php

namespace Mnv\Core\Bot;

use Mnv\Core\Singleton\SingletonTrait;

class TelegramNotifications
{

    use SingletonTrait;

    /** @var $_config */
    private $_config;

    /** Config constructor. */
    public function __construct()
    {
        $this->_config = require GLOBAL_ROOT . '/includes/config.telegram.inc.php';
    }

    /**
     * Получение настроек
     * @return array|mixed|null
     */
    public function config()
    {
        return $this->_config;
    }

    /**
     * @param string $codename
     * @param string $value
     */
    public function set(string $codename, string $value): void
    {
        $this->_config[$codename] = $value;
    }

    /**
     * @param string $codename
     * @return mixed|null
     */
    public function get(string $codename)
    {
        if (array_key_exists($codename, $this->_config)) {
            return $this->_config[$codename];
        }

        $trace = debug_backtrace();
        trigger_error('Неопределённое свойство в get(): ' . $codename . ' в файле ' . $trace[0]['file'] . ' на строке ' . $trace[0]['line'], E_USER_NOTICE);
        return null;
    }

    /**
     * @param string $codename
     * @return mixed
     */
    public static function getValue(string $codename)
    {
        return self::init()->get($codename);
    }
}