<?php

namespace Mnv\Core\Locale;

/**
 * Class I18N
 * @package Mnv\Core\Locale
 */
final class I18N
{
    /** @var int */
    protected static $index;

    /** @var string  */
    public static $mainLanguage = 'ru';

    /** @var string[]  */
    public static $languages = ['ru', 'uz', 'en'];

    /**
     * @param string|null $websiteLanguage
     */
    public static function set(?string $websiteLanguage): void
    {
        self::$mainLanguage = $websiteLanguage;
        $refererPath = $_SERVER['HTTP_REFERER'] ?? null;

        if ($refererPath) {
            $segments = explode('/', parse_url($refererPath, PHP_URL_PATH) ?? '');

            // Проверяем наличие языка в первом сегменте URL
            self::$index = isset($segments[1]) && in_array($segments[1], self::$languages)
                ? $segments[1]
                : self::$mainLanguage;
        } else {
            self::$index = self::$mainLanguage;
        }
    }

    /**
     * @param string|null $ru
     * @param string|null $uz
     * @param string|null $en
     * @return mixed|string
     */
    public static function locale(string $ru, string $uz = null, string $en = null)
    {

        self::$languages = ['ru' => $ru, 'uz' => $uz, 'en' => $en];

        return self::$languages[self::$index];
    }



}