<?php

namespace Mnv\Core\Security\Csrf;

use Mnv\Core\Security\Csrf\Interfaces\SessionProvider;

/**
 * Class SecurityCsrfCookieProvider
 * @package Mnv\Core\Security\Csrf
 */
class SecurityCsrfCookieProvider implements SessionProvider
{
    /**
     * Get a cookie value.
     *
     * @param string $key
     * @return mixed
     */
    public function get(string $key)
    {
        return $_COOKIE[$key] ?? null;
    }

    /**
     * Set a cookie value.
     *
     * @param string $key
     * @param mixed $value
     * @return void
     */
    public function set(string $key, $value)
    {
        $_COOKIE[$key] = $value;
    }
}
