<?php

namespace Mnv\Core\Table\Parser;

use Mnv\Core\Table\Exception\FileException;

/**
 * SimpleExcel class for parsing JSON table
 *
 * @package JSONParser
 */
class JSONParser extends BaseParser implements IParser
{

    /**
     * Определяет допустимое расширение файла
     *
     * @access   protected
     * @var      string
     */
    protected string $file_extension = 'json';

    /**
     * Load the JSONLANG file to be parsed
     *
     * @param string $file_path  Path to JSON file
     */
    public function loadFile(string $file_path)
    {
        if (!$this->isFileReady($file_path)) {
            return;
        }

        $handle = fopen($file_path, 'r');
        if (filesize($file_path) > 0) {
            $contents = fread($handle, filesize($file_path));
            $this->loadString($contents);
        }
        fclose($handle);
    }


    /**
     * Load the string to be parsed
     *
     * @param string|null $json  String with JSONLANG format
     * @throws \Exception If JSONLANG format is invalid (or too deep)
     */
    public function loadString(?string $json)
    {
        $field = [];
        if (($this->table = json_decode($json, true, 4)) === NULL) {
            throw new \Exception('Invalid JSON format: ' . $json, FileException::MALFORMED_JSON);
        } else {
            foreach ($this->table as $rows) {
                $field[] = $rows;
            }
        }

        $this->table = $field;
    }
}
