<?php


namespace Mnv\Core\Test;

/**
 * Class Log
 * @package Mnv\Core\Test
 */
class Log
{
    private $handle;

    // Define log directory as a constant
    private const LOG_DIR = GLOBAL_ROOT . '/temp/log/';


    /**
     * Log constructor.
     * Initializes the log file handle.
     *
     * @param string $filename The log file name
     * @throws \RuntimeException If the log file cannot be opened
     */
    public function __construct(string $filename)
    {
        $filePath = self::LOG_DIR . $filename;

        // Ensure the log directory exists
        if (!is_dir(self::LOG_DIR)) {
            mkdir(self::LOG_DIR, 0777, true);
        }

        // Open file in append mode
        $this->handle = fopen($filePath, 'a');

        // Check if the file opened successfully
        if (!$this->handle) {
            throw new \RuntimeException("Unable to open log file: $filePath");
        }
    }

    /**
     * Writes a log entry to the file.
     *
     * @param string $message The message to be logged
     * @return void
     */
    public function write(string $message): void
    {
        if ($this->handle) {
            $time = strtotime("+5 hours 00 minutes", strtotime(gmdate('Y-m-d H:i:s')));
            $timestamp = date('Y-m-d H:i:s', $time);
            fwrite($this->handle, "[$timestamp] " . print_r($message, true) . PHP_EOL);
        }
    }

    /**
     * Closes the log file handle on object destruction.
     */
    public function __destruct()
    {
        if ($this->handle) {
            fclose($this->handle);
        }
    }
}