<?php

namespace Mnv\Core\Utilities;

/**
 * Это библиотека для создания GUID
 */
class GUID
{

    /**
     * Генерирует идентификатор GUID
     *
     * @param string $separator тире по умолчанию
     * @param bool $enclose заключить идентификатор GUID в фигурные скобки.
     * @return string
     */
    public static function NewGuid(string $separator = '-', bool $enclose = false) : string
    {

        $enclose_open = $enclose ? '{' : '';
        $enclose_close = $enclose ? '}' : '';

        mt_srand((int)microtime() * 10000);
        $hash = md5(uniqid(rand(), true));

        return $enclose_open
            . substr($hash, 0, 8) . $separator
            . substr($hash, 8, 4) . $separator
            . substr($hash, 12, 4) . $separator
            . substr($hash, 16, 4) . $separator
            . substr($hash, 20, 12) . $enclose_close;
    }

    /**
     * Генерируем необработанный GUID не отформатированный и не заключенный в фигурные скобки.
     *
     * @return string
     */
    public static function Create(): string
    {
        return static::NewGuid('', false);
    }


    /**
     * Возвращаем отформатированную строку GUID с тире (или выбранным разделителем), при необходимости заключенную в фигурные скобки
     *
     * @param string $guid A guid string to parse
     * @param bool $enclose
     * @param string $separator
     * @return string
     */

    public static function Format(string $guid, bool $enclose = true, string $separator = '-'): string
    {
        $enclose_open = $enclose ? '{' : '';
        $enclose_close = $enclose ? '}' : '';

        return $enclose_open .substr($guid, 0, 8) . $separator .
            substr($guid, 8, 4) . $separator .
            substr($guid, 12, 4) . $separator .
            substr($guid, 16, 4)  . $separator .
            substr($guid, 20) .
            $enclose_close;
    }



}