<?php

namespace  Mnv\Core\YaMetrika;

use  Mnv\Core\YaMetrika\Exceptions\ClientException;
use TypeError;

abstract class Service
{
    private Client $client;

    /**
     * @param $clientOrConfig
     *
     * @throws ClientException
     */
    public function __construct($clientOrConfig = null)
    {
        if ($clientOrConfig instanceof Client) {
            $this->client = $clientOrConfig;
        } elseif (is_array($clientOrConfig)) {
            $this->client = new Client($clientOrConfig);
        } else {
            throw new TypeError('constructor must be array or instance of Mnv\Core\YaMetrika\Client');
        }
    }

    /**
     * Get HTTP client
     *
     * @return Client
     */
    protected function getClient(): Client
    {
        return $this->client;
    }
}
