<?php

namespace Mnv\Models;

use Mnv\Core\Model;
use Mnv\Core\Test\Logger;
use Mnv\Http\Request;
use Mnv\Models\Exceptions\NotFoundException;

/**
 * Class Banners
 * @package Mnv\Models
 */
class Banners extends Model
{
    /** @var string */
    protected string $table = 'banners';

    /** @var string  */
    protected string $table_image = 'banner_images';
    protected string $table_banner_sections = 'banner_sections';

    /** @var string  */
    protected string $primaryKey = 'bannerId';

    /** @var string  */
    protected string $orderBy = 'orderBy ASC';

    public $bannerIds;
    public ?array $sectionIds = null;

    public function __construct(Request $request)
    {
        $this->id           = $request->get('id');
        $this->data         = $request->get('banner');
        $this->bannerIds    = $request->get('ids');

        $this->sectionIds   = $request->get('sectionIds');
    }

    public function prepare(array $data, int $managerId): bool
    {
        $data['modifiedBy']   = $managerId;
        $data['modifiedOn']   = gmdate('Y-m-d H:i:s');

        if (empty($this->id)) {
            $data['addedBy'] = $managerId;
            $data['addedOn'] = gmdate('Y-m-d H:i:s');
            $data['orderBy'] = $this->getMaxValue('orderBy') + 1;
            if ($this->id = $this->insert($data)) {
                return true;
            }
        } else {
            if ($this->update($data)) {
                return true;
            }
        }

        return false;
    }

    /**
     * Удаление
     *
     * @return bool
     *
     * @throws Exceptions\NoContentException
     * @throws NotFoundException
     * @throws \Mnv\Core\Database\Throwable\DatabaseException
     */
    public function remove(): bool
    {
        if (parent::remove()) {
            // Delete an entry from the banner_sections table
            connect($this->table_banner_sections)->where($this->primaryKey, $this->id)->delete();

            return true;
        }

        return false;
    }

    /**
     * @return bool
     */
    public function pages(): bool
    {
        if (empty($this->id)) {
            return false;
        }

        connect($this->table_banner_sections)->where('bannerId', $this->id)->delete();

       foreach ($this->sectionIds as $sectionId) {
           connect($this->table_banner_sections)->insert([
               'bannerId' => $this->id,
               'sectionId' => $sectionId
           ]);
       }
       return true;
    }

    public function sectionIds(): array
    {
        return connect($this->table_banner_sections)->where('bannerId', $this->id)->pluck('sectionId', 'sectionId');
    }

    public function sections($bannerId)
    {
        if (empty($bannerId)) {
            return [];
        }

        return connect($this->table_banner_sections)->usingJoin('sections', 'sectionId')->where('bannerId', $bannerId)->pluck('name', 'sectionId');
    }

}