<?php

namespace Mnv\Models;

use Mnv\Http\Request;
use PHPMailer\PHPMailer\SMTP;

/**
 * Class Settings
 * @package Mnv\Models
 */
class Settings
{
    /** @var string */
    protected string $table = 'settings';

    /** @var array|mixed  */
    public $setting = array();

    /** @var array  */
    public array $resultSmtp = [
        'status'  => false,
        'message' => '',
        'trace'   => '',
    ];


    public function __construct(Request $request)
    {
        $this->setting = $request->get('settings');
    }


    public function all()
    {
       return connect()->table($this->table)->select('codename, value')->pluck('value','codename');
    }

    public function update($data)
    {
        connect()->table($this->table)->replace($data);
    }

    public function statsTime()
    {
        return connect()->table('stats_visitors')->min('firstVisitOn')->getValue();
    }


    public function stats_user_agents($bots)
    {
        connect()->table('stats_user_agents')->updateConcat("isBot", "IF(userAgent RLIKE '" . $bots . "', 1, 0)");
    }


    public function updateUrl($old_site_url, $new_site_url)
    {
        connect()->table('sections')->updateConcat("url", "replace(url, '" . $old_site_url . "', '" . $new_site_url. "')");
        connect()->table('articles')->updateConcat("url", "replace(url, '" . $old_site_url . "', '" . $new_site_url. "')");
    }


    public function updateExtension($oldExtension, $newExtension)
    {
        connect()->table('sections')->like('url', '%.'.$oldExtension.'')->updateConcat("url", "CONCAT(LEFT(`url`, CHAR_LENGTH(url)-CHAR_LENGTH('$oldExtension')), '$newExtension')");
        connect()->table('articles')->like('url', '%.' . $oldExtension .'')->updateConcat("url", "CONCAT(LEFT(`url`, CHAR_LENGTH(url)-CHAR_LENGTH('$oldExtension')), '$newExtension')");
    }

    /**
     * TODO: доработать удаление статистики
     * @param $date
     */
    public function deleteStatsPriorTo($date): void
    {
        global $tbl;

        $visitsByType = array();
        $type2table = array(
            2  => 'stats_section_visits',
            3  => 'stats_article_visits',
            4  => 'stats_search_visits',
            5  => 'stats_ad_clicks',
            6  => 'stats_error_visits',
            7  => 'stats_rss_visits'
        );

        $date = date("Y-m-d", strtotime($date));

        do {
            if ($visitors = connect('stats_visitors')->select('visitorId')->where('firstVisitOn', '<', $date)->limit(1000)->pluck('visitorId', 'visitorId')) {
                do {
                    if ($visits = connect('stats_visits')->select('visitId, typeId')->in('visitorId', array_keys($visitors))->limit(1000)->pluck('typeId', 'visitId')) {
                        foreach ($visits as $visitId => $typeId) {
                            if (!isset($visitsByType[$typeId])) $visitsByType[$typeId] = array();
                            $visitsByType[$typeId][] = $visitId;
                        }
                        /* deleting each type of visit */
                        foreach($visitsByType as $typeId => $typeVisits) {
                            if (!empty($tbl[$type2table[$typeId]])) {
                                connect($type2table[$typeId])->in('visitId', $typeVisits)->delete();
                            }
                        }

                        /* deleting all visits */
                        connect('stats_visits')->in('visitId', array_keys($visits))->delete();
                    }
                } while (!empty($visitsArr));

                /* deleting visitors */
                connect('stats_visitors')->in('visitorId', array_keys($visitors))->delete();
            }
        } while (!empty($visitors));
    }

    /** Тестировать подключение SMTP */
    public function testSMTP()
    {

        if ((int)$this->setting['smtp_port'] === 465) {
            /** Добавляем протокол, если не указали */
            $this->setting['smtp_server'] = (strpos($this->setting['smtp_server'], "ssl://") === false) ? "ssl://" . $this->setting['smtp_server'] : $this->setting['smtp_server'];
        }

        ob_start();

        $smtp = new SMTP;
        /** Включить вывод отладки на уровне подключения */
        $smtp->do_debug = SMTP::DEBUG_CONNECTION;
        /** Подключение к SMTP-серверу */
        if (!$smtp->connect($this->setting['smtp_server'], $this->setting['smtp_port'])) {
            $this->resultSmtp['message'] = 'Connect failed';
        }
        // Say hello
        if (!$smtp->hello(gethostname())) {
            $this->resultSmtp['message'] = 'EHLO failed: ' . $smtp->getError()['error'];
        }
        /** Получаем список служб ESMTP, предлагаемых сервером */
        $e = $smtp->getServerExtList();
        /** Если сервер может выполнять шифрование TLS, используйте его */
        if (is_array($e) && array_key_exists('STARTTLS', $e)) {
            $tlsOk = $smtp->startTLS();
            if (!$tlsOk) {
                $this->resultSmtp['message'] = 'Failed to start encryption: ' . $smtp->getError()['error'];
            }
            /** Повторите EHLO после STARTTLS */
            if (!$smtp->hello(gethostname())) {
                $this->resultSmtp['message'] = 'EHLO (2) failed: ' . $smtp->getError()['error'];
            }
            /** Получите список новых возможностей, который обычно теперь будет включать авторизацию, если раньше этого не было */
            $e = $smtp->getServerExtList();
        }
        /** Если сервер поддерживает аутентификацию, сделайте это (даже если нет шифрования) */
        if (is_array($e) && array_key_exists('AUTH', $e)) {
            if ($smtp->authenticate($this->setting['smtp_user'], $this->setting['smtp_pass'])) {
                $this->resultSmtp['message'] = 'Connected ok!';
                $this->resultSmtp['status']  = true;
            } else {
                $this->resultSmtp['message'] = 'Authentication failed: ' . $smtp->getError()['error'];
            }
        }

        /** Что бы ни случилось, разрываем связь. */
        $smtp->quit(true);

        $this->resultSmtp['trace'] = nl2br(ob_get_clean());

    }


}