<?php

use Mnv\Core\Helpers\StringHelper;


/**
 * проверяем, что функция mb_ucfirst не объявлена и включено расширение mbstring (Multibyte String Functions)
 */
    if (!function_exists('mb_ucfirst') && extension_loaded('mbstring')) {
        /**
         * mb_ucfirst - преобразует первый символ в верхний регистр
         * @param string $str - строка
         * @param string $encoding - кодировка, по-умолчанию UTF-8
         * @return string
         */
        function mb_ucfirst($str, $encoding = 'UTF-8')
        {
            $str = mb_ereg_replace('^[\ ]+', '', $str);
            return mb_strtoupper(mb_substr($str, 0, 1, $encoding), $encoding). mb_substr($str, 1, mb_strlen($str), $encoding);
        }
    }


    /** Language */
    function getLanguages(): array
    {
        $languages = array();

        $dh = opendir(GLOBAL_ROOT.'/admin/languages');
        while ($item = readdir($dh)) {
            if ($item != '.' && $item != '..' && $item != '.DS_Store' && is_file(GLOBAL_ROOT . "/admin/languages/$item")) {
                $L = include(GLOBAL_ROOT . "/admin/languages/$item");
                $languages[$L['codeName']] = text2unicode($L['langName'], $L['charset']);
            }
        }
        closedir($dh);

        return array_reverse($languages);
    }


    /**
     * @param $date
     * @return array|string
     */
    function langDate($date)
    {
        global $L;
        $date = strtr($date, $L['dates']);
        return array2unicode($date);
    }


    /**
     * @param string $tag
     * @param string|null $default
     * @return int
     */
    function langLen(string $tag, ?string $default = ''): int
    {
        $text = getTagVal($tag, $default);
        return strlen($text);
    }

    /**
     * @param string $tag
     * @param string|null $default
     * @return array|string
     */
    function langJs(string $tag, ?string $default = '') {
        $text = getTagVal($tag, $default);
        return array2js($text);
    }

    /**
     * @param string $tag
     * @param string|null $default
     * @return array|string
     */
    function lang(string $tag, ?string $default = '') {
        $text = getTagVal($tag, $default);
        return array2unicode($text);
    }

    /**
     * @param $source
     * @return null|string|string[]
     */
    function replaceLanguageTags($source) {
        global $adminLang, $L;
        if ( !isset($L) ) loadLanguage($adminLang);
        return preg_replace_callback('/{([0-9a-zA-Z_\-:]+?)}/', '_replace_lang_tags_callback', $source);
    }

    /**
     * @param $matches
     * @return array|string
     */
    function _replace_lang_tags_callback($matches) {
        $text = getTagVal($matches[1], $matches[0]);
        return array2unicode($text);
    }

    /**
     * @param $tag
     * @param $default
     * @return mixed
     */
    function getTagVal($tag, $default) {
        global $L;

        $result = '';
        $keys = explode(':', $tag);
        switch (count($keys)) {
            case 1:
                $result = $L[$keys[0]] ?? $default;
                break;
            case 2:
                $result = $L[$keys[0]][$keys[1]] ?? $default;
                break;
            case 3:
                $result = $L[$keys[0]][$keys[1]][$keys[2]] ?? $default;
                break;
            case 4:
                $result = $L[$keys[0]][$keys[1]][$keys[2]][$keys[3]] ?? $default;
                break;
        }

        return $result;
    }

    /**
     * @param $var
     * @return array|string
     */
    function array2js($var) {
        global $L;

        if (is_array($var)) {
            return array_map('array2js', $var);
        }

        return text2js($var, $L['charset']);
    }

    /**
     * @param $text
     * @param $encoding
     * @return string
     */
    function text2js($text, $encoding): string
    {
        return text2unicode($text, $encoding);
    }

    /**
     * @param $var
     * @return array|string
     */
    function array2unicode($var) {
        global $L;

        if (is_array($var)) {
            return array_map('array2unicode', $var);
        }

        return text2unicode($var, $L['charset']);
    }

    /**
     * @param $text
     * @param $encoding
     * @return string
     */
    function text2unicode($text, $encoding): string
    {
        mb_internal_encoding('UTF-8');
        if (!$encoding) {
            $encoding = mb_detect_encoding($text, mb_list_encodings(), true) ?: 'UTF-8';
        }
//        var_dump($encoding);

        return mb_convert_encoding($text, 'UTF-8', $encoding);
    }

    /**
     * @param $language
     */
    function loadLanguage($language) {
        global $L;

        if (is_file(GLOBAL_ROOT.'/admin/languages/'.$language.'.inc.php')) {
            $L = include(GLOBAL_ROOT.'/admin/languages/'.$language.'.inc.php');
        } else {
            $L = include(GLOBAL_ROOT . '/admin/languages/ru.inc.php');
        }
    }


    function pluralLanguage($value, $type)
    {
        // Определение правильной формы в зависимости от числа
        if ($value % 10 == 1 && $value % 100 != 11) {
            return lang("login:$type:0"); // Единственное число
        } elseif ($value % 10 >= 2 && $value % 10 <= 4 && ($value % 100 < 10 || $value % 100 >= 20)) {
            return lang("login:$type:1");  // Множественное число (2-4)
        } else {
            return lang("login:$type:2"); // Множественное число (5+)
        }
    }

    /** END Language */

	/**
     * @method gmNow
     * @return false|string
     */
    function gmNow() {
        return gmdate('Y-m-d H:i:s');
    }

    function htmlspecialcharsbx($string, $flags = ENT_COMPAT, $doubleEncode = true)
    {
        //function for php 5.4 where default encoding is UTF-8
        return htmlspecialchars($string, $flags, (defined("BX_UTF") ? "UTF-8" : "ISO-8859-1"), $doubleEncode);
    }

    function htmlspecialcharsEx($str)
    {
        static $search =  array("&amp;",     "&lt;",     "&gt;",     "&quot;",     "&#34;",     "&#x22;",     "&#39;",     "&#x27;",     "<",    ">",    "\"");
        static $replace = array("&amp;amp;", "&amp;lt;", "&amp;gt;", "&amp;quot;", "&amp;#34;", "&amp;#x22;", "&amp;#39;", "&amp;#x27;", "&lt;", "&gt;", "&quot;");

        return StringHelper::str_replace($search, $replace, $str);
    }

    function htmlspecialcharsback($str)
    {
        static $search =  array("&lt;", "&gt;", "&quot;", "&apos;", "&amp;");
        static $replace = array("<",    ">",    "\"",     "'",      "&");

        return StringHelper::str_replace($search, $replace, $str);
    }

	/**
	 * @param $variable
	 * @param bool|false $return
	 * @return string|null
	 */
	function improved_var_export($variable, bool $return = false): ?string
    {
		if ($variable instanceof stdClass) {
			$result = '(object) ' . improved_var_export(get_object_vars($variable), true);
		} else if (is_array($variable)) {
			$array = array();
			foreach ($variable as $key => $value) {
				$array[] = var_export($key, true) . ' => ' . improved_var_export($value, true);
			}
			$result = 'array(' . implode(', ', $array) . ')';
		} else {
			$result = var_export($variable, true);
		}

		if (!$return) {
			print $result;
			return null;
		}

        return $result;
    }

    
    /**
     * @param $path
     * @param string $pattern
     * @return array
     */
    function searchDir($path, $pattern = '*.*')
	{
    	$files = array();
    	$dh = opendir($path);
    	$pattern = preg_quote($pattern);
    	$pattern = str_replace('\\*', '.*?', $pattern);
    	while($file = readdir($dh)) if(preg_match("/^$pattern$/i", $file) && $file != '.' && $file != '..') $files[] = $file;
    	sort($files);
    	closedir($dh);
    	return $files;
    }


?>	