<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        http://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

use Mnv\Core\Uploads\ImageSizes;

function smarty_function_fetch_form($params, &$smarty) {

    $assign = fetch_getParam('assign', $params, 'form');
    $fields = fetch_getParam('fields', $params, 'f.formId, f.name, f.fileName, f.content, f.method, f.endpoint, f.status, f.enableCsrfToken, fi.fileId');
    $status = fetch_getParam('status', $params, 'V');
    $from   = (int) fetch_getParam('from', $params);

    if (empty($from)) {
        return null;
    }

    // Загружаем форму
    $form = connect('forms AS f')
        ->leftJoin('form_images AS fi', 'fi.formId', 'f.formId')
        ->select($fields)
        ->where('f.formId', $from)
        ->where('f.status', $status)
        ->orderBy('f.orderBy')
        ->cache(3600)
        ->get('array');


    // Проверяем, есть ли форма
    if (!empty($form)) {
        if (!empty($form['fileId'])) {
            if ($file = connect('files')->select('path, fileName')->where('fileId', $form['fileId'])->get('array')) {
                $form['image'] = ImageSizes::init()->get($form, $file);
            }
        }
        $form['fields'] = getFormFields($form['formId'], false, $status);
        $form['buttons'] = getFormFields($form['formId'],true, $status);
    } else {
        $form = [];
    }

//    print_r($form);

    $smarty->assign($assign, $form);


    return null;
}

/**
 * Получение полей формы.
 *
 * @param int $formId
 * @return array
 */
function getFormFields(int $formId, bool $button, $status): array
{
    if (!empty($button)) {
        connect()->where('fieldType', 'B');
    } else {
        connect()->notWhere('fieldType', 'B');
    }
    $fields = connect('form_fields')
        ->select('fieldId, fieldType, inputType, buttonType, label, name, value, description, className, options, attributes, groupPosition')
        ->where('formId', $formId)
        ->where('status', $status)
        ->orderBy('orderBy')
        ->cache(3600)
        ->getAll('array');

    if (empty($fields)) {
        return [];
    }

    // Преобразовываем данные через array_map для повышения скорости работы с массивами
    foreach ($fields as &$field) {
        $field['options'] = decodeJson($field['options']);
        $field['attributes'] = decodeJson($field['attributes']);
    }

    return $fields;
}

/**
 * Оптимизированная функция для декодирования JSON.
 *
 * Проверяет пустые и некорректные значения перед вызовом json_decode.
 *
 * @param string|null $jsonString
 * @return array
 */
function decodeJson(?string $jsonString): array
{
    return !empty($jsonString) && is_string($jsonString)
        ? json_decode($jsonString, true) ?? []
        : [];
}

