<?php


function smarty_function_script($params, &$smarty)
{
    static $scripts = array();

    if (!isset($scripts[$params['src']])) {
        $src = $params['src'];

        $scripts[$params['src']] = '<script'
            . (!empty($params['class']) ? ' class="' . $params['class'] . '" ' : '')
            . (!empty($params['async']) ? ' async ' : '')
            . (!empty($params['defer']) ? ' defer ' : '')
            . ' src="' . $src . '" ' . (isset($params['charset']) ? ('charset="' . $params['charset'] . '"') : '') . (isset($params['escape']) ? '><\/script>' : '></script>');


        /**
         * Позволяет применить дополнительные атрибуты к скрипту
         *
         * @param array  $scripts List of scripts
         * @param array  $params  Script parameters and attributes
         * @param string $src     Script path
         */

        smarty_function_script_after_formation($scripts, $params, $src);

        return $scripts[$params['src']];
    } else {
        return '<!-- Встроенный скрипт перемещен в нижнюю часть страницы -->';
    }
}

/**
 *
 * Выполненные действия:
 *  - Примените дополнительные атрибуты к скрипту.
 *
 * @param array  $scripts Список скриптов
 * @param array  $params  Параметры и атрибуты скрипта
 * @param string $src     Script path
 *
 * @see smarty_function_script()
 *
 * @return void
 */
function smarty_function_script_after_formation(array &$scripts, array $params, $src)
{
    // phpcs:ignore
    if (isset($params['cookie-name'])) {
        $scripts[$params['src']] = '<script'
            . (!empty($params['class']) ? ' class="' . $params['class'] . '" ' : '')
            . (!empty($params['async']) ? ' async ' : '')
            . (!empty($params['defer']) ? ' defer ' : '')
            . ' type="text/plain"'
            . ' data-type="application/javascript"'
            . ' data-name="' . $params['cookie-name'] . '"'
            . ' data-src="' . $src . '" '
            . (isset($params['charset']) ? ('charset="' . $params['charset'] . '"') : '')
            . (isset($params['escape']) ? '><\/script>' : '></script>');
    }
}

