<?php
/******************************************************************************/
//                                                                            //
//                             Smarty plugin                                  //
//                            @package Smarty                                 //
//							 @subpackage plugins                              //
//                        https://life-style.uz/                               //
//                   produced by Life Style, life-style.uz                    //
//                                                                            //
/******************************************************************************/

use Mnv\Core\Table\TableFactory;

function smarty_function_yandex_statistics($params, &$smarty)
{
    // Путь к файлу конфигурации
    $configPath = GLOBAL_ROOT . '/includes/yandex.config.json';

    // Проверка на существование файла
    if (!file_exists($configPath)) {
        error_log("Файл конфигурации Yandex не найден: " . $configPath);
        return '';
    }

    try {
        // Инициализация JSON парсера
        $jsonFile = new TableFactory('JSON');
        $jsonFile->parser->loadFile($configPath);

        // Получение содержимого файла и поиск нужного значения
        $configData = collect($jsonFile->parser->getField());
        $yandexConfig = $configData->first();

        // Проверка наличия counterId
        $counterId = $yandexConfig['counterId'] ?? null;
        if (empty($counterId)) {
            return ''; // Если ID счетчика не задан, не выводим код
        }

        // Если код метрики задан, используем его, иначе генерируем новый код с использованием counterId
        return !empty($yandexConfig['code'])
            ? $yandexConfig['code']
            : <<<HTML
<!-- Яндекс.Метрика -->
<script type="text/javascript">
   (function(m,e,t,r,i,k,a){m[i]=m[i]||function(){(m[i].a=m[i].a||[]).push(arguments)};
   m[i].l=1*new Date();k=e.createElement(t),a=e.getElementsByTagName(t)[0];
   k.async=1;k.src=r;a.parentNode.insertBefore(k,a)})
   (window, document, "script", "https://mc.yandex.ru/metrika/tag.js", "ym");

   ym($counterId, "init", {
        clickmap: true,
        trackLinks: true,
        accurateTrackBounce: true,
        webvisor: true
   });
</script>
<noscript><div><img src="https://mc.yandex.ru/watch/$counterId" style="position:absolute; left:-9999px;" alt="" /></div></noscript>
<!-- /Яндекс.Метрика -->
HTML;
    } catch (Exception $e) {
        error_log("Ошибка загрузки конфигурации Yandex: " . $e->getMessage());
        return '';
    }
}



?>