export const form = () => {
    let feedback = new Validations(["#feedback"]);

    async function submitFormHandler(form) {
        const controller = new AbortController();

        try {
            if (!(form instanceof HTMLFormElement)) {
                throw new Error("Передан некорректный объект формы.");
            }

            const formAction = form.getAttribute("action");
            const formMethod = form.getAttribute("method") || "POST";

            const formData = new FormData(form);

            new CreatePreloader(form.id);

            const action = form.getAttribute("action");
            if (!action) {
                throw new Error("Форма не имеет атрибута action.");
            }

            const fetchOptions = {
                method: formMethod,
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                },
                body: formData,
                signal: controller.signal,
            };

            const response = await fetch(formAction, fetchOptions);
            if (!response.ok) {
                throw new Error(`Ошибка: ${response.status} ${response.statusText}`);
            }

            const contentType = response.headers.get("Content-Type") || "";
            if (!contentType.includes("application/json")) {
                throw new Error("Некорректный формат ответа от сервера.");
            }

            const data = await response.json();
            handleSuccess(form, data);
        } catch (error) {
            if (error.name === 'AbortError') {
                console.warn('Запрос был отменён:', form.id);
            } else {
                handleError(form, error);
            }
        } finally {
            handleFinally(form);
        }

        return () => controller.abort();
    }

    // Успешная обработка ответа
    function handleSuccess(form, data) {
        if (data && typeof data === 'object') {
            new RemovePreloader(form.id, data.message || 'Успешно', data.status || 'success');
            if (data.status === 200 && data.redirect) {
                setTimeout(() => {
                    window.location.href = data.redirect;
                }, 1000);
            }
        } else {
            new RemovePreloader(form.id, 'Ответ сервера некорректен', 'error');
        }
    }

    // Обработка ошибок
    function handleError(form, error) {
        // console.error('[Ошибка Fetch]:', error); // Логирование в консоль
        new RemovePreloader(form.id, error.message || 'Ошибка запроса', 'error');
    }

    // Очистка после завершения
    function handleFinally(form) {
        // console.log(`[Запрос завершён] ID формы: ${form.id}`);
        // Добавьте действия в случае необходимости
    }

    // Привязка к обработчику
    feedback.request((form) => {
        const abortRequest = submitFormHandler(form);
    });




};
