{include file="header.tpl" title=$article.title keywords=$article.keywords description=$article.description}

<main class="main">

	<section class="both bg-white">
		<div class="both__item">
			<div class="both__desc">
				<a class="btn-back" href="javascript:void(0);" onclick="window.history.back();">ВЕРНУТЬСЯ НАЗАД</a>

				<div class="text-tmp title-48 txt-18 sub-title gap-all-20">
					<p>Портфолио</p>
					<h1>{$article.title}</h1>
					{$article.content nofilter}
				</div>
			</div>
		</div>

		<div class="both__item">
			<div class="both__img">
				<img src="{$article.image.original|default:''}" alt="{$article.title}">
			</div>
		</div>
	</section>


	{if !empty($article.gallery)}
	<section class="full-slider">

		<div class="swiper full-slider_js">
			<div class="swiper-wrapper">
				{foreach from=$article.gallery item=gallery}
					<div class="swiper-slide">
						<div class="full-slider__item">
							<div class="flex:col-max">
								<div class="full-slider__item-desc" data-swiper-parallax="600">
									<div class="text-tmp title-48 txt-20 color-white gap-all-10">
										{if !empty($gallery.title)}<h2>{$gallery.title}</h2>{/if}
										{if !empty($gallery.description)}<p>{$gallery.description}</p>{/if}
									</div>
								</div>
							</div>
							<div class="full-slider__item-img" data-swiper-parallax="90%">
								<img src="{$gallery.original}" alt="{$gallery.title}">
							</div>
						</div>
					</div>
				{/foreach}
			</div>
		</div>

		<div class="full-slider__ui">
			<div class="flex:col-max">

				<div class="full-slider__ui-inner">
					<button class="arrow-slider full-slider-prev_js">
						<svg width="31" height="16" viewBox="0 0 31 16" xmlns="http://www.w3.org/2000/svg">
							<path d="M0.292891 8.70711C-0.0976334 8.31658 -0.0976334 7.68342 0.292891 7.29289L6.65685 0.928932C7.04738 0.538408 7.68054 0.538408 8.07107 0.928932C8.46159 1.31946 8.46159 1.95262 8.07107 2.34315L2.41421 8L8.07107 13.6569C8.46159 14.0474 8.46159 14.6805 8.07107 15.0711C7.68054 15.4616 7.04738 15.4616 6.65685 15.0711L0.292891 8.70711ZM31 9H0.999998V7H31V9Z" />
						</svg>
					</button>

					<button class="arrow-slider full-slider-next_js">
						<svg width="31" height="16" viewBox="0 0 31 16" xmlns="http://www.w3.org/2000/svg">
							<path d="M30.7071 8.70711C31.0976 8.31658 31.0976 7.68342 30.7071 7.29289L24.3431 0.928932C23.9526 0.538408 23.3195 0.538408 22.9289 0.928932C22.5384 1.31946 22.5384 1.95262 22.9289 2.34315L28.5858 8L22.9289 13.6569C22.5384 14.0474 22.5384 14.6805 22.9289 15.0711C23.3195 15.4616 23.9526 15.4616 24.3431 15.0711L30.7071 8.70711ZM0 9H30V7H0V9Z" />
						</svg>
					</button>
				</div>

			</div>
		</div>

	</section>
	{/if}
</main>


{include file="footer.tpl"}