{strip}
{* fieldTemplates *}
{assign var='fieldTemplates' value=[
    'I' => '../form/elements/input.tpl',
    'C' => '../form/elements/checkbox.tpl',
    'S' => '../form/elements/select.tpl',
    'R' => '../form/elements/radio.tpl',
    'T' => '../form/elements/textarea.tpl'
]}
{* /fieldTemplates *}

	{fetch_form assign=form from=1}
	{if !empty($form) && $form.fields}

		<div class="text-tmp title-32 txt-20 gap-all-10">
			<h3>{$form.name}</h3>
			{$form.content nofilter}
		</div>

		<form class="form validation_js" action="{$SITE_URL}/{$form.endpoint}" novalidate id="{$form.fileName}" method="{$form.method}">

			<div class="grid:fr-1 g-gap-40">

				<div class="grid:fr-1 g-gap-20">
					{* fields *}
					{foreach from=$form.fields item=field}
						{if isset($fieldTemplates[$field.fieldType])}
							{include file=$fieldTemplates[$field.fieldType] field=$field}
						{/if}
					{/foreach}
					{* fields *}

					{* Соглашение на обработку персональных данных *}
					{include file="../form/elements/privacy-policy.tpl"}
					{* /Соглашение на обработку персональных данных *}
				</div>


				{* csrf token *}
				{if $form.enableCsrfToken}
					<input type="hidden" name="token" value="{$token|escape}" class="d-none">
				{/if}
				{* csrf token *}

				{* captcha *}
				{include file="../form/elements/captcha.tpl"}
				{* /captcha *}

				{* buttons *}
				{foreach from=$form.buttons item=field}
					{if $field.fieldType eq 'B'}
						{* button submit *}
						{include file="../form/elements/button.tpl" field=$field}
						{* /button submit *}
					{/if}
				{/foreach}
				{* /buttons *}
			</div>
		</form>
	{/if}

{/strip}
