<!DOCTYPE html>
<html lang="{$config.website_language}">
<head>
	{include file="modules/meta.tpl"}
    {include file="modules/link.tpl"}
	{* recaptcha - ОБЯЗАТЕЛЬНО *}
	{include file="modules/recaptcha.tpl"}
	{* /recaptcha - ОБЯЗАТЕЛЬНО *}

	{* Код Яндекс.Метрики *}
	{yandex_statistics}
	{* /Код Яндекс.Метрики *}

	{* CSRF защита *}
	{security_csrf_token assign=token input=false}
	{assign var=token value=$token scope="global"}
	{* /CSRF защита *}

	{* socials *}
	{fetch_socials assign=socials status='V'}
	{assign var=socials value=$socials scope="global"}
	{* /socials *}

</head>

<body>

{fetch_sections assign=headerMenus status="V" headerMenu=1 level=1}


<div class="wrapper">

	<header class="header">
		<div class="flex:col-max">
			<div class="header__inner">
				<div class="header__item">
					<div class="header__logos">
						<!--{* LOGO *}
						{logo link=true classLink="header__logo"}
						{* /LOGO *}-->
						<!--<div class="header__logo-iso">
							<img src="{$ASSETS_URL}/images/icons/logo/logo-iso.svg" alt="iso">
						</div>-->
					</div>
				</div>
				<div class="header__item">
					<nav class="header__nav">
						<ul>
							{foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
								<li><a {if isset($section.sectionId) && $section.sectionId eq $headerMenu.sectionId}class="active"{/if} href="{if !empty($headerMenu.externalLink)}{$headerMenu.externalLink}{else}{$SITE_URL}{$headerMenu.url}{/if}">{$headerMenu.alias}</a></li>
							{/foreach}
						</ul>
					</nav>
					<div class="header__lang">
						<ul>
							<li><span>Ру</span></li>
							<li><a href="{$GLOBAL_URL|cat:"/uz/"}">Uz</a></li>
						</ul>
					</div>

					<button class="header__btn header-btn_js">
						<span class="burger-btn burger-btn_short">
							<span class="burger-btn__item"></span>
						</span>
					</button>
				</div>
			</div>

			<div class="header-mob header-mob_js">
				<div class="header-mob__inner">
					<div class="header-mob__head">
						<div class="header__logos">
							{* LOGO *}
							{logo link=true classLink="header__logo"}
							{* /LOGO *}
							<div class="header__logo-iso">
								<img src="{$ASSETS_URL}/images/icons/logo/logo-iso.svg" alt="iso">
							</div>
						</div>

						<div class="header-mob__lang">
							<ul>
								<li><span>Ру</span></li>
								<li><a href="{$GLOBAL_URL|cat:"/uz/"}">Uz</a></li>
							</ul>
						</div>
					</div>

					<div class="header-mob__content">
						<div class="header-mob__nav">
							<ul>
								{foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
									<li><a {if isset($section.sectionId) && $section.sectionId eq $headerMenu.sectionId}class="active"{/if} href="{if !empty($headerMenu.externalLink)}{$headerMenu.externalLink}{else}{$SITE_URL}{$headerMenu.url}{/if}">{$headerMenu.alias}</a></li>
								{/foreach}
							</ul>
						</div>
					</div>

					<div class="header-mob__footer">
						<div class="text-tmp color-white gap-all-10">
							{fetch_sections assign=helps sections=[30] status="V"}{if !empty($helps)}
								{foreach from=$helps item=help}
									<p><a href="{$SITE_URL}{$help.url}">{$help.name}</a></p>
								{/foreach}
							{/if}
							<p>© 2012 - {$smarty.now|date_format:"%Y"} {$config.website_name}. Все права защищены.</p>
						</div>
					</div>

				</div>
			</div>
		</div>
	</header>