{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

<main class="main">

    {assign var="slides" value=["IDEAL COLOR", "IDEAL COLOR", "IDEAL COLOR", "IDEAL COLOR", "IDEAL COLOR", "IDEAL COLOR"]}
    {assign var="decorWords" value=["intro__decor-words", "intro__decor-words"]}

    <!-- about -->
    {* О КОМПАНИ *}
    {fetch_section assign=aboutSection section=2 status="V"}{if !empty($aboutSection)}
    <section class="intro">

        <div class="intro__decor">
            <div class="intro__decor-item">
                {* Перебираем элементы decorWords: *}
                {foreach from=$decorWords item=decorClass}
                    <div class="{$decorClass}">
                        <div class="swiper intro__decor-words-slider decor-words-slider_js">
                            <div class="swiper-wrapper">
                                {* Перебираем слайды: *}
                                {foreach from=$slides item=slideText}
                                    <div class="swiper-slide">
                                        <div class="intro__decor-words-item"><p>{$slideText}</p></div>
                                    </div>
                                {/foreach}
                            </div>
                        </div>
                    </div>
                {/foreach}
            </div>

            <div class="intro__decor-img">
                <img src="{$aboutSection.image.original|default:''}" alt="{$aboutSection.alias}">
            </div>
        </div>

        <div class="flex:col-max">
            <div class="intro__desc">
                <div class="text-tmp title-128 title-tt-up txt-20 sub-title-accent-1 color-white gap-all-30">
                    <p>{$aboutSection.alias}</p>
                    <!--<h1>{$aboutSection.name|replace:"LLC":"<span>LLC</span>" nofilter}</h1>-->
                    {$aboutSection.content|page_break:0 nofilter}
                </div>

                <a class="btn color-white" href="{$SITE_URL}{$aboutSection.url}"><span></span>Подробнее</a>
            </div>
        </div>

    </section>
    {/if}
    {* /О КОМПАНИ *}

    {* БРЕНДЫ *}
    {fetch_section assign=brandSection section=3 status="V"}{if !empty($brandSection)}
        <section class="flex:col pad-tb-80">
            <div class="flex:col-max">
                <div class="grid:fr-1 g-gap-40">
                    <div class="head">
                        <div class="head__item">
                            <div class="text-tmp title-48 txt-18 sub-title gap-all-20">
                                {$brandSection.content|page_break:0 nofilter}
                            </div>
                        </div>
                        <div class="head__item">
                            <a class="btn" href="{$SITE_URL}{$brandSection.url}"><span></span> Все бренды</a>
                        </div>
                    </div>

                    {fetch_sections assign=brands limit=30 from=$brandSection.sectionId status="V" getImage=true imageType=["general", "gallery"]}{if !empty($brands)}
                    <div class="grid:fr-4 g-gap-20 cards">
                        {foreach from=$brands item=brand name=brandItems}
                            {* brand item *}
                            {include file="items/brand.tpl"}
                            {* /brand item *}
                        {/foreach}
                    </div>
                    {/if}
                </div>
            </div>
        </section>
    {/if}
    {* /БРЕНДЫ *}


    {* СЕРТИФИКАТЫ *}
    {fetch_section assign=certificateSection section=5 status="V" getImageLimit=4 getImagePosition="gallery"}{if !empty($certificateSection)}
    <section class="flex:col pad-tb-80 bg-accent">
        <div class="flex:col-max">
            <div class="grid:fr-1 g-gap-40">
                <div class="head">
                    <div class="head__item">
                        <div class="text-tmp title-48 txt-18 sub-title-accent-1 color-white gap-all-20">
                            {$certificateSection.content|page_break:0 nofilter}
                        </div>
                    </div>
                    <div class="head__item">
                        <a class="btn color-white" href="{$SITE_URL}{$certificateSection.url}"><span></span> Смотреть всё</a>
                    </div>
                </div>

                {if !empty($certificateSection.gallery)}
                    <div class="grid:fr-4 g-gap-20 cards">
                        {foreach from=$certificateSection.gallery item=gallery name=galleries}
                            <a class="card-sertificat" href="{$GLOBAL_URL}{$gallery.link}" target="_blank">
                                <img src="{$gallery.original}" alt="{$gallery.title}">
                            </a>
                        {/foreach}
                    </div>
                {/if}
            </div>
        </div>
    </section>
    {/if}
    {* /СЕРТИФИКАТЫ *}

    {* ПОРТФОЛИО *}
    {fetch_section assign=portfolioSection section=4 status="V" getImageLimit=8 getImagePosition="gallery" }{if !empty($portfolioSection)}
        <section class="flex:col pad-tb-80">
            <div class="flex:col-max">
                <div class="grid:fr-1 g-gap-40">
                    <div class="head border-bot">
                        <div class="head__item">
                            <div class="text-tmp title-48 txt-18 sub-title-accent-1 gap-all-20">
                                <p>{$portfolioSection.alias}</p>
                                <h2>{$portfolioSection.name}</h2>
                            </div>
                        </div>
                        <div class="head__item">
                            <a class="btn" href="{$SITE_URL}{$portfolioSection.url}"><span></span> Смотреть всё</a>
                        </div>
                    </div>

                    {if !empty($portfolioSection.gallery)}
                        <div class="gallery">
                            <div class="gallery__item">
                                {foreach from=$portfolioSection.gallery item=gallery name=galleries}
                                    <div class="card-gallery" data-fancybox="gallery" data-src="{$gallery.original}">
                                        <img src="{$gallery.original}" alt="{$gallery.title}">
                                    </div>
                                {/foreach}
                            </div>
                        </div>
                    {/if}

                </div>
            </div>
        </section>
    {/if}
    {* /ПОРТФОЛИО *}

    {* МАГАЗИНЫ *}
    {fetch_section assign=shopSection section=6 status="V"}{if !empty($shopSection)}
        <section class="both bg-accent">
            <div class="both__item">
                <div class="both__desc">
                    <div class="text-tmp title-48 txt-18 sub-title-accent-1 color-white gap-all-20">
                        {$shopSection.content|page_break:0 nofilter}
                    </div>
                    <a class="btn color-white" href="{$SITE_URL}{$shopSection.url}"><span></span> К магазинам</a>
                </div>
            </div>

            <div class="both__item">
                <div class="both__img">
                    <img src="{$shopSection.image.original|default:''}" alt="{$shopSection.name}">
                </div>
            </div>
        </section>
    {/if}
    {* /МАГАЗИНЫ *}

</main>

{include file="footer.tpl"}





