{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}


{fetch_articles perPage=100 assign=shops section=$section.sectionId order="publishedOn ASC" assignPagination=pagination page=$page path=$section.path seFriendly=true getImage=true}

<main class="main">

	<section class="locations">
		<div class="locations__desc">

			<div class="text-tmp title-48 txt-18 sub-title gap-all-20">
				<p>{$section.alias}</p>
				<h1>{$section.name}</h1>
			</div>

			{* Выберите город *}
			{fetch_sections assign=cities limit=30 from=$section.sectionId status="V"}{if !empty($cities)}
				<div class="input">
					<label for>Выберите город</label>
					<div class="select-custom select-cities_js">
						<select name="city" id>
							{foreach from=$cities item=city name=brandItems}
							<option value="{$city.sectionId}">{$city.name}</option>
							{/foreach}
						</select>
					</div>
				</div>
			{/if}
			{* Выберите город *}

			<div class="locations__content">
				<div class="locations__content-inner">
					{foreach from=$shops item=shop}
						{* shop item *}
						{include file="items/shop.tpl"}
						{* /shop item *}
					{/foreach}
				</div>
			</div>

		</div>

		<div class="locations__map" id="map" data-map-api="{$SITE_URL}/api-shops"></div>

		<div class="map-preloader_js"></div>
	</section>

</main>

{include file="footer.tpl"}